'use strict';

var _errorOverlayMiddleware = require('react-dev-utils/errorOverlayMiddleware');

var _errorOverlayMiddleware2 = _interopRequireDefault(_errorOverlayMiddleware);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class ErrorOverlayPlugin {
  apply(compiler) {
    const className = this.constructor.name;

    if (compiler.options.mode !== 'development') return;

    compiler.hooks.entryOption.tap(className, (context, entry) => {
      const chunkPath = require.resolve('./entry');
      adjustEntry(entry, chunkPath);
    });

    compiler.hooks.afterResolvers.tap(className, ({ options }) => {
      if (options.devServer) {
        const originalBefore = options.devServer.before;
        options.devServer.before = app => {
          if (originalBefore) {
            originalBefore(app);
          }
          app.use((0, _errorOverlayMiddleware2.default)());
        };
      }
    });
  }
}

function adjustEntry(entry, chunkPath) {
  if (typeof entry === 'string') {
    throw new Error(`We currently do not inject our entry code into single-file anonymous entries.
Please use a multi-main (array) or object-form \`entry\` setting for now.`);
  }

  if (Array.isArray(entry)) {
    if (!entry.includes(chunkPath)) {
      entry.unshift(chunkPath);
    }
  } else {
    Object.keys(entry).forEach(entryName => {
      entry[entryName] = adjustEntry(entry[entryName], chunkPath);
    });
  }

  return entry;
}

module.exports = ErrorOverlayPlugin;