-- phpMyAdmin SQL Dump
-- version 2.11.11.3
-- http://www.phpmyadmin.net
--
-- ホスト: localhost
-- 生成時間: 2016 年 2 月 01 日 14:09
-- サーバのバージョン: 5.5.15
-- PHP のバージョン: 5.3.29

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- データベース: `spp8_eact_naretaro`
--

-- --------------------------------------------------------

--
-- テーブルの構造 `dl_totals`
--

CREATE TABLE IF NOT EXISTS `dl_totals` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` int(11) NOT NULL,
  `contents` text CHARACTER SET utf8 NOT NULL,
  `device` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=6535 ;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_contents`
--

CREATE TABLE IF NOT EXISTS `spp_contents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content_type` char(1) DEFAULT NULL,
  `content_code` varchar(32) DEFAULT NULL,
  `content_name` varchar(256) DEFAULT NULL,
  `sale_start_date` date DEFAULT NULL,
  `sale_end_date` date DEFAULT NULL,
  `builtin_flag` tinyint(1) DEFAULT NULL,
  `license_flag` tinyint(1) DEFAULT NULL,
  `store_flag` tinyint(1) DEFAULT NULL,
  `before_purchase_desc` text,
  `after_purchase_desc` text,
  `comment` text,
  `active_flag` tinyint(1) DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  `update_type` int(11) NOT NULL,
  `created_datetime` datetime DEFAULT NULL,
  `updated_datetime` datetime DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `content_code_UNIQUE` (`content_code`),
  KEY `CONTENT_CODE_INDEX` (`content_code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=185 ;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_content_files`
--

CREATE TABLE IF NOT EXISTS `spp_content_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `before_download_desc` text,
  `file_name` varchar(256) DEFAULT NULL,
  `file_size` int(10) unsigned DEFAULT NULL,
  `file_content` longblob,
  `active_flag` tinyint(1) DEFAULT NULL,
  `version` int(10) unsigned DEFAULT NULL,
  `created_datetime` datetime DEFAULT NULL,
  `updated_datetime` datetime DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `content_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `CONTENT_ID_INDEX` (`content_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=399 ;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_content_items`
--

CREATE TABLE IF NOT EXISTS `spp_content_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content_id` int(10) unsigned DEFAULT NULL,
  `child_content_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_content_items_1` (`content_id`,`child_content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_corrections`
--

CREATE TABLE IF NOT EXISTS `spp_corrections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `learner_id` varchar(25) NOT NULL,
  `content_id` int(11) NOT NULL,
  `category_no` int(11) NOT NULL,
  `category_name` varchar(255) NOT NULL,
  `subcategory_no` int(11) NOT NULL,
  `subcategory_name` varchar(255) NOT NULL,
  `quiz_no` int(11) NOT NULL,
  `image_submit` varchar(500) NOT NULL,
  `created_datetime` datetime NOT NULL,
  `correction_person` varchar(50) CHARACTER SET utf32 DEFAULT NULL,
  `correction_datetime` datetime DEFAULT NULL,
  `image_answer` varchar(500) DEFAULT NULL,
  `correction_comment` varchar(500) DEFAULT NULL,
  `mark` int(11) DEFAULT NULL,
  `updated_datetime` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=335 ;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_last_week_learning_records`
--

CREATE TABLE IF NOT EXISTS `spp_last_week_learning_records` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `learner_id` varchar(25) CHARACTER SET utf8 NOT NULL,
  `learning_days` int(11) NOT NULL,
  `learning_time_seconds` int(11) NOT NULL,
  `learning_hours` int(11) NOT NULL,
  `learning_average_minutes` int(11) NOT NULL,
  `learning_progress` int(11) NOT NULL,
  `quiz_progress` int(11) NOT NULL,
  `correct_rate` int(11) NOT NULL,
  `rank_id` int(11) NOT NULL,
  `mark` int(11) NOT NULL,
  `start_app_count` int(11) NOT NULL DEFAULT '0',
  `update_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=177 ;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_learners`
--

CREATE TABLE IF NOT EXISTS `spp_learners` (
  `id` varchar(25) NOT NULL,
  `first_name` varchar(10) NOT NULL,
  `last_name` varchar(10) NOT NULL,
  `first_name_kana` varchar(10) NOT NULL,
  `last_name_kana` varchar(10) NOT NULL,
  `nickname` varchar(10) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `organization_code` varchar(12) NOT NULL,
  `payment_status_id` int(11) NOT NULL,
  `learner_classification_id` int(11) NOT NULL,
  `postal_code` varchar(10) DEFAULT NULL,
  `zone` varchar(255) DEFAULT NULL,
  `address` varchar(50) DEFAULT NULL,
  `address_detail` varchar(50) DEFAULT NULL,
  `created_datetime` datetime NOT NULL,
  `updated_datetime` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_learner_classifications`
--

CREATE TABLE IF NOT EXISTS `spp_learner_classifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `classification_name` varchar(25) CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_learning_logs`
--

CREATE TABLE IF NOT EXISTS `spp_learning_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `insert_datetime` datetime NOT NULL,
  `learner_id` varchar(25) CHARACTER SET utf32 NOT NULL,
  `time_start` datetime DEFAULT NULL,
  `time_end` datetime DEFAULT NULL,
  `learning_date` date DEFAULT NULL,
  `learning_duration` int(11) DEFAULT NULL,
  `statistic_flag` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `LEANER_ID_INDEX` (`learner_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13061 ;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_licenses`
--

CREATE TABLE IF NOT EXISTS `spp_licenses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `license_code` varchar(32) DEFAULT NULL,
  `license_desc` varchar(256) DEFAULT NULL,
  `expired_start_date` date DEFAULT NULL,
  `expired_end_date` date DEFAULT NULL,
  `comment` text,
  `learner_id` varchar(25) NOT NULL,
  `client_used_date` date DEFAULT NULL,
  `creator_id` int(10) unsigned DEFAULT NULL,
  `created_datetime` datetime DEFAULT NULL,
  `updated_datetime` datetime DEFAULT NULL,
  `user_id` int(11) unsigned DEFAULT NULL,
  `check_flag` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `license_code_UNIQUE` (`license_code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1413 ;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_license_contents`
--

CREATE TABLE IF NOT EXISTS `spp_license_contents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `license_id` int(10) unsigned DEFAULT NULL,
  `content_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_license_contents_1` (`license_id`,`content_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1825 ;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_mark_masters`
--

CREATE TABLE IF NOT EXISTS `spp_mark_masters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time_for_mark` int(11) NOT NULL,
  `mark_for_incorrect` int(11) NOT NULL,
  `mark_for_correct` int(11) NOT NULL,
  `mark_for_question` int(11) NOT NULL,
  `mark_for_correction` int(11) NOT NULL,
  `mark_for_start_app` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_organizations`
--

CREATE TABLE IF NOT EXISTS `spp_organizations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code_large` varchar(4) CHARACTER SET utf8 NOT NULL,
  `code_middle` varchar(4) CHARACTER SET utf8 NOT NULL,
  `code_small` varchar(4) CHARACTER SET utf8 NOT NULL,
  `organization_name` varchar(255) CHARACTER SET utf8 NOT NULL,
  `allowed_registration_no` int(11) NOT NULL DEFAULT '0',
  `registration_no` int(11) NOT NULL DEFAULT '0',
  `days_of_usage` int(11) NOT NULL DEFAULT '0',
  `certificate` tinyint(1) NOT NULL,
  `payment_method_id` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=68 ;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_organization_contents`
--

CREATE TABLE IF NOT EXISTS `spp_organization_contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `organization_id` int(11) NOT NULL,
  `content_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=247 ;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_payment_methods`
--

CREATE TABLE IF NOT EXISTS `spp_payment_methods` (
  `id` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `method_name` varchar(25) CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_payment_statuses`
--

CREATE TABLE IF NOT EXISTS `spp_payment_statuses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_status_name` varchar(255) CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_pull_messages`
--

CREATE TABLE IF NOT EXISTS `spp_pull_messages` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `message` varchar(200) CHARACTER SET utf8 NOT NULL,
  `created_datetime` datetime NOT NULL,
  `delivery_date` date DEFAULT NULL,
  `rank_id` int(11) DEFAULT NULL,
  `organization_code` varchar(12) CHARACTER SET utf8 DEFAULT NULL,
  `learner_id` varchar(25) CHARACTER SET utf8 DEFAULT NULL,
  `all` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=ascii AUTO_INCREMENT=21 ;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_questions`
--

CREATE TABLE IF NOT EXISTS `spp_questions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `learner_id` varchar(25) NOT NULL,
  `content_id` int(11) DEFAULT NULL,
  `category_no` int(11) NOT NULL,
  `category_name` varchar(255) NOT NULL,
  `subcategory_no` int(11) NOT NULL,
  `subcategory_name` varchar(255) NOT NULL,
  `quiz_no` int(11) NOT NULL,
  `question_content` varchar(500) NOT NULL,
  `created_datetime` datetime NOT NULL,
  `original_is_public` tinyint(1) NOT NULL,
  `is_public` tinyint(1) NOT NULL DEFAULT '1',
  `answered_person` varchar(25) DEFAULT NULL,
  `answered_datetime` datetime DEFAULT NULL,
  `answered_content` varchar(500) DEFAULT NULL,
  `mark` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=134 ;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_quiz_logs`
--

CREATE TABLE IF NOT EXISTS `spp_quiz_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `learner_id` varchar(25) CHARACTER SET utf8 NOT NULL,
  `content_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `category_no` int(11) NOT NULL,
  `category_name` varchar(255) CHARACTER SET utf8 NOT NULL,
  `subcategory_no` int(11) NOT NULL,
  `subcategory_name` varchar(255) CHARACTER SET utf8 NOT NULL,
  `quiz_no` int(11) NOT NULL,
  `last_answer` tinyint(1) NOT NULL,
  `answer` text CHARACTER SET utf8 NOT NULL,
  `try_count` int(11) NOT NULL,
  `incorrect_count` int(11) NOT NULL,
  `insert_date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `LEANER_ID_INDEX` (`learner_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=8443 ;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_rank_masters`
--

CREATE TABLE IF NOT EXISTS `spp_rank_masters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rank_no` int(11) NOT NULL,
  `mark` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `extend_days` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_roles`
--

CREATE TABLE IF NOT EXISTS `spp_roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_code` varchar(32) DEFAULT NULL,
  `role_name` varchar(256) DEFAULT NULL,
  `created_datetime` datetime DEFAULT NULL,
  `updated_datetime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `role_code_UNIQUE` (`role_code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_study_records`
--

CREATE TABLE IF NOT EXISTS `spp_study_records` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `learner_id` varchar(25) NOT NULL,
  `start_date` date NOT NULL,
  `learning_days` int(11) NOT NULL,
  `learning_time_seconds` int(11) NOT NULL,
  `learning_hours` int(11) NOT NULL,
  `learning_average_minutes` int(11) NOT NULL,
  `quiz_progress` int(11) NOT NULL,
  `correct_rate` int(11) NOT NULL,
  `rank_id` int(11) NOT NULL,
  `mark` int(11) NOT NULL DEFAULT '0',
  `all_quiz_count` int(10) DEFAULT NULL,
  `all_try_count` int(10) DEFAULT NULL,
  `all_miss_count` int(10) DEFAULT NULL,
  `all_achievement_count` int(10) DEFAULT NULL,
  `start_app_count` int(11) NOT NULL DEFAULT '0',
  `point_update` int(8) NOT NULL DEFAULT '0',
  `learning_progress` int(11) NOT NULL DEFAULT '0',
  `invalid_flg` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `LEANER_ID_INDEX` (`learner_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='spp_study_records' AUTO_INCREMENT=186 ;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_users`
--

CREATE TABLE IF NOT EXISTS `spp_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_name` varchar(32) DEFAULT NULL,
  `user_pwd` varchar(50) DEFAULT NULL,
  `user_desc` varchar(256) DEFAULT NULL,
  `pwd_ng_time` int(11) DEFAULT NULL,
  `limited_datetime` datetime DEFAULT NULL,
  `locked_datetime` datetime DEFAULT NULL,
  `created_datetime` datetime DEFAULT NULL,
  `updated_datetime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_name_UNIQUE` (`user_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=51 ;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_user_organizations`
--

CREATE TABLE IF NOT EXISTS `spp_user_organizations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `organization_id` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=59 ;

-- --------------------------------------------------------

--
-- テーブルの構造 `spp_user_roles`
--

CREATE TABLE IF NOT EXISTS `spp_user_roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `role_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_user_roles_1` (`user_id`,`role_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=746 ;

-- --------------------------------------------------------

--
-- ビュー用の代替構造 `v_active_contents`
--
CREATE TABLE IF NOT EXISTS `v_active_contents` (
`id` int(11) unsigned
,`content_type` char(1)
,`content_code` varchar(32)
,`content_name` varchar(256)
,`sale_start_date` date
,`sale_end_date` date
,`builtin_flag` tinyint(4)
,`license_flag` tinyint(4)
,`store_flag` tinyint(4)
,`before_purchase_desc` text
,`after_purchase_desc` text
,`comment` text
,`active_flag` tinyint(4)
,`version` int(11)
);
-- --------------------------------------------------------
--
-- ビュー用の構造 `v_active_contents`
--
DROP TABLE IF EXISTS `v_active_contents`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `v_active_contents` AS select `sc`.`id` AS `id`,`sc`.`content_type` AS `content_type`,`sc`.`content_code` AS `content_code`,`sc`.`content_name` AS `content_name`,`sc`.`sale_start_date` AS `sale_start_date`,`sc`.`sale_end_date` AS `sale_end_date`,`sc`.`builtin_flag` AS `builtin_flag`,`sc`.`license_flag` AS `license_flag`,`sc`.`store_flag` AS `store_flag`,`sc`.`before_purchase_desc` AS `before_purchase_desc`,`sc`.`after_purchase_desc` AS `after_purchase_desc`,`sc`.`comment` AS `comment`,`sc`.`active_flag` AS `active_flag`,`sc`.`version` AS `version` from (`spp_contents` `sc` join `spp_content_files` `scf`) where ((`sc`.`active_flag` = 1) and (`sc`.`sale_start_date` <= curdate()) and (`sc`.`sale_end_date` >= curdate()) and (`sc`.`id` = `scf`.`content_id`) and (`scf`.`active_flag` = 1)) union all select `sc`.`id` AS `id`,`sc`.`content_type` AS `content_type`,`sc`.`content_code` AS `content_code`,`sc`.`content_name` AS `content_name`,`sc`.`sale_start_date` AS `sale_start_date`,`sc`.`sale_end_date` AS `sale_end_date`,`sc`.`builtin_flag` AS `builtin_flag`,`sc`.`license_flag` AS `license_flag`,`sc`.`store_flag` AS `store_flag`,`sc`.`before_purchase_desc` AS `before_purchase_desc`,`sc`.`after_purchase_desc` AS `after_purchase_desc`,`sc`.`comment` AS `comment`,`sc`.`active_flag` AS `active_flag`,`sc`.`version` AS `version` from (((`spp_contents` `sc` join `spp_content_items` `sci`) join `spp_contents` `scc`) join `spp_content_files` `scf`) where ((`sc`.`active_flag` = 1) and (`sc`.`sale_start_date` <= curdate()) and (`sc`.`sale_end_date` >= curdate()) and (`sc`.`id` = `sci`.`content_id`) and (`sci`.`child_content_id` = `scc`.`id`) and (`scc`.`active_flag` = 1) and (`scc`.`sale_start_date` <= curdate()) and (`scc`.`sale_end_date` >= curdate()) and (`scc`.`id` = `scf`.`content_id`) and (`scf`.`active_flag` = 1));

-- --------------------------------------------------------

--
-- Table structure for table `quizzes`
--

CREATE TABLE IF NOT EXISTS `quizzs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_no` int(11) NOT NULL,
  `subcategory_no` int(11) NOT NULL,
  `quiz_no` int(11) NOT NULL,
  `sentence` mediumtext NOT NULL,
  `comment` mediumtext NOT NULL,
  `keyword` text NOT NULL,
  `related_image_name` text NOT NULL,
  `choice_row_count` int(11) NOT NULL,
  `answer_no` text NOT NULL,
  `time_limit` int(11) NOT NULL,
  `rank` text NOT NULL,
  `content_id` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `CATEGORY_INDEX` (`category_no`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

