<?php
class SppUser extends AppModel {
	var $name = "SppUser";
	
	var $actsAs   = array('Transactional');
	
	var $validate = array(
		'user_name' => array(
			'notEmpty' => array(
				'rule' => 'notEmpty',
				//'message' => 'アカウントを入力してください。'
			),
			'length' => array(
				'rule' => array('maxlength', '32'),
				//'message' => 'ユーザ名は32文字以内で入力してください。'
			),
			'unique' => array(
				'rule' => 'isUnique',
				//'message' => 'このアカウントは既に存在している。'
			),
			'allow' => array(
				'rule' => '|^[0-9a-z]*$|',
				//'message' => 'アカウントは英数字入力可能です。'
			)
		),
		'user_pwd' => array(
			'required' => array(
				'rule' => 'notEmpty',
				//'message' => 'パスワードを入力してください。'
			),
      		'confirm' => array(
      			'rule' => 'checkpasswords',
      			//'message' => 'パスワードが一致しません。'
			),
			'length' => array(
				'rule' => array('minlength', '6'),
				//'message' => 'パスワードは最低6文字を必ず入力してください。 '
			),
			'maxlength' => array(
				'rule' => array('maxlength', '50'),
				//'message' => 'パスワードは50文字以内で入力してください。',
			),
			'allow' => array(
				'rule' => '|^[0-9a-zA-Z]*$|',
				//'message' => 'パスワードは英数字入力可能です'
			)
		),
		'user_desc' => array(
			'notEmpty' => array(
				'rule' => 'notEmpty',
				//'message' => '説明を入力してください。'
			),
			'length' => array(
				'rule' => array('maxlength', '256'),
				//'message' => '説明には256バイト以内で入力してください。'
			)
		),
	);
	
	var $hasAndBelongsToMany = array(
		'SppRole' => array(
			'className' => 'SppRole',
			'joinTable' => 'spp_user_roles',
			'foreignKey' => 'user_id',
			'associationForeignKey' => 'role_id'
		)
	);

	function checkpasswords()
	{
		//echo $this->data['SppUser']['user_pwd'];die;
		if(isset($this->data['SppUser']['user_pwd']) && isset($this->data['SppUser']['user_pwd_confirm'])) {
			if(strcmp($this->data['SppUser']['user_pwd'],$this->data['SppUser']['user_pwd_confirm']) === 0 )
			{
				return true;
			}
		}		
		return false;
	}
	
	function hashPasswords($data, $enforce=false) {
		if($enforce && isset($this->data[$this->alias]['password'])) {
		   if(!empty($this->data[$this->alias]['password'])) {
			   $this->data[$this->alias]['password'] = Security::hash($this->data[$this->alias]['password'], null, true);
			}
		}
 
        return $data;
    }
 
    function beforeSave() {
         //$this->hashPasswords(null, true);
         //$this->data['SppUser']['user_pwd'] = Security::hash($this->data['SppUser']['user_pwd']);
         /*if(empty($this->id)) {
         	$this->data['SppUser']['user_pwd'] = Security::hash($this->data['SppUser']['user_pwd']);
         }*/
    	//parent::beforeSave();
    	 return true; 
    }
	
	/*function checkUnique() {
		$username = $this->data['SppUser']['user_name'];
		$exits = $this->find('all', array('conditions' => array('SppUser.user_name' => $username)));
        return count($exits) ? true : false;
	}*/
}