<?php
class Quizz extends AppModel
{
    public $name = 'Quizz';
    

    /*
     * Author: haitlt
     * Date: 2013/02/20
     * Description: delete quizz by content_id
     * */
    public function deleteByContentId($content_id)
    {

        if (!(is_null($content_id) || empty($content_id))) {

            return $this->deleteAll(array('Quizz.content_id' => $content_id), false);
        }
        return false;
    }

    /*
     * Author: haitlt
     * Date: 2013/02/20
     * Description: insert quizz by content_id
     * */
    public function insertQuizz($quizz)
    {
        if (!(is_null($quizz))) {
            return $this->save($quizz);
        }
        return false;
    }

    
    /**
     * 
     * count all quiz in db
     */
	public function quizCountAll(){
		return $this->find('count', array('fields' => 'Quizz.quiz_no', 'conditions' => array('Quizz.choice_row_count >=' => -1)));
	}
	
	public function checkQuizExisted($content_id, $category_no, $subcategory_no, $quiz_no) {
		$count = $this->find('count', array('conditions' => array('content_id' => $content_id, 
		'category_no' => $category_no, 'subcategory' => $subcategory_no, 'quiz_no' => $quiz_no)));
		if (count == 0){
			return false;
		}
		return true;
	}
	
}