<?php // $Id$
/**
 * @copyright     2011.
 * @package       spp3 web service
 * @since         2011-12-13
 * We use CakePHP(tm) ver 1.3.7
 */

class  SppserverController extends AppController {
	var $name = "SppServer";

	var $uses = array("SppContentFile","SppContent","SppLicense","SppLicenseContent",
					  "SppContentItem","VActiveContent","SppLearningLog","SppLastWeekLearningRecord", 
					  "SppContentItem","DlTotal","SppStudyRecord","SppUser","SppPullMessage",
					  "SppQuestion","SppCorrection", "SppLearner", "SppMarkMaster", "SppQuizLog",
					  "SppRankMaster", "SppDeviceToken", "SppCalendarContent",'SppTimelineContent','SppTag','SppTopImage', 'SppQuizContinueLog');

	var $components = array('Security', 'Pass4v','Email');
	var $helpers = array("pass4v", "Html", "Form");

	/**
	 * Service Server For Video Contents Component
	 *
	 * @var Pass4vComponent
	 */
	var $Pass4v;

	/**
	 * CakePHP Security Component
	 *
	 * @var SecurityComponent
	 */
	var $Security;

	public $autoLayout = false;
	public $autoRender = false;


	function beforeFilter()
	{
		parent::beforeFilter();
//		 if (Configure::read('useSecureAccess')) {
//		 	$this->Security->requireSecure();
//		 }
//		 $this->Security->requirePost();
		
		$this->Auth->allow('getMonthlyLearningInfo', 'getPastLearningInfo', 'getContentList',
						   'downloadContentFiles', 'checkLicense', 'getDescriptionByPurchaseStatus',
						   'getContentBySetId', 'saveStudyInfo', 'getReportForLearner', 'getChartData', 'insertDataIntoSppLearning',
						   'insertDataIntoSppAppLearningInfor', 'quizIncorrectRanking', 'checkListLicense',
						   'getContentsInfo', 'sendDeviceToken', 'pushMessage','insertData','login','getNewestMessage',
						   'saveQuestion','getQuestionList','saveCorrection','getCorrectionList','getCorrection','getMessageList',
						   'learnerLogin','forgetPassword','updateLearnerInfo','getLearnerState', 'getRanks', 'getLearnerListByRank',
						   'getCorrectionEdittedStatus','checkGeneralInfo','downloadContentFilesForWeb', 'getFirstRank',
						   'getTop100ThisWeekLearner', 'updateStartAppDate',
						   'getAllCalendarContents', 'getCalendarContentsByDate', 'getCalendarContentById','learnerLogout',
						   'getTopImage','getTimelineContentList','getTimelineContentByID','getTagList', 'getInfoDeviceLogin', 'updateDeviceToken', 'updateStatusMessage');
	}

	function index() {
		empty($_SERVER['HTTP_REFERER']) ? $referer = "" : $referer = $_SERVER['HTTP_REFERER'];
		$this->Pass4v->accessLog($this->name, "Warn", "(".__FUNCTION__."),Illegal Access", $referer, $_SERVER['HTTP_USER_AGENT']);
		exit;
	}

	function updateStartAppDate() {
		$form = $this->params['form'];
		$xml = Configure::read('useResponseXML');
		if (!$this->Pass4v->firstCheck($form, array('learner_id'), __FUNCTION__, $xml)) {
			return ;
		}
		$studyRecord = $this->SppStudyRecord->findByLearnerId($form['learner_id']);
		if(!empty($studyRecord)) {
			if(!empty($form['latest_start_app'])) {
				$studyRecord['SppStudyRecord']['latest_start_app'] = $form['latest_start_app'];
			}
			if(!empty($form['latest_start_app_from_push'])) {
				$studyRecord['SppStudyRecord']['latest_start_app_from_push'] = $form['latest_start_app_from_push'];
			}
			$this->SppStudyRecord->save($studyRecord);
		} else {
			/*$this->SppStudyRecord->set(array(
			 'learner_id' => $learner_id,
			 'start_date' => date('Y-m-d'),
			 'learning_days' => 0,
			 'learning_time_seconds' => 0,
			 'learning_hours' => 0,
			 'learning_average_minutes' => 0,
			 'learning_progress' => 0,
			 'quiz_progress' => 0,
			 'correct_rate' => 0,
			 'rank_id' =>$this->SppRankMaster->getRankByMark(0)
			 ));*/
		}
		$response = Configure::read('responseSuccess');
		$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
	}
	/**
	 * Get Content List
	 *
	 * @param json string $licenses //ex:[{"license_code":1,"learner_id":1},{"license_code":2,"learner_id":2}]
	 * @param int $pageIndex
	 * @return boolean|array
	 */
	function getContentList(){
		$form = $this->params['form'];
		$conditions = '';
		$limit = '';
		$xml = Configure::read('useResponseXML');
		$numrecordpage = Configure::read('numRecordPage');
		$now = date('Y-m-d');

		$arraykeys = array('licenses','pageIndex');
		if (!$this->Pass4v->firstCheck($form, $arraykeys, __FUNCTION__, $xml)) {
			return ;
		}

		$contentIds = array();
		if (isset($form['licenses']) && !empty($form['licenses'])) {
			$contentIds  = $this->_getLicenseList($form['licenses']);
		}
		if (!empty($form['pageIndex']) && $form['pageIndex'] > 0) {
			$from = ($form['pageIndex']-1)*$numrecordpage;
			$limit = $from.','.$numrecordpage;
		}

		$fields = array('VActiveContent.id', 'VActiveContent.content_code',
        				'VActiveContent.content_type', 'VActiveContent.content_name',
        				'VActiveContent.version', 'VActiveContent.builtin_flag',
        				'VActiveContent.store_flag', 'VActiveContent.subscribe_flag',
        				'VActiveContent.license_flag');

		if (!$contents = $this->VActiveContent->find('all',array('fields'=>$fields,'order' => array('VActiveContent.content_type' => 'Desc','VActiveContent.content_name'=>'ASC'),'group'=>'VActiveContent.id','limit' => $limit))) {
			$this->Pass4v->errorResponse(Configure::read('errorNoContentsListInformation'), "(".__FUNCTION__."),No content list information", $xml);
			return false;
		}

		$index = 0;
		$lists = array();
		$lists['contents'] = array();
		foreach ($contents as $key => $content) {
			$purchaseType = null;
			$isExist = false;
			if (!empty($contentIds)) {
				foreach ($contentIds as $contentId) {
					if($contentId == $content['VActiveContent']['id']) {
						$isExist = true;
						break;
					}
				}
			}
			if ($content['VActiveContent']['subscribe_flag'] == 1) {
				$purchaseType = 3;
			} else if ($content['VActiveContent']['license_flag'] == 1 && $isExist == true) {
				$purchaseType = 2;
			} else if ($content['VActiveContent']['store_flag'] == 1) {
				$purchaseType = 1;
			} else if ($content['VActiveContent']['builtin_flag'] == 1) {
				$purchaseType = 0;
			} else {
				// no license
				continue;
			}

			$lists['contents'][$index]['productId']	= $content['VActiveContent']['content_code'];
			$lists['contents'][$index]['productType'] = $content['VActiveContent']['content_type'];
			$lists['contents'][$index]['productName'] = $content['VActiveContent']['content_name'];
			$lists['contents'][$index]['purchaseType'] = $purchaseType;
			$lists['contents'][$index]['version'] = $content['VActiveContent']['version'];

			$index = $index + 1;
		}
		$lists['free_use_term'] = 0;
		$free_user_term = Configure::read('FREE_USE_TERM');
		if (!empty($free_user_term)) {
			$lists['free_use_term'] = $free_user_term;
		}
		$result['response']= base64_encode(json_encode($lists));
		$response = Configure::read('responseContentsList') + $result;
		$this->Pass4v->response($response, "(".__FUNCTION__."),Get contents list success.",$xml);
	}

	/**
	 * get license list have available
	 *
	 * @params $contents json string //ex:[{"license_code":1,"clientIdentifierNo":1},{"license_code":2,"clientIdentifierNo":2}]
	 * @return array
	 *
	 */
	function _getLicenseList($contents = null)
	{
		$contents = json_decode($contents,true);
		$contentIds = array();
		$now = date('Y-m-d');

		// get license have avaliable
		if (is_array($contents)) {
			foreach ($contents as $content) {
				if (!empty($content['license_code'])) {
					$conditions = array('SppLicense.license_code' => $content['license_code'],
										'SppLicense.expired_start_date <=' => $now,'SppLicense.expired_end_date >=' => $now);

					$licenses = $this->SppLicense->find('all',array('conditions'=>$conditions));
				}

				if (!empty($licenses)) {
					foreach ($licenses as $license) {
						foreach ($license['SppLicenseContent'] as $data) {
							$contentIds[] =  $data['content_id'];
						}
					}
				}
			}
		}

		return $contentIds;
	}

	/**
	 * download content
	 * input: content_id
	 * output :	Err|file download
	 */
	function downloadContentFiles()
	{
		$now = date("Y-m-d H:i:s");
		$now = strtotime($now);
		$form = $this->params['form'];
		/*
		 * @TODO: TUANNM
		 */
		$iPhone = stripos($_SERVER['HTTP_USER_AGENT'],"iPhone");
		$Android= stripos($_SERVER['HTTP_USER_AGENT'],"Android");

		$conditions = array('SppContent.content_code'=> $form['productId']);
		$this->SppContent->unbindModel(array('belongsTo'=>array('SppUser')));
		$this->SppContent->unbindModel(array('hasMany'=>array('SppContentFile','SppContentItem','SppLicenseContent')));
		$content = $this->SppContent->find('first',array('conditions'=>$conditions));

		$device = 0;
		if($iPhone){
			$device = 1;
		} else if($Android){
			$device = 2;
		}

		$this->DlTotal->begin();
		$this->DlTotal->create();
		$dlData = array(
				'DlTotal'=> array(
					'date'=>$now,
					'contents' => $content['SppContent']['content_name'],
					'device' => $device
		));
		if($this->DlTotal->save($dlData)){
			$this->DlTotal->commit();
		}
		/*
		 * END TUANNM'S TODO
		 */

		$xml = Configure::read('useResponseXML');
		$subdir=Configure::read('forderContentUpload');
		if(trim($form['productId']) == NULL)
		{
			$this->Pass4v->errorResponse(Configure::read('errorParameter'), "(".__FUNCTION__.")", $xml);
			return;
		}

		if (!$this->Pass4v->firstCheck($form, array('productId'), __FUNCTION__, $xml)) {
			return ;
		}

		if (!$form['productId']=$this->_changeCodeIdToId($form['productId']))
		{
			$this->Pass4v->errorResponse(Configure::read('errorNoContentsListInformation'), "(".__FUNCTION__."),content file information data not found, contents_id=".$form['productId'], $xml);
			return;
		}

		$fields = array('SppContentFile.file_name,SppContent.content_name,SppContentFile.file_content,SppContentFile.file_size');
		$conditions =( array('SppContentFile.content_id'=>$form['productId'],'SppContent.sale_start_date <='=> date('Y-m-d'),'SppContent.sale_end_date >='=> date('Y-m-d'),'SppContent.active_flag'=>'1','SppContentFile.active_flag'=>'1'));

		if (!$contentfile = $this->SppContentFile->find('first',array('conditions'=>$conditions,'fields'=>$fields))) {
			$this->Pass4v->errorResponse(Configure::read('errorNoContentsListInformation'), "(".__FUNCTION__."),content file information data not found, contents_id=".$form['productId'], $xml);
			return;
		}

		if (!$this->Pass4v->downloadContent($contentfile, __FUNCTION__)) {
			$this->Pass4v->errorResponse(Configure::read('errorDownloadContentFile'), "(".__FUNCTION__."),content file download error file not found or ..., download target", $xml);
			return;
		}
		return;
	}

	/**
	 *
	 * download content file for spp_web
	 */
	function downloadContentFilesForWeb()
	{
		$now = date("Y-m-d H:i:s");
		$now = strtotime($now);
		$form = $this->params['form'];

		$xml = Configure::read('useResponseXML');

		$fields = array('SppContentFile.file_name,SppContent.content_name,SppContentFile.file_content,SppContentFile.file_size');
		$conditions =( array('SppContentFile.id'=>$form['content_file_id']));

		if (!$contentfile = $this->SppContentFile->find('first',array('conditions'=>$conditions,'fields'=>$fields))) {
			$this->Pass4v->errorResponse(Configure::read('errorNoContentsListInformation'), "(".__FUNCTION__."),content file information data not found, contents_id=".$form['productId'], $xml);
			return;
		}

		if (!$this->Pass4v->downloadContent($contentfile, __FUNCTION__)) {
			$this->Pass4v->errorResponse(Configure::read('errorDownloadContentFile'), "(".__FUNCTION__."),content file download error file not found or ..., download target", $xml);
			return;
		}
		return;
	}

	/**
	 * getContentBySetId get list content code of set content
	 * input: $productId json string
	 * output :	Err|file list content code
	 */
	function getContentBySetId()
	{
		$xml = Configure::read('useResponseXML');
		$subdir=Configure::read('forderContentUpload');
		$form = $this->params['form'];
		if(trim($form['productId']) == NULL)
		{
			$this->Pass4v->errorResponse(Configure::read('errorParameter'), "(".__FUNCTION__.")", $xml);
			return;
		}
		// check parameter inut
		if (!$this->Pass4v->firstCheck($form, array('productId'), __FUNCTION__, $xml)) {
			return ;
		}

		$form['productId'] = json_decode($form['productId'],true);
		$arr_Id = array();
		$arr_parentId = array();

		foreach ($form['productId'] as $key => $value) {
			$arr_Id[] = $value['productId'];
		}
		// change content code to id content
		if (!$arr_parentId = $this->_changeCodeIdToId($arr_Id))
		{
			$this->Pass4v->errorResponse(Configure::read('errorNoContentsListInformation'), "(".__FUNCTION__."),content file information data not found, contents_id=".$form['productId'], $xml);
			return;
		}
		//get list content code of set content
		$fields = array('SppContent.content_code,SppContent.version,SppContent.content_name,SppContentItem.content_id');
		$conditions =( array('SppContentItem.content_id'=>array_keys($arr_parentId),'SppContent.active_flag'=>'1','SppContentFile.active_flag' => 1));

		$this->SppContentItem->bindModel(
		array('belongsTo'=>array(
                                    'SppContent' => array(
                                        'foreignKey' => false,
                                        'conditions' => array('SppContent.id = SppContentItem.child_content_id','SppContent.sale_start_date <='=> date('Y-m-d'),'SppContent.sale_end_date >='=> date('Y-m-d'))
		),
									'SppContentFile' => array(
										'foreignKey' => false,
                                        'conditions' => array('SppContentFile.content_id = SppContent.id')
		)
		)
		)
		);

		if (!$content = $this->SppContentItem->find('all',array('conditions'=>$conditions,'fields'=>$fields,'group by'=>'SppContentItem.content_id'))) {
			$this->Pass4v->errorResponse(Configure::read('errorNoContentsListInformation'), "(".__FUNCTION__."),content file information data not found, contents_id=".$form['productId'], $xml);
			return;
		}
		$listdata = array();
		foreach ($content as $item)
		{
			$data['parentId'] = $arr_parentId[$item['SppContentItem']['content_id']];
			$data['productId']= $item['SppContent']['content_code'];
			$data['productName']= $item['SppContent']['content_name'];
			$data['version']= $item['SppContent']['version'];
			$listdata[]=$data;
			unset($data);
		}

		$result['response']= base64_encode(json_encode($listdata));
		$response = Configure::read('responseContentsList') + $result;
		$this->Pass4v->response($response, "(".__FUNCTION__."),Get contents list success.",$xml);
		return;
	}

	/**
	 * check License
	 * @input	 : 	license_code
	 *				learner_id
	 * @output 	 :	Err|learner_id
	 */
	function checkLicense()
	{
		$xml = Configure::read('useResponseXML');
		$form = $this->params['form'];
		$content = base64_decode($form['content']);
		$content = json_decode($content,true);

		if (!$this->Pass4v->firstCheck($content, array('license_code'), __FUNCTION__, $xml)) {
			$this->Pass4v->errorResponse(Configure::read('errorParameter'), "(".__FUNCTION__.")", $xml);
			return ;
		}
		$license_code = trim($content['license_code']);
		// check input parameter.
		if(empty($license_code))
		{
			$this->Pass4v->errorResponse(Configure::read('errorParameter'), "(".__FUNCTION__.")", $xml);
			return;
		}

		// get information license code.
		$conditions = array('SppLicense.license_code'=>$license_code);
		$contentlicense = $this->SppLicense->find($conditions);
		if (!$contentlicense) {
			$this->Pass4v->errorResponse(Configure::read('errorNoLicense'), "(".__FUNCTION__.")", $xml);
			return;
		}

		// Is date use license available
		if(date('Y-m-d') <= date($contentlicense['SppLicense']['expired_end_date']))
		{
			// if client_used_date <> null, This license is used by other learner
			if(!empty($contentlicense['SppLicense']['client_used_date'])){
				if(!$contentlicense['SppLicense']['check_flag']){
					$this->Pass4v->errorResponse(Configure::read('errorNoLicense'), "(".__FUNCTION__.")", $xml);
					return;
				}
			} else {
				$this->SppLicense->updateAll(array('SppLicense.client_used_date' => "'".date('Y-m-d')."'"),
				array('SppLicense.id ' => $contentlicense['SppLicense']['id']));
			}
			$response = Configure::read('responseSuccess');
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;
		}
		else
		{
			$this->Pass4v->errorResponse(Configure::read('errorDateLicenseExpired'), "(".__FUNCTION__.")", $xml);
			return;
		}
		return;
	}

	/**
	 * check list License
	 * @input	 : 	learner_id
	 *				list of license_code
	 * @output 	 :	list of learner_id|status
	 * @author haitlt
	 * #5887
	 */
	function checkListLicense()
	{
		$xml = Configure::read('useResponseXML');
		$form = $this->params['form'];
		$content = base64_decode($form['content']);
		$content = json_decode($content,true);

		$learner_id = null;
		$licenses = $content['licenses'];
		$res = $this->Pass4v->checkParamsKey($content, array('learner_id'));
		if ($res !== true) {
			$learner_id = "";
		}else{
			$learner_id = $content['learner_id'];
		}
			
		$learner_id = $content['learner_id'];
		$arry = array();
		$i = 0;
		foreach ($licenses as $value){
			$arry[$i]['license_code'] = $value['license_code'];
			if(isset($value['learner_id'])){
				$arry[$i]['learner_id'] = $value['learner_id'];
			} else {
				$arry[$i]['learner_id'] = NULL;
			}
			$i++;
		}

		$index = 0;
		$lists = array();
		$today = date('Y-m-d');
		if(count($arry)>0){
			for($i = 0; $i < count($arry); $i++ ){
				$conditions = array();
				$conditions['SppLicense.license_code'] = $arry[$i]['license_code'];
				$license = $this->SppLicense->find('first', array('conditions'=>$conditions));
				if ($license) {
					if($today <= date($license['SppLicense']['expired_end_date']) &&
					$today >= date($license['SppLicense']['expired_start_date']))
					{
						if(!$license['SppLicense']['check_flag'] &&
						empty($license['SppLicense']['client_used_date'])){
							continue;
						}
						$lists[$index]['license_code'] = $arry[$i]['license_code'];
						$lists[$index]['learner_id'] = $arry[$i]['learner_id'];
						$index = $index + 1;
					}
				}
			}
		}

		$dataresponse = array();
		$dataresponse['licenses'] = $lists;
		$dataresponse['is_expired'] = false;
		// check license's learner is expired or not yet
		if(!empty($learner_id)){
			$dataresponse['is_expired'] = $this->SppLearner->checkLicenseExpired($learner_id);
		}
		$result['response']= base64_encode(json_encode($dataresponse));
		$response = Configure::read('responseContentsList') + $result;
		$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
	}

	/**
	 *
	 * check License
	 * @param $contentlicense
	 * @author haitlt
	 */
	function checkIdentify($license, $identifier_no){
		$status = null;

		// Is date use license available
		if(date('Y-m-d') <= date($license[0]['SppLicense']['expired_end_date']) &&
		date('Y-m-d') >= date($license[0]['SppLicense']['expired_start_date']))
		{
			// check clientIdentifierNo same learner_id of lincese
			if($identifier_no == $license[0]['SppLicense']['learner_id'])
			{
				$status = "OK";
			}
			else
			{
				$status = "NG";
			}
		}
		else
		{
			$status = "NG";
		}
		return $status;
	}

	/**
	 * get Description By PurchaseStatus
	 * input  : content_id
	 *			purchaes_status 0: befor_ purchase_desc,1: after_ purchase_desc,2: after_ purchase_desc
	 * output :	Err|Description
	 */
	function getDescriptionByPurchaseStatus()
	{
		$xml = Configure::read('useResponseXML');
		$form = $this->params['form'];
		if(trim($form['productId']) == NULL)
		{
			$this->Pass4v->errorResponse(Configure::read('errorParameter'), "(".__FUNCTION__.")", $xml);
			return;
		}

		// check parameter inut
		if (!$this->Pass4v->firstCheck($form, array('productId','purchaseStatus'), __FUNCTION__, $xml)) {
			return ;
		}

		$content_code = $form['productId'];

		// change content code to id content
		if (!$form['productId']=$this->_changeCodeIdToId($form['productId']))
		{
			$this->Pass4v->errorResponse(Configure::read('errorNoContentsListInformation'), "(".__FUNCTION__."),content file information data not found, contents_id=".$form['productId'], $xml);
			return;
		}

		switch  ($form['purchaseStatus'])
		{
			case 0:// befor_purchase_desc
				$fields = array('SppContent.before_purchase_desc');
				$table  = 'SppContent';
				$field  = 'before_purchase_desc';
				$conditions = array('SppContent.id'=>$form['productId'],'SppContent.active_flag'=>'1');
				break;

			case 1:// after_purchase_desc
			case 2:
				$fields = array('SppContent.after_purchase_desc');
				$table	= 'SppContent';
				$field  = 'after_purchase_desc';
				$conditions = array('SppContent.id'=>$form['productId'],'SppContent.active_flag'=>'1');
				break;

			case 3:// before_download_desc
				$fields = array('SppContentFile.before_download_desc', 'SppContent.content_code', 'SppContent.version');
				$table	= 'SppContentFile';
				$field  = 'before_download_desc';
				$this->SppContent->unBindModel(array('hasMany' => array('SppContentFile')));

				if (!$content = $this->SppContent->find('first',array('conditions'=>array('SppContent.id'=>$form['productId'],'SppContent.active_flag'=>'1'),'fields'=>array('content_type'))))
				{
					$this->Pass4v->errorResponse(Configure::read('errorNoContentFileInfo'), "(".__FUNCTION__."),content file information data not found, contents_id=".$form['productId'], $xml);
				}

				// Is content Set
				if($content['SppContent']['content_type']== 1)
				{
					$conditions = array('SppContentItem.content_id'=>$form['productId'], 'SppContentItem.child_content_id = SppContentFile.content_id','SppContentFile.active_flag'=>'1');
					$this->SppContent->bindModel(
					array(
								'hasOne' =>
					array(
										'SppContentFile' => array(
											'className' => 'SppContent',
											'foreignKey' =>'content_id',
											'fields' => array('before_download_desc')
					),
										'SppContentItem' => array(
											'className' => 'SppContentItem',
											'foreignKey' =>false,
											'conditions'=>array('SppContentFile.content_id = SppContentItem.child_content_id','SppContent.sale_start_date <='=> date('Y-m-d'),'SppContent.sale_end_date >='=> date('Y-m-d'))
					)
					)
					)
					);
				}
				else // content Item
				{
					$conditions =( array('SppContentFile.content_id'=>$form['productId'],'SppContentFile.active_flag'=>'1'));
					$this->SppContent->bindModel(
					array(
								'hasOne' =>
					array(
										'SppContentFile' => array(
											'className' => 'SppContent',
											'foreignKey' =>'content_id',
											'fields' => array('before_download_desc')
					)
					)
					)
					);
				}
				break;

			default:// befor_ purchase_desc
				$fields = array('SppContent.before_purchase_desc');
				$table  = 'SppContent';
				$field  = 'before_purchase_desc';
				$conditions = array('SppContent.id'=>$form['productId'],'SppContent.active_flag'=>'1');
		}

		// get data
		$conditions['SppContent.sale_start_date <=']= date('Y-m-d');
		$conditions['SppContent.sale_end_date >=']= date('Y-m-d');

		$this->SppContent->unBindModel(array('hasMany' => array('SppContentFile')));
		// Order by content_code: Haitlt
		if (!$content = $this->SppContent->find('all',array('conditions' =>$conditions,'fields'=>$fields, 'order' => array('SppContent.content_code ASC')))) {
			$this->Pass4v->errorResponse(Configure::read('errorNoContentsListInformation'), "(".__FUNCTION__."),content file information data not found, contents_id=".$form['productId'], $xml);
			return;
		}

		/* #6677 */
		$fromClient = json_decode($form['items']);
		if($form['purchaseStatus'] === "3") {
			foreach ($content as $key => $item) {
				foreach ($fromClient as $val) {
					if(($item['SppContent']['content_code'] == $val->contentId) && ($item['SppContent']['version'] == $val->version) ) {
						unset($content[$key]);
					}
				}
			}
		}
		$description ='';

		// modified data add break line when get Description of set Content
		foreach($content as $item)
		{
			if($description == '')
			{
				$description .= $item[$table][$field];
			}
			else
			{
				$description .= "<br />".$item[$table][$field];
			}
		}
		$dataresponse= array();
		$dataresponse['productId']=  $content_code;
		$dataresponse['description']= $description;

		$result['response'] = base64_encode(json_encode($dataresponse));
		$response = Configure::read('responseSuccess') + $result;
		$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
		return;
	}

	/**
	 * _changeCodeIdToId change content_code to contentId
	 * input  : contentCode
	 *
	 * output :	FALSE|content_id
	 */
	function _changeCodeIdToId($contentCodeId)
	{

		$fields = array('SppContent.id','SppContent.content_code');
		$conditions =( array('SppContent.content_code' => $contentCodeId,'SppContent.active_flag'=>'1'));
		$this->SppContent->unBindModel(array('hasMany' => array('SppContentFile, SppLicenseContent, SppContentItem')));

		if (is_array($contentCodeId)) {
			if (!$content = $this->SppContent->find('all',array('conditions'=>$conditions,'fields'=>$fields))) {
				return false;
			}
			$arr_id = array();
			foreach ($content as $key => $value) {
				$arr_id[$value['SppContent']['id']] = $value['SppContent']['content_code'];
			}
			return $arr_id;
		} else {

			if (!$content = $this->SppContent->find('first',array('conditions'=>$conditions,'fields'=>$fields))) {
				return false;
			}
			return $content['SppContent']['id'];
		}

	}



	/**
	 * getReportForLearner
	 * 
	 *
	 * @param json string
	 * 
	 * @author ChieNguyen
	 */
	function getReportForLearner()
	{
	    //Add PWa Test no use SSL
        $appCtr = new AppController();
        $appCtr->corsSSL();

		$xml = Configure::read('useResponseXML');
		$form = $this->params['form'];
		$studyInfo = base64_decode($form['content']);
		$studyInfo = json_decode($studyInfo,true);
		$learner_id = $studyInfo['learner_id'];

		$quizStatistic = $studyInfo['quiz_statistic'];
		$all_quiz_count = $quizStatistic['all_quiz_count'];


		$all_try_count = 0;
		$all_miss_count = 0;
		$all_achievement_count = 0;
		$start_app_count = $studyInfo['start_app_count'];
		$is_my_page = $studyInfo['is_my_page'];

		// check parameter input
		if (!$this->Pass4v->firstCheck($studyInfo,
		array('learner_id', 'learning_times'), __FUNCTION__, $xml)) {
			return;
		}
		//check input
		if(trim($learner_id) == NULL)
		{
			$this->Pass4v->errorResponse(Configure::read('errorParameter'), "(".__FUNCTION__.")", $xml);
			return;
		}

		//check learner_id is blocked
		if($this->checkUserIsBlocked($learner_id)){
			$this->Pass4v->errorResponse(Configure::read('learnerIsBlocked'), "(".__FUNCTION__.")", $xml);
			return;
		}

	

		$today = date("y-m-d H:i:s");
		$is_error = false;
		$dataresponse = array();
		$quiz_log_change = true;
		try{

			

			$rank_id = NULL;
			$start_date = date("y-m-d H:i:s");
			$learning_time_total = 0;
			$learning_days = 1;
			$total_mark = 0;
			if(!$is_error){

				// caculate all learning logs info which still not statistic to spp_study_records table
				$learning_log = $this->SppLearningLog->find('first',array(
														'fields' => array('DISTINCT SUM(learning_duration) AS learning_time_total',
																		  'MIN(learning_date) AS start_date'),
														'conditions'=>array('learner_id' => $learner_id,'statistic_flag' => 0)));
				if(!empty($learning_log)){
					if(!empty($learning_log[0]['learning_time_total'])){
						$learning_time_total = $learning_log[0]['learning_time_total'];
					}
					if(!empty($learning_log[0]['start_date'])){
						$start_date = $learning_log[0]['start_date'];
						$diff = date_diff(new DateTime($start_date), new DateTime());
						$learning_days = $diff->format('%a') + 1;
					}
				}
				if($quiz_log_change){
					$quiz_log_statictis = $this->SppQuizLog->quizLogStatistic($learner_id);
					$all_try_count = $quiz_log_statictis[0]['all_try_count'];
					$all_miss_count = $quiz_log_statictis[0]['all_miss_count'];
					$all_achievement_count = $all_try_count - $all_miss_count;
				}
				$this->SppStudyRecord->begin();
				$this->SppLearningLog->begin();
				//save on spp_study_records table
				$study_record = $this->SppStudyRecord->getStudyRecordByLearner($learner_id);

				if(empty($study_record)){
					$total_mark = $this->calculateMark($learner_id, $learning_time_total, $start_app_count, $all_miss_count, $all_achievement_count);
					$rank_id = $this->SppRankMaster->getRankByMark($total_mark);
					$learner_current_rank = $this->SppRankMaster->findById($rank_id);
					// insert new record
					$temp_result = $this->SppStudyRecord->insertStudyRecord($learner_id, $start_date, $learning_days, $learning_time_total, $learning_progress,
					$all_quiz_count, $all_try_count, $all_miss_count, $all_achievement_count, $rank_id, $total_mark, $start_app_count);

					// update expired date for license of learner base on rank_id
					if(!empty($learner_current_rank)){
						$this->SppLicense->updateExpiredDate(null,$learner_id,$learner_current_rank['SppRankMaster']['extend_days']);
					}
					if(!$temp_result){
						$is_error = true;
					}
				} else {
					if(!$quiz_log_change){
						$all_try_count = $study_record['SppStudyRecord']['all_try_count'];
						$all_miss_count = $study_record['SppStudyRecord']['all_miss_count'];
						$all_achievement_count = $all_try_count - $all_miss_count;
					}
					$start_date = $study_record['SppStudyRecord']['start_date'];
					$start_app_count += $study_record['SppStudyRecord']['start_app_count'];
					$diff = date_diff(new DateTime($study_record['SppStudyRecord']['start_date']), new DateTime());
					$learning_days = $diff->format('%a') + 1;
					$learning_time_total = $study_record['SppStudyRecord']['learning_time_seconds'] + $learning_time_total;
					$temp_mark = $this->calculateMark($learner_id, $learning_time_total, $start_app_count, $all_miss_count, $all_achievement_count);
					$total_mark = $temp_mark + $study_record['SppStudyRecord']['point_update'];
					$rank_id = $this->SppRankMaster->getRankByMark($total_mark);
					$learner_current_rank = $this->SppRankMaster->findById($rank_id);
					// update expred date if learner rank up
					if(!empty($learner_current_rank) && $rank_id != $study_record['SppStudyRecord']['rank_id'] && $temp_mark > $study_record['SppStudyRecord']['mark']){
						$this->SppLicense->updateExpiredDate(null,$learner_id,$learner_current_rank['SppRankMaster']['extend_days']);
					}
					// update record
					$temp_result = $this->SppStudyRecord->updateStudyRecord($study_record, $learning_days, $learning_time_total, $learning_progress, $all_quiz_count,
					$all_try_count, $all_miss_count, $all_achievement_count, $rank_id, $temp_mark, $start_app_count);
					if(!$temp_result){
						$is_error = true;
					}
				}
				// set statistic_flag = true for learning log
				if(!$is_error){
					if(!$this->SppLearningLog->updateAll(array('statistic_flag' => true),array('learner_id' => $learner_id))){
						$is_error = true;
					}
				}

				if(!$is_error){
					$this->SppStudyRecord->commit();
					$this->SppLearningLog->commit();
				} else {
					$this->SppStudyRecord->rollback();
					$this->SppLearningLog->rollback();
				}

			} else {
				$this->SppLearningLog->rollback();
				$this->SppQuizLog->rollback();
			}
			// get info for response
			$dataresponse['rank'] = NULL;
			$dataresponse['last_week'] = NULL;
			$dataresponse['incremental'] = NULL;
			$dataresponse['incremental']['rank_up'] = 0;
			$dataresponse['update_within_a_week'] = '1';
			if(!empty($learner_current_rank)){
				$dataresponse['rank'] = $learner_current_rank['SppRankMaster'];
			}
			$last_week_info = $this->SppLastWeekLearningRecord->find('first',array('conditions'=>array('learner_id' => $learner_id)));

			if(!empty($last_week_info)){
				$last_week_rank = $this->SppRankMaster->findById($last_week_info['SppLastWeekLearningRecord']['rank_id']);
				if(!empty($last_week_rank)){
					$dataresponse['last_week']['rank'] = $last_week_rank['SppRankMaster'];
					if($learner_current_rank['SppRankMaster']['mark'] > $last_week_rank['SppRankMaster']['mark']){
						$dataresponse['incremental']['rank_up'] = 1;
					} else {
						if($learner_current_rank['SppRankMaster']['mark'] < $last_week_rank['SppRankMaster']['mark']){
							$dataresponse['incremental']['rank_up'] = -1;
						}
					}

				}

			}
			// get latest date learner learning
			$latest_date = $this->SppLearningLog->find('first', array('fields' => 'MAX(learning_date) AS latest_date',
													   'conditions' => array('learner_id' => $learner_id)));
			if(!empty($latest_date) && !empty($latest_date[0]['latest_date'])){
				$diff = date_diff(new DateTime(), new DateTime($latest_date[0]['latest_date']));
				if($diff->format('%a') > 7){
					$dataresponse['update_within_a_week'] = '0';
				}
			}

			// reponse full data if is_my_page is true
			if($is_my_page == 1){
				$dataresponse['prev_info'] = NULL;
				$dataresponse['next_info'] = NULL;
				$remaining_days = $this->SppLicense->getRemainingDays($learner_id);
				$is_show_remaining_days =  true;
				$payment_method = substr($learner_id,0,1);
				if($payment_method == Configure::read('PAYMENT_METHOD.STORE')){
					$is_show_remaining_days = false;
				} else {
					$learner = $this->SppLearner->findById($learner_id);
					if(!empty($learner) && $learner['SppLearner']['organization_code'] == Configure::read('PERSONAL_CODE')){
						$is_show_remaining_days = false;
					}
				}
				$dataresponse['target_point'] = $this->SppRankMaster->getTargetPoint($total_mark);
				$dataresponse['learning_days'] = $learning_days;
				$dataresponse['remaining_days'] = $is_show_remaining_days == true ? $remaining_days:-1;
				$dataresponse['learning_hours'] = ceil($learning_time_total/3600 * 2)/2;
				$dataresponse['learning_average_minutes'] = $learning_days == 0 ? 0:ceil(ceil($learning_time_total/60)/$learning_days);
				$dataresponse['quiz_progress'] = $all_quiz_count == 0 ? 0:round(($all_try_count/$all_quiz_count)*100,0);
				$dataresponse['mark'] = $total_mark;
				$current_learner_postion = -1;
				$prev_mark = NULL;
				// get current learner position
				$row1 = $this->SppStudyRecord->getCurrentPosition($learner_id, $total_mark, $learning_time_total, $rank_id);
				if($row1){
					$current_learner_postion = $row1['position'] + 1;
					$dataresponse['position'] = $current_learner_postion;
					$prev_mark = $row1['prev_mark'];
				}
				// get prev_info learner
				if($current_learner_postion > 1){
					if($prev_mark != NULL){
						$dataresponse['prev_info']['mark'] = $prev_mark;
						$dataresponse['prev_info']['position'] = $current_learner_postion - 1;
					}
				}
				// get next_info learner
				$row2 = $this->SppStudyRecord->getNextMark($learner_id, $total_mark, $learning_time_total, $rank_id);
				if($row2){
					if($row2['next_mark'] != NULL){
						$dataresponse['next_info']['mark'] = $row2['next_mark'];
						$dataresponse['next_info']['position'] = $current_learner_postion + 1;
					}
				}
				// get last week info and calculate incremental
				if(!empty($last_week_info)){
					$dataresponse['last_week']['learning_hours'] = ceil($last_week_info['SppLastWeekLearningRecord']['learning_time_seconds']/3600 * 2)/2;
					$dataresponse['last_week']['learning_average_minutes'] = $last_week_info['SppLastWeekLearningRecord']['learning_average_minutes'];
					$dataresponse['last_week']['quiz_progress'] = $last_week_info['SppLastWeekLearningRecord']['quiz_progress'];
					$dataresponse['last_week']['mark'] = $last_week_info['SppLastWeekLearningRecord']['mark'];
					$lastweek_update_date = $last_week_info['SppLastWeekLearningRecord']['update_date'];
					$month = date("m",strtotime($lastweek_update_date));
					$day = date("d",strtotime($lastweek_update_date));
					$dataresponse['last_week']['update_date'] = $month . '/' . $day;
					$dataresponse['incremental']['learning_hours'] = $dataresponse['learning_hours'] - $dataresponse['last_week']['learning_hours'];

					//#53144
					//今週の「平均（日ごと）」 = 今週の時間／今週の学習日数
					//$dataresponse['incremental']['learning_average_minutes'] = $dataresponse['learning_average_minutes'] - $last_week_info['SppLastWeekLearningRecord']['learning_average_minutes'];
					$learning_days = $dataresponse['learning_days'] - $last_week_info['SppLastWeekLearningRecord']['learning_days'];
					$dataresponse['incremental']['learning_average_minutes'] = $learning_days == 0 ? 0 :ceil($dataresponse['incremental']['learning_hours']*60/$learning_days);

					$dataresponse['incremental']['quiz_progress'] = $dataresponse['quiz_progress'] - $last_week_info['SppLastWeekLearningRecord']['quiz_progress'];
					$dataresponse['incremental']['mark'] = $dataresponse['mark'] - $last_week_info['SppLastWeekLearningRecord']['mark'];

				}
			}
		}catch (Exception $e) {
			// Rollback transaction
			$this->SppLearningLog->rollback();
			$this->SppQuizLog->rollback();
			$this->set('cleared', 1);
			$this->set('errors', array(Configure::read('Message.ERR_EXCEPTION')));
			$response['result'] = 'NG';
			$response['message'] = $e->getMessage();
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;
		}
		if(!$is_error){
			$result['response'] = base64_encode(json_encode($dataresponse));
			$response = Configure::read('responseSuccess') + $result;
		} else {
			$response = Configure::read('responseNG');
		}
		$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
		return;
	}





	/**
	 * saveStudyInfo
	 * @param json string
	 * #5661
	 * output :	Result and client_code(for the first time)
	 * @author haitlt
	 */
	function saveStudyInfo()
	{
	    //Add PWa Test no use SSL
        $appCtr = new AppController();
        $appCtr->corsSSL();

		$xml = Configure::read('useResponseXML');
		$form = $this->params['form'];
		$studyInfo = base64_decode($form['content']);
		$studyInfo = json_decode($studyInfo,true);
		$learner_id = $studyInfo['learner_id'];
		$learningTimes = $studyInfo['learning_times'];
		$learnerSettings = $studyInfo['learner_settings'];
		$quizLogs = $studyInfo['quiz_logs'];
		$quizContinueLogs = $studyInfo['quiz_continue_logs'];
		$quizStatistic = $studyInfo['quiz_statistic'];
		$all_quiz_count = $quizStatistic['all_quiz_count'];
		//$all_try_count = $quizStatistic['all_try_count'];
		//$all_miss_count = $quizStatistic['all_miss_count'];
		//$all_achievement_count = $quizStatistic['all_achievement_count'];
		$all_try_count = 0;
		$all_miss_count = 0;
		$all_achievement_count = 0;
		$learning_progress = $quizStatistic['learning_progress'];
		$start_app_count = $studyInfo['start_app_count'];
		$is_my_page = $studyInfo['is_my_page'];

		// check parameter input
		if (!$this->Pass4v->firstCheck($studyInfo,
		array('learner_id', 'learning_times'), __FUNCTION__, $xml)) {
			return;
		}
		//check input
		if(trim($learner_id) == NULL)
		{
			$this->Pass4v->errorResponse(Configure::read('errorParameter'), "(".__FUNCTION__.")", $xml);
			return;
		}

		//check learner_id is blocked
		if($this->checkUserIsBlocked($learner_id)){
			$this->Pass4v->errorResponse(Configure::read('learnerIsBlocked'), "(".__FUNCTION__.")", $xml);
			return;
		}

		$this->SppLearningLog->begin();
		$this->SppQuizLog->begin();
		$this->SppQuizContinueLog->begin();

		$today = date("y-m-d H:i:s");
		$is_error = false;
		$dataresponse = array();
		$quiz_log_change = false;
		try{

			//save learning_times
			foreach ($learningTimes as $learningTime) {
				unset($learningTime['id']);
				if(!$this->SppLearningLog->saveData($learner_id, $learningTime)){
					$is_error = true;
					break;
				}
			}

			//save incorrect log
			//$this->Pass4v->accessLog($this->name, "Info", "(".__FUNCTION__."),$quizLogs : ".print_r($quizLogs,1), $referer, $_SERVER['HTTP_USER_AGENT']);
			$this->log('quizLogs:',LOG_DEBUG);
			$this->log($quizLogs,LOG_DEBUG);

			foreach ($quizLogs as $quizLog) {
				unset($quizLog['id']);
				if(!$this->SppQuizLog->saveData($learner_id, $quizLog)){
					$is_error = true;
					break;
				} else {
					$quiz_log_change = true;
				}
			}
			$this->Pass4v->accessLog($this->name, "Info", "(".__FUNCTION__."),$quiz_log_change : ".$quiz_log_change, $referer, $_SERVER['HTTP_USER_AGENT']);
			//$this->Pass4v->accessLog($this->name, "Info", $quiz_log_change : ".$quiz_log_change, $referer, $_SERVER['HTTP_USER_AGENT']);



			//save quiz continue log
			foreach ($quizContinueLogs as $quizContinueLog) {
				unset($quizContinueLog['id']);
				if(!$this->SppQuizContinueLog->saveData($learner_id, $quizContinueLog)){
					$is_error = true;
					break;
				} 
			}

			// update
			$infoLearner = $this->SppLearner->find('first',array(
		   								'conditions'=>array(
		   									'id'	=>	$learner_id
		   								))
									);
			if($infoLearner)
			{
				$this->SppLearner->begin();
				// update for leaner
				$infoLearner['SppLearner']['settings_log'] = serialize($learnerSettings);
				$this->SppLearner->save($infoLearner);
				$this->SppLearner->commit();
			}

		

			$rank_id = NULL;
			$start_date = date("y-m-d H:i:s");
			$learning_time_total = 0;
			$learning_days = 1;
			$total_mark = 0;
			if(!$is_error){
				$this->SppLearningLog->commit();
				$this->SppQuizLog->commit();
				$this->SppQuizContinueLog->commit();
				// caculate all learning logs info which still not statistic to spp_study_records table
				$learning_log = $this->SppLearningLog->find('first',array(
														'fields' => array('DISTINCT SUM(learning_duration) AS learning_time_total',
																		  'MIN(learning_date) AS start_date'),
														'conditions'=>array('learner_id' => $learner_id,'statistic_flag' => 0)));
				if(!empty($learning_log)){
					if(!empty($learning_log[0]['learning_time_total'])){
						$learning_time_total = $learning_log[0]['learning_time_total'];
					}
					if(!empty($learning_log[0]['start_date'])){
						$start_date = $learning_log[0]['start_date'];
						$diff = date_diff(new DateTime($start_date), new DateTime());
						$learning_days = $diff->format('%a') + 1;
					}
				}
				if($quiz_log_change){
					$quiz_log_statictis = $this->SppQuizLog->quizLogStatistic($learner_id);
					$all_try_count = $quiz_log_statictis[0]['all_try_count'];
					$all_miss_count = $quiz_log_statictis[0]['all_miss_count'];
					$all_achievement_count = $all_try_count - $all_miss_count;
				}
				$this->SppStudyRecord->begin();
				$this->SppLearningLog->begin();
				//save on spp_study_records table
				$study_record = $this->SppStudyRecord->getStudyRecordByLearner($learner_id);
				if(empty($study_record)){
					$total_mark = $this->calculateMark($learner_id, $learning_time_total, $start_app_count, $all_miss_count, $all_achievement_count);
					$rank_id = $this->SppRankMaster->getRankByMark($total_mark);
					$learner_current_rank = $this->SppRankMaster->findById($rank_id);
					// insert new record
					$temp_result = $this->SppStudyRecord->insertStudyRecord($learner_id, $start_date, $learning_days, $learning_time_total, $learning_progress,
					$all_quiz_count, $all_try_count, $all_miss_count, $all_achievement_count, $rank_id, $total_mark, $start_app_count);

					// update expired date for license of learner base on rank_id
					if(!empty($learner_current_rank)){
						$this->SppLicense->updateExpiredDate(null,$learner_id,$learner_current_rank['SppRankMaster']['extend_days']);
					}
					if(!$temp_result){
						$is_error = true;
					}
				} else {
					if(!$quiz_log_change){
						$all_try_count = $study_record['SppStudyRecord']['all_try_count'];
						$all_miss_count = $study_record['SppStudyRecord']['all_miss_count'];
						$all_achievement_count = $all_try_count - $all_miss_count;
					}
					$start_date = $study_record['SppStudyRecord']['start_date'];
					$start_app_count += $study_record['SppStudyRecord']['start_app_count'];
					$diff = date_diff(new DateTime($study_record['SppStudyRecord']['start_date']), new DateTime());
					$learning_days = $diff->format('%a') + 1;
					$learning_time_total = $study_record['SppStudyRecord']['learning_time_seconds'] + $learning_time_total;
					$temp_mark = $this->calculateMark($learner_id, $learning_time_total, $start_app_count, $all_miss_count, $all_achievement_count);
					$total_mark = $temp_mark + $study_record['SppStudyRecord']['point_update'];
					$rank_id = $this->SppRankMaster->getRankByMark($total_mark);
					$learner_current_rank = $this->SppRankMaster->findById($rank_id);
					// update expred date if learner rank up
					if(!empty($learner_current_rank) && $rank_id != $study_record['SppStudyRecord']['rank_id'] && $temp_mark > $study_record['SppStudyRecord']['mark']){
						$this->SppLicense->updateExpiredDate(null,$learner_id,$learner_current_rank['SppRankMaster']['extend_days']);
					}
					// update record
					$temp_result = $this->SppStudyRecord->updateStudyRecord($study_record, $learning_days, $learning_time_total, $learning_progress, $all_quiz_count,
					$all_try_count, $all_miss_count, $all_achievement_count, $rank_id, $temp_mark, $start_app_count);
					if(!$temp_result){
						$is_error = true;
					}
				}
				// set statistic_flag = true for learning log
				if(!$is_error){
					if(!$this->SppLearningLog->updateAll(array('statistic_flag' => true),array('learner_id' => $learner_id))){
						$is_error = true;
					}
				}

				if(!$is_error){
					$this->SppStudyRecord->commit();
					$this->SppLearningLog->commit();
				} else {
					$this->SppStudyRecord->rollback();
					$this->SppLearningLog->rollback();
				}

			} else {
				$this->SppLearningLog->rollback();
				$this->SppQuizLog->rollback();
			}
			// get info for response
			$dataresponse['rank'] = NULL;
			$dataresponse['last_week'] = NULL;
			$dataresponse['incremental'] = NULL;
			$dataresponse['incremental']['rank_up'] = 0;
			$dataresponse['update_within_a_week'] = '1';
			if(!empty($learner_current_rank)){
				$dataresponse['rank'] = $learner_current_rank['SppRankMaster'];
			}
			$last_week_info = $this->SppLastWeekLearningRecord->find('first',array('conditions'=>array('learner_id' => $learner_id)));

			if(!empty($last_week_info)){
				$last_week_rank = $this->SppRankMaster->findById($last_week_info['SppLastWeekLearningRecord']['rank_id']);
				if(!empty($last_week_rank)){
					$dataresponse['last_week']['rank'] = $last_week_rank['SppRankMaster'];
					if($learner_current_rank['SppRankMaster']['mark'] > $last_week_rank['SppRankMaster']['mark']){
						$dataresponse['incremental']['rank_up'] = 1;
					} else {
						if($learner_current_rank['SppRankMaster']['mark'] < $last_week_rank['SppRankMaster']['mark']){
							$dataresponse['incremental']['rank_up'] = -1;
						}
					}

				}

			}
			// get latest date learner learning
			$latest_date = $this->SppLearningLog->find('first', array('fields' => 'MAX(learning_date) AS latest_date',
													   'conditions' => array('learner_id' => $learner_id)));
			if(!empty($latest_date) && !empty($latest_date[0]['latest_date'])){
				$diff = date_diff(new DateTime(), new DateTime($latest_date[0]['latest_date']));
				if($diff->format('%a') > 7){
					$dataresponse['update_within_a_week'] = '0';
				}
			}

			// reponse full data if is_my_page is true
			if($is_my_page == 1){
				$dataresponse['prev_info'] = NULL;
				$dataresponse['next_info'] = NULL;
				$remaining_days = $this->SppLicense->getRemainingDays($learner_id);
				$is_show_remaining_days =  true;
				$payment_method = substr($learner_id,0,1);
				if($payment_method == Configure::read('PAYMENT_METHOD.STORE')){
					$is_show_remaining_days = false;
				} else {
					$learner = $this->SppLearner->findById($learner_id);
					if(!empty($learner) && $learner['SppLearner']['organization_code'] == Configure::read('PERSONAL_CODE')){
						$is_show_remaining_days = false;
					}
				}
				$dataresponse['target_point'] = $this->SppRankMaster->getTargetPoint($total_mark);
				$dataresponse['learning_days'] = $learning_days;
				$dataresponse['remaining_days'] = $is_show_remaining_days == true ? $remaining_days:-1;
				$dataresponse['learning_hours'] = ceil($learning_time_total/3600 * 2)/2;
				$dataresponse['learning_average_minutes'] = $learning_days == 0 ? 0:ceil(ceil($learning_time_total/60)/$learning_days);
				$dataresponse['quiz_progress'] = $all_quiz_count == 0 ? 0:round(($all_try_count/$all_quiz_count)*100,0);
				$dataresponse['mark'] = $total_mark;
				$current_learner_postion = -1;
				$prev_mark = NULL;
				// get current learner position
				$row1 = $this->SppStudyRecord->getCurrentPosition($learner_id, $total_mark, $learning_time_total, $rank_id);
				if($row1){
					$current_learner_postion = $row1['position'] + 1;
					$dataresponse['position'] = $current_learner_postion;
					$prev_mark = $row1['prev_mark'];
				}
				// get prev_info learner
				if($current_learner_postion > 1){
					if($prev_mark != NULL){
						$dataresponse['prev_info']['mark'] = $prev_mark;
						$dataresponse['prev_info']['position'] = $current_learner_postion - 1;
					}
				}
				// get next_info learner
				$row2 = $this->SppStudyRecord->getNextMark($learner_id, $total_mark, $learning_time_total, $rank_id);
				if($row2){
					if($row2['next_mark'] != NULL){
						$dataresponse['next_info']['mark'] = $row2['next_mark'];
						$dataresponse['next_info']['position'] = $current_learner_postion + 1;
					}
				}
				// get last week info and calculate incremental
				if(!empty($last_week_info)){
					$dataresponse['last_week']['learning_hours'] = ceil($last_week_info['SppLastWeekLearningRecord']['learning_time_seconds']/3600 * 2)/2;
					$dataresponse['last_week']['learning_average_minutes'] = $last_week_info['SppLastWeekLearningRecord']['learning_average_minutes'];
					$dataresponse['last_week']['quiz_progress'] = $last_week_info['SppLastWeekLearningRecord']['quiz_progress'];
					$dataresponse['last_week']['mark'] = $last_week_info['SppLastWeekLearningRecord']['mark'];
					$lastweek_update_date = $last_week_info['SppLastWeekLearningRecord']['update_date'];
					$month = date("m",strtotime($lastweek_update_date));
					$day = date("d",strtotime($lastweek_update_date));
					$dataresponse['last_week']['update_date'] = $month . '/' . $day;
					$dataresponse['incremental']['learning_hours'] = $dataresponse['learning_hours'] - $dataresponse['last_week']['learning_hours'];

					//#53144
					//今週の「平均（日ごと）」 = 今週の時間／今週の学習日数
					//$dataresponse['incremental']['learning_average_minutes'] = $dataresponse['learning_average_minutes'] - $last_week_info['SppLastWeekLearningRecord']['learning_average_minutes'];
					$learning_days = $dataresponse['learning_days'] - $last_week_info['SppLastWeekLearningRecord']['learning_days'];
					$dataresponse['incremental']['learning_average_minutes'] = $learning_days == 0 ? 0 :ceil($dataresponse['incremental']['learning_hours']*60/$learning_days);

					$dataresponse['incremental']['quiz_progress'] = $dataresponse['quiz_progress'] - $last_week_info['SppLastWeekLearningRecord']['quiz_progress'];
					$dataresponse['incremental']['mark'] = $dataresponse['mark'] - $last_week_info['SppLastWeekLearningRecord']['mark'];

				}
			}
		}catch (Exception $e) {
			// Rollback transaction
			$this->SppLearningLog->rollback();
			$this->SppQuizLog->rollback();
			$this->set('cleared', 1);
			$this->set('errors', array(Configure::read('Message.ERR_EXCEPTION')));
			$response['result'] = 'NG';
			$response['message'] = $e->getMessage();
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;
		}
		if(!$is_error){
			$result['response'] = base64_encode(json_encode($dataresponse));
			$response = Configure::read('responseSuccess') + $result;
		} else {
			$response = Configure::read('responseNG');
		}
		$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
		return;
	}

	/**
	 *
	 * calculate mark for learner
	 */
	private function calculateMark($learner_id, $learning_time_total, $start_app_count, $all_incorrect, $all_correct, $point_update = 0){
		$time_for_mark = 0;
		$mark_for_incorrect = 0;
		$mark_for_correct = 0;
		$mark_for_question = 0;
		$mark_for_correction = 0;
		$mark_for_start_app = 0;
		$mark_master = $this->SppMarkMaster->find('first');
		if(!empty($mark_master)){
			$time_for_mark = $mark_master['SppMarkMaster']['time_for_mark'];
			$mark_for_incorrect = $mark_master['SppMarkMaster']['mark_for_incorrect'];
			$mark_for_correct = $mark_master['SppMarkMaster']['mark_for_correct'];
			$mark_for_question = $mark_master['SppMarkMaster']['mark_for_question'];
			$mark_for_correction = $mark_master['SppMarkMaster']['mark_for_correction'];
			$mark_for_start_app = $mark_master['SppMarkMaster']['mark_for_start_app'];
		}

		// total mark for question
		$total_mark_question = 0;
		$total_question = $this->SppQuestion->find('first', array(
							'fields' => array('SUM(mark) as total_mark', 'COUNT(*) as total_count'),
							'conditions' => array('learner_id' => $learner_id)
		));
		if(!empty($total_question)){
			$total_mark_question = $total_question[0]['total_mark'] + $mark_for_question * $total_question[0]['total_count'];
		}

		// total mark for correction
		$total_mark_correction = 0;
		$total_correction = $this->SppCorrection->find('first', array(
							'fields' => array('SUM(mark) as total_mark','COUNT(*) as total_count'),
							'conditions' => array('learner_id' => $learner_id)
		));
		if(!empty($total_correction)){
			$total_mark_correction = $total_correction[0]['total_mark'] + $mark_for_correction * $total_correction[0]['total_count'];
		}

		$total_mark_learning_time = 0;
		if($time_for_mark != 0){
			$total_mark_learning_time = ceil($learning_time_total/(60*$time_for_mark));
		}

		$total_mark_incorrect = $mark_for_incorrect * $all_incorrect;
		$total_mark_correct = $mark_for_correct * $all_correct;
		$total_mark_start_app = $mark_for_start_app * $start_app_count;
		return $total_mark_question + $total_mark_correction + $total_mark_learning_time
		+ $total_mark_incorrect + $total_mark_correct + $total_mark_start_app + $point_update;
	}

	/**
	 * #5670
	 * Get ContentInfo.
	 * @param jsonStr $contents
	 * @author haitlt
	 */
	function getContentsInfo(){

		$xml = Configure::read('useResponseXML');

		$form = $this->params['form'];
		$licenses = trim($form['licenses']);
		$contentCode = trim($form['content_id']);

		$licenses = base64_decode($licenses);
		//$contentCode = base64_decode($contentCode);

		$returnInfo;
		$returnInfo = $this->_getContentInfo($licenses, $contentCode);

		$result['response']= base64_encode($returnInfo);
		$response = Configure::read('responseSuccess') + $result;
		$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
		return;
	}

	/**
	 * #5670
	 * Get ContentInfo.
	 * @param jsonStr $contents
	 * @author haitlt
	 */
	function _getContentInfo($licenses = null, $contentCode){

		$parentContentCodes = $this->getParentContentCodes($contentCode);

		//get contentIdList
		$contentIds = array();
		if (isset($licenses) && !empty($licenses)) {
			$contentIds  = $this->_getLicenseList($licenses);
		}

		$fields = array('VActiveContent.id','VActiveContent.content_code','VActiveContent.content_type','VActiveContent.content_name','VActiveContent.version',
		'VActiveContent.builtin_flag','VActiveContent.store_flag', 'VActiveContent.subscribe_flag', 'VActiveContent.license_flag');
		if (!$contents = $this->VActiveContent->find('all',array('fields'=>$fields,'order' => array('VActiveContent.content_type' => 'Desc','VActiveContent.content_name'=>'ASC'),'group'=>'VActiveContent.id'))) {
			$this->Pass4v->errorResponse(Configure::read('errorNoContentsListInformation'), "(".__FUNCTION__."),No content list information", $xml);
			return false;
		}

		$lists = array();
		$index = 0;
		foreach ($contents as $key => $content) {
			$purchaseType = null;
			$isExist = false;
			if (!empty($contentIds)) {
				foreach ($contentIds as $contentId) {
					if($contentId == $content['VActiveContent']['id']) {
						$isExist = true;
						break;
					}
				}
			}
			if ($content['VActiveContent']['subscribe_flag'] == 1) {
				$purchaseType = 3;
			} else if ($content['VActiveContent']['license_flag'] == 1 && $isExist == true) {
				$purchaseType = 2;
			} else if ($content['VActiveContent']['store_flag'] == 1) {
				$purchaseType = 1;
			} else if ($content['VActiveContent']['builtin_flag'] == 1) {
				$purchaseType = 0;
			} else {
				// no license
				continue;
			}

			if($contentCode == $content['VActiveContent']['content_code'] ||
			in_array($content['VActiveContent']['content_code'], $parentContentCodes)){
					
				$lists[$index]['productId']	= $content['VActiveContent']['content_code'];
				$lists[$index]['productType'] = $content['VActiveContent']['content_type'];
				$lists[$index]['productName'] = $content['VActiveContent']['content_name'];
				$lists[$index]['purchaseType'] = $purchaseType;
				$lists[$index]['version'] = $content['VActiveContent']['version'];

				$index = $index + 1;
			}
		}

		//return base64_encode(json_encode($lists));
		$tmp['contents'] = $lists;
		$returnStr = json_encode($tmp);
		return $returnStr;
	}

	function getParentContentCodes($contentCode){

		$query = "SELECT content_code from spp_contents
					WHERE id in(SELECT p.content_id 
								FROM spp_content_items p, spp_contents c 
								WHERE p.child_content_id = c.id 
								AND c.content_code = '".$contentCode."')";
		$result = mysql_query($query) or die(mysql_error());
			
		// Loop on result
		$returnList = array();
		while($row = mysql_fetch_array($result)){
			//
			array_push($returnList, $row['content_code']);
		}
		return $returnList;
	}
	/*
	 function _getPastLearningInfo($xml, $client_code, $app_code, $date){
		$strdate = $date.' 00:00:00';
		try{
		$data = $this->SppLearning->find("all", array(
		'fields'=> array(
		'DISTINCT application_code',
		'client_code',
		'CEIL(SUM(learning_duration)/3600) AS learning_time',
		'(SUM(learning_duration)/3600) AS learning_time_rank',
		'(SELECT COUNT(DISTINCT ll.client_code)
		FROM spp_learnings AS ll
		WHERE ll.learning_date = SppLearning.learning_date
		AND ll.application_code = SppLearning.application_code
		AND ll.learning_duration > 0 )
		AS user_number',
		'(SELECT CEIL(SUM(learning_duration)/60)
		FROM spp_learnings AS ll
		WHERE learning_date = SppLearning.learning_date
		AND ll.application_code = SppLearning.application_code
		AND ll.learning_duration > 0 )
		AS learning_duration_total'
		),
		'group' => 'client_code, application_code',
		'order' => 'learning_time_rank desc',
		'conditions' => array( 'SppLearning.application_code' => $app_code,
		'SppLearning.learning_date = '."'".$strdate."'",
		'SppLearning.learning_duration > 0'),
		));
			
		}catch (Exception $e) {
		$this->set('cleared', 1);
		$this->set('errors', array(Configure::read('Message.ERR_EXCEPTION')));
		}

		// total clients learning
		$user_number = 0;
		// average time learning
		$average_time = 0;

		if(count($data)>0){
		// total clients
		$user_number = $data[0][0]['user_number'];
		// avg time learn
		$average_time = round($data[0][0]['learning_duration_total']/$user_number, 1);
		}

		// client time learn
		$learning_time = 0;
		// your rank.
		$your_rank = 0;
		// position
		$your_position = 0;
		// result code
		$result_code = '';

		$data_learning = array();

		// Query data.
		if($client_code != ""){
		try{
		$data_learning = $this->SppLearning->find("all", array(
		'fields'=> array(
		'DISTINCT application_code',
		'client_code',
		'(1.00000*SUM(learning_duration))/3600 AS learning_time',
		'(SUM(learning_duration)/3600) AS learning_time_rank'
		),
		'group'=>array('client_code'),
		'order' => 'learning_time desc',
		'conditions' => array('learning_date = '."'".$strdate."'",
		'application_code' => $app_code,
		'client_code'      => $client_code,
		'learning_duration > 0'
		),
		));
			
		}catch (Exception $e) {
		$this->set('cleared', 1);
		$this->set('errors', array(Configure::read('Message.ERR_EXCEPTION')));
		}
		}else{
		$learning_time = 0;
		$learning_time_rank = 0;
		$your_position = 0;
		$your_rank = 0;
		$result_code = "000";
		}
		if($client_code != ""){
		if(count($data_learning)>0){
		// client time learn
		$learning_time = $data_learning[0][0]['learning_time'];
		$learning_time_rank = $data_learning[0][0]['learning_time_rank'];
		// your_rank
		//$your_rank = $this->getrank($data, $learning_time);
		}
		}


		// Max time
		$max = 0;

		if(count($data)>0){
		foreach ($data as $value) {
		if($value[0]['learning_time']>$max){
		$max = $value[0]['learning_time'];// maximun hour
		}
		}
		}

		// Column X
		$X = array();
		if($max <= 0){
		$result_code = '000';
		for ($j = 0; $j < 24; $j++){
		$X[$j] = 0;
		}
		}else{
		if(count($data)>0){
		$result_code = '111';
		}else{
		$result_code = '000';
		}
		$X[0] = 1.5;
		for($i = 1; $i<24;$i++){
		$X[$i] = $X[$i-1] + 1;
		}

		}
		// Graphic chart
		// Column Z
		$Z = array();
		$Z = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0);
			
		if(count($data)>0){
		$Z = $this->graphic_array($data, $X);
		}
		$data_chart = array(0);
		if(count($Z)>0){
		$data_chart = array(
		$Z[0],$Z[1],$Z[2],$Z[3],$Z[4],$Z[5],
		$Z[6],$Z[7],$Z[8],$Z[9],$Z[10],$Z[11],
		$Z[12],$Z[13],$Z[14],$Z[15],$Z[16],$Z[17],
		$Z[18],$Z[19],$Z[20],$Z[21],$Z[22],$Z[23]
		);
		}
		$data_x = array(0);
		if(count($X)>0){
		$data_x = array(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24);
		}

		// position
		if($learning_time == 0 && count($data_learning) > 0 ){
		$your_position = 1;
		$your_rank = $user_number;
		}elseif($learning_time>0){
		// your_rank
		$your_rank = $this->getrank($data, $learning_time_rank);
		// position
		$your_position = $this->_getpositionForPastDate($X, ceil($learning_time));
		}


		$top5learning = $this->SppLearning->find('all',array('conditions'=>array('SppLearning.application_code' => $app_code,
		'SppLearning.learning_date'=>$date),
		'fields'=>array('CEIL(SUM(SppLearning.learning_duration)/60) AS TOP_LEARNING'),
		'limit'=> 5,
		'group'=>array('SppLearning.client_code'),
		'order'=>array('SUM(SppLearning.learning_duration) DESC'),
		'recursive' => -1));

		$data_top_5_learning_time = array();
		if(count($top5learning)> 0){
		$data_top_5_learning_time = array(
		isset($top5learning[0][0]['TOP_LEARNING'])?$top5learning[0][0]['TOP_LEARNING'] : "0",
		isset($top5learning[1][0]['TOP_LEARNING'])?$top5learning[1][0]['TOP_LEARNING'] : "0",
		isset($top5learning[2][0]['TOP_LEARNING'])?$top5learning[2][0]['TOP_LEARNING'] : "0",
		isset($top5learning[3][0]['TOP_LEARNING'])?$top5learning[3][0]['TOP_LEARNING'] : "0",
		isset($top5learning[4][0]['TOP_LEARNING'])?$top5learning[4][0]['TOP_LEARNING'] : "0",
		);
		}


		$lists = array();
		$lists['result_code'] = $result_code;
		$lists['learning_times'] = ceil($learning_time*60);
		$lists['user_number'] = $user_number;
		$lists['your_rank'] = $your_rank;
		$lists['average_time'] = $average_time;
		$lists['your_position'] = $your_position;
		$lists['data_chart'] = $data_chart;
		$lists['data_x'] = $data_x;
		$lists['top_5_learning_time'] = $data_top_5_learning_time;

		$result['response']= base64_encode(json_encode($lists));
		$response = Configure::read('responseSuccess') + $result;
		$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
		return;
		}*/
	/*
	 function getMonthlyLearningInfo(){
		$xml = Configure::read('useResponseXML');
		$form = $this->params['form'];

		if(isset($this->params['form']['month']) &&
		isset($this->params['form']['year']) &&
		isset($this->params['form']['application_code'])){
		$month = $this->params['form']['month'];
		$year    = $this->params['form']['year'];
		$application_code = $this->params['form']['application_code'];
		}
		else{
		$this->Pass4v->errorResponse(Configure::read('errorParameter'),"Post parameter not completed", $xml);
		return;
		}
		if(empty($this->params['form']['month']) ||
		empty($this->params['form']['year']) ||
		empty($this->params['form']['application_code'])){
		$this->Pass4v->errorResponse(Configure::read('errorParameter'),"invalid value", $xml);
		return;
		}
		if(!is_numeric($month) || !is_numeric($year)){
		$this->Pass4v->errorResponse(Configure::read('errorParameter'),"Invalid value", $xml);
		return;
		}
		if($month < 1 || $month >12 || $year < 1){
		$this->Pass4v->errorResponse(Configure::read('errorParameter'),"Invalid value", $xml);
		return;
		}
		$tmp = new stdClass();
		$tmp->result_code = '111';
		$days = new stdClass();
		for ($i=1; $i<32;$i++){
		$strdate = $year.'-'.$month.'-'.$i.' 00:00:00';
		if($learning = $this->SppLearning->find('all',
		array('conditions'=>array('learning_date'=> $strdate,
		'application_code' => $application_code)))){
		$days->$i = '1';
		}
		else{
		$days->$i = '0';
		}
		}

		$tmp->days = json_encode($days);
		$result['response']= base64_encode(json_encode($tmp));
		$response = Configure::read('responseSuccess') + $result;
		$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
		}*/

	function isDateValid($str)
	{
		$stamp = strtotime($str);
		if (!is_numeric($stamp))
		return false;

		//checkdate(month, day, year)
		if ( checkdate(date('m', $stamp), date('d', $stamp), date('Y', $stamp)) )
		{
			return true;
		}
		return false;
	}

	/**
	 * Ticket: #10888
	 * @param:
	 * @author:TuanNM
	 * Date: 2012/09/27
	 * Edited: 2013/03/05
	 */
	function sendDeviceToken(){
		$this->autoRender = false;
		$xml = Configure::read('useResponseXML');
		$device_token = $this->params['form']['deviceToken'];
		$device_id = $this->params['form']['deviceId'];
		if(!isset($device_token) || $device_token == null ||
		empty($device_token) || !isset($device_id) || $device_id == null || empty($device_id)){
			$this->Pass4v->errorResponse(Configure::read('errorNoContentInfo'),"", $xml);
			return;
		}

		//Replace space in device token string
		$device_token = str_replace(" ", "", $device_token);
		$device_id = str_replace(" ", "", $device_id);


		//1. Check whether deviceToken existed or not
		$conditions = array('SppDeviceToken.device_id'=>$device_id, 'SppDeviceToken.device_token'=>$device_token);
		if($this->SppDeviceToken->find('all',array('conditions'=>$conditions))){
			$this->Pass4v->errorResponse(Configure::read('errorDeviceIdAndTokenExisted'),"", $xml);
			return;
		}

		//Tuannm. Check user agent
		if($_SERVER['HTTP_USER_AGENT'] == "Android"){
			$device_type = 2;
		} else {
			$device_type = 1;
		}
		//End
		$conditions = array('SppDeviceToken.device_id'=>$device_id);
		$devicetoken = $this->SppDeviceToken->find('first',array('conditions'=>$conditions));
		//2. Insert device token
		if(empty($devicetoken)) {
			$devicetoken = array('SppDeviceToken' => array('device_token'   =>$device_token,
													   'device_id'   =>$device_id,
													   'device_type' =>$device_type));
			$this->SppDeviceToken->create();
		} else {
			$devicetoken['SppDeviceToken']['device_token'] = $device_token;
		}
		if($this->SppDeviceToken->save($devicetoken)){
			$this->Pass4v->errorResponse(Configure::read('responseInsert'),"", $xml);
		}
		else{
			$this->Pass4v->errorResponse(Configure::read('errorNoContentInfo'),"", $xml);
		}


		//2. Insert device token
		$conditionsToken = array('SppDeviceToken.device_id'=>$device_id);
		$devicetoken = $this->SppDeviceToken->find('first', array('conditions'=>$conditionsToken));

		if(!$devicetoken){
			$devicetoken = $this->SppDeviceToken->create();
			$devicetoken = array('SppDeviceToken' => array('device_id' => $device_id,
                'device_token' =>$device_token,
                'device_type' =>$device_type));
		}else{
			$devicetoken['SppDeviceToken']['device_token'] = $device_token;
			$devicetoken['SppDeviceToken']['device_type'] = $device_type;
		}

		if($this->SppDeviceToken->save($devicetoken)){
			$this->Pass4v->errorResponse(Configure::read('responseInsert'),"", $xml);
		}else{
			$this->Pass4v->errorResponse(Configure::read('errorNoContentInfo'),"", $xml);
		}
	}


	/**
	 * Ticket: #10888
	 * $params
	 * @author:TuanNM
	 * Date: 2012/09/27
	 */
	function pushMessage(){
		$this->autoRender = false;
		$xml = Configure::read('useResponseXML');
		$message = $this->params['form']['message'];
		$deviceToken = $this->SppDeviceToken->find('all');
		foreach ($deviceToken as $val){
			$tokenId = $val['SppDeviceToken']['device_id'];
			if($this->_pushMessage($message, $tokenId)){
				$this->Pass4v->errorResponse(Configure::read('responseSuccess'),"Message successfully deliver", $xml);
			} else{
				$this->Pass4v->errorResponse(Configure::read('responseError'),"Error on delivering message", $xml);
			}
		}
		return;
	}

	/**
	 * Ticket: #10888
	 * $params
	 * @author:TuanNM
	 * Date: 2012/09/27
	 */
	function _pushMessage($message, $deviceToken){
		//Put your private key's passphrase here:
		$passphrase =  Configure::read('Push.passphrase');
		// Put your alert message here:
		if(!isset($message) || $message ==null)
		{
			//$this->Pass4v->errorResponse(Configure::read('errorNoContentInfo'),"", $xml);
			return false;
		}
		////////////////////////////////////////////////////////////////////////////////

		$ctx = stream_context_create();
		$certificate =  Configure::read('Push.certpath');
		stream_context_set_option($ctx, 'ssl', 'local_cert', $certificate);
		stream_context_set_option($ctx, 'ssl', 'passphrase', $passphrase);

		// Open a connection to the APNS server
		$fp = stream_socket_client(
		Configure::read('Push.apns'), $err,
		$errstr, 60, STREAM_CLIENT_CONNECT|STREAM_CLIENT_PERSISTENT, $ctx);
		if (!$fp)
		exit("Failed to connect: $err $errstr" . PHP_EOL);
		// Create the payload body
		$body['aps'] = array(
			'alert' => $message,
			'sound' => 'default'
			);
			// Encode the payload as JSON
			$payload = json_encode($body);
			// Build the binary notification
			$msg = chr(0) . pack('n', 32) . pack('H*', $deviceToken) . pack('n', strlen($payload)) . $payload;
			// Send it to the server
			$result = fwrite($fp, $msg, strlen($msg));
			if (!$result)
			return false;
			else
			return true;
			// Close the connection to the server
			fclose($fp);
			return;
	}

	/**
	 * $params $number
	 * @author:TuanNM
	 * Date: 2012/10/22
	 */
	function _roundIntegerUp($number){
		$number = round($number);
		$remainder = $number%10;
		if($remainder != 0){
			$plusNumber = 10 - $remainder;
		} else {
			$plusNumber = 0;
		}
		return ($number + $plusNumber);
	}

	/*
	 * Author: TuanNM
	 * Date: 2012/10/24
	 * Params: $cols (number of col in chart). $maxTime
	 * Desc: Get minimum number of maxTime that can be divide for col
	 */
	function _devidedNumber($col, $maxTime){
		$maxTime = round($maxTime);
		$remainder = $maxTime%$col;

		if($remainder == 0){
			return $maxTime;
		} else {
			$loop = true;
			while($loop){
				$maxTime = $maxTime + 1;
				$remainder = $maxTime%$col;
				if($remainder == 0){
					$loop = false;
					return $maxTime;
				}
			}
		}
	}

	/*
	 * INSERT TEST DATA
	 *//*
	 function insertData(){
		for ($i=0;$i < 20000 ; $i++){
		$client_code = $this->_generateString(10);
		$random_date = $this->_randomDate('2012-07-19', '2012-11-19');
		$learningData = array(
		'SppLearning'=>array(
		'application_code'=> '11111',
		'client_code'=> $client_code,
		'learning_date'=>'2012-12-05',//$random_date,
		'learning_duration'=>43200//rand(1, 86400)
		)
		);
		$this->SppLearning->id = null;
		$this->SppLearning->create();
		$this->SppLearning->save($learningData);
		unset($learningData);
		}
		}*/

	/**
	 * String generator function
	 *
	 */
	function _generateString($length = 10){
		// inicializa variables
		$password = "";
		$i = 0;
		$possible = "0123456789bcdfghjkmnpqrstvwxyz";
			
		// agrega random
		while ($i < $length){
			$char = substr($possible, mt_rand(0, strlen($possible)-1), 1);

			if (!strstr($password, $char)) {
				$password .= $char;
				$i++;
			}
		}
		return $password;
	}

	// Find a randomDate between $start_date and $end_date
	function _randomDate($start_date, $end_date)
	{
		// Convert to timetamps
		$min = strtotime($start_date);
		$max = strtotime($end_date);

		// Generate random number using above bounds
		$val = rand($min, $max);

		// Convert back to desired date format
		return date('Y-m-d', $val);
	}

	/*
	 * END INSERT TEST DATA
	 */

	//Title: for SPP3 Android only
	//Tuannm. Date: 2012/12/22
	//Ticket:
	/**
	 * get graphic array
	 * @author Tuannm
	 * @param
	 * @return
	 * @created 2011/11/30
	 **/
	function graphic_array_spp3($data, $X){
		$Z = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

		foreach ($data as $value) {
			$learn_time = $value[0]['learning_time'];
			if(0 <= $learn_time && $learn_time <= $X[0]){
				$Z[0]++;
			}else{
				for($i = 1; $i <= 9; $i++ ){
					if($X[$i-1] <= $learn_time && $learn_time <= $X[$i] ){
						$Z[$i]++;
						$i = 10;
					}
				}
			}
		}

		return $Z;
	}

	/**
	 * get user rank
	 * @author Tuannm
	 * @param Array, int
	 * @return rank
	 * @created 2011/12/02
	 **/
	function getrankspp3($data, $learning_time){
		$result = 0;
		if(count($data) <= 0 ){
			return 0;
			break;
		}else{
			foreach ($data as $value) {
				if($learning_time < $value[0]['learning_time']){
					$result++;
				}
			}
		}
		return $result+1;
	}


	/**
	 * get user position
	 * @author Tuannm
	 * @param Array, int
	 * @return rank
	 * @created 2011/12/02
	 **/
	function getpositionspp3($X, $learning_time){

		if(0 < $learning_time && $learning_time <= $X[0]){
			return 1;
			break;
		}else{
			for($i = 1; $i <10; $i++){
				if($learning_time<=$X[$i] && $learning_time>=$X[$i-1]){
					return $i+1;
					break;
				}
			}
		}
	}

	/**
	 * get graphic array total
	 * @author huyendtn
	 * @param
	 * @return
	 * @created 2011/12/05
	 **/
	function graphic_array_total_spp3($data, $X){
		$Z = array();
		for($j = 0; $j < 10; $j++){
			$Z[$j] = 0;
		}
		foreach ($data as $value) {
			$learn_time = $value[0]['learning_time'];
			if(0 <= $learn_time && $learn_time <= $X[0]){
				$Z[0]++;
			}else{
				for($i = 1; $i <= 9; $i++ ){
					if($X[$i-1] <= $learn_time && $learn_time <= $X[$i] ){
						$Z[$i]++;
					}
				}
			}
		}
		return $Z;
	}

	/**
	 * get total; rank
	 * @author huyendtn
	 * @param Array, int
	 * @return rank
	 * @created 2011/12/05
	 **/
	function getrank_total_spp3($data, $learning_time){
		$result = 1;
		if(count($data) <= 0 ){
			return 0;
			break;
		}else{
			foreach ($data as $value) {
				if($learning_time == $value[0]['learning_time']){
					return $result;
				}else{
					$result++;
				}
			}
		}
		return $result;
	}
	//End

	//
	//API Server for SPP_WEB
	//

	/**
	 *
	 * API login...
	 * @author: TuanNM
	 */
	/*function login(){
		$xml = Configure::read('useResponseXML');
		$form = $this->params['form'];

		$arraykeys = array('user_name','password');
		if (!$this->Pass4v->firstCheck($form, $arraykeys, __FUNCTION__, $xml)) {
		return;
		} else {
		$user_name = $form['user_name'];
		$password = $form['password'];
		}

		//Get webadmin info
		$user_id = $this->SppUser->find('first',array('conditions' => array('SppUser.user_name'=> Configure::read('User.WEBADMIN')),
		'fields' => array('SppUser.id')));


		$this->SppLicense->unbindModel( array('belongsTo' => array('SppUser')));
		$client_no = $this->SppLicense->find('first',
		array('conditions'=>
		array('SppLicense.license_desc'=>$user_name,
		'SppLicense.learner_id'=>$password,
		'SppLicense.user_id' => $user_id['SppUser']['id'])));
		if(!$client_no){
		$this->Pass4v->response(Configure::read('responseLoginFail'), "(".__FUNCTION__."),Get contents list success.",$xml);
		return;
		}

		//Get client code
		$client_code_info = $this->SppClientIdCode->find('first',
		array('conditions'=>
		array('SppClientIdCode.client_id'=>$user_name)));

		//
		//Get content_code list
		//
		$license_list = array();
		if($client_no['SppLicenseContent']){
		foreach ($client_no['SppLicenseContent'] as $key=>$license_content){
		$this->SppContent->unbindModel( array('hasMany' => array('SppContentFile','SppContentItem',
		'SppLicenseContent')));
		$this->SppContent->unbindModel(array('belongsTo' => array('SppUser')));
		if($tmp = $this->SppContent->find('first', array('conditions'=>
		array('SppContent.id'=>$license_content['content_id'],
		'SppContent.active_flag'=>'1')))){
		$license_list[] = $tmp['SppContent']['content_code'];
		}
		}
		}

		$license_list = Set::sort($license_list, '{n}.content_code', 'asc');
		//json data
		$lists['client_code'] = $client_code_info['SppClientIdCode']['client_code'];
		$lists['content_id_list'] = $license_list;
		$lists['license'] = $client_no['SppLicense']['license_code'];


		$result['response']= base64_encode(json_encode($lists));
		$response = Configure::read('responseLoginSuccess') + $result;
		$this->Pass4v->response($response, "(".__FUNCTION__."),Get contents list success.",$xml);
		return;
		}*/

	/**
	 *
	 * login for spp_web
	 */
	function login(){
		try{
			$xml = Configure::read('useResponseXML');
			$form = $this->params['form'];
			$login_info = base64_decode($form['content']);
			$login_info = json_decode($login_info,true);
			$is_login_failure = false;
			$learner = $this->SppLearner->find('first', array('conditions' => array('email'=>$login_info['email_address'],'password' =>$login_info['password'])));
			if(!empty($learner)){
				$payment_method = substr($learner['SppLearner']['id'],0,1);
				// only alow learner have pament method is 個人払い  (A) or 法人払い (B)
				if($payment_method != Configure::read('PAYMENT_METHOD.PERSONAL')
				&& $payment_method != Configure::read('PAYMENT_METHOD.COMPANY')){
					$is_login_failure = true;
				}
				if($learner['SppLearner']['learner_classification_id'] == Configure::read('LEARNER_CLASSIFICATION.BLOCK')){
					$is_login_failure = true;
				}
				$license = $this->SppLicense->getLicenseByLearnerId($learner['SppLearner']['id']);
				if(!empty($license)){
					if(date('Y-m-d') > date($license['SppLicense']['expired_end_date'])){
						$is_login_failure = true;
					}
				}
				if(!$is_login_failure){
					$dataresponse['learner_id'] = $learner['SppLearner']['id'];
					$result['response'] = base64_encode(json_encode($dataresponse));
					$response = Configure::read('responseSuccess') + $result;
				}
			} else {
				$is_login_failure = true;
			}

			if($is_login_failure){
				$response = Configure::read('loginFailure');
			}
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;

		} catch(Exception $e){
			$result['response'] = json_encode($e->getMessage());
			$response = Configure::read('responseError') + $result;
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;
		}
	}

	//
	//API Server for SPP_WEB end
	//
	/**
	* getNewestMessage
	*
	*/
	function getNewestMessage(){
		$xml = Configure::read('useResponseXML');
		$form = $this->params['form'];
		$content = base64_decode($form['content']);
		$content = json_decode($content,true);
		$mess_id = $content['message_id'];
		$start_app_date_str = $content['start_app_date'];
		$start_app_date = date('Y/m/d H:i:s', strtotime($start_app_date_str));
		$delidate = date('Y-m-d');

		$res = $this->Pass4v->checkParamsKey($content, array('learner_id'));
		$organization_code = NULL;
		$rank_id = NULL;
		if ($res !== true) {
			$learner_id = "";
		}else{
			$learner_id = $content['learner_id'];
		}
		if(!empty($learner_id)){
			// get learner info
			$learner = $this->SppLearner->getLearnerWithStudyRecord($learner_id);
			if(!empty($learner)){
				$organization_code = $learner['SppLearner']['organization_code'];
				if(!empty($learner['SppStudyRecord']['rank_id'])){
					$rank_id = $learner['SppStudyRecord']['rank_id'];
				}
			}

		}
		$arr_pull_msg = $this->SppPullMessage->find('all',
		array('conditions'=> array(
				'OR'=>array(
		array(
						'SppPullMessage.created_datetime >='=>$start_app_date,
						'SppPullMessage.delivery_date <='=>$delidate,
						'NOT'=>array('SppPullMessage.delivery_date'=>null)
		),
		array(
						'SppPullMessage.created_datetime >='=>$start_app_date,
						'SppPullMessage.delivery_date'=>null
		)
		)
		),
				'order'=>'SppPullMessage.created_datetime DESC'));

		$mess = null;
		if(!empty($arr_pull_msg)){
			foreach ($arr_pull_msg as $pull_msg){
				if($this->checkMessageForLearner($pull_msg, $learner_id, $organization_code, $rank_id)){
					$mess = $pull_msg;
					break;
				}
			}
		}
			
		if($mess && $mess['SppPullMessage']['id'] > $mess_id){
			$return_mess['id'] = $mess['SppPullMessage']['id'];
			$return_mess['message'] = $mess['SppPullMessage']['message'];
			$result['response']= base64_encode(json_encode($return_mess));
			$response = Configure::read('responseGetNewestMess') + $result;
			$this->Pass4v->response($response, "(".__FUNCTION__."),Get new message success.",$xml);
		}else{
			$result['response']= '';
			$response = Configure::read('responseGetNewestMess') + $result;
			$this->Pass4v->response($response, "(".__FUNCTION__."),Get new message success.",$xml);
		}

	}

	/**
	 *
	 * save new question
	 */
	function saveQuestion(){
		$xml = Configure::read('useResponseXML');
		$form = $this->params['form'];
		$question = base64_decode($form['content']);
		$question = json_decode($question,true);
		$learner_id = $question['learner_id'];
		//create clicent_code
		if($learner_id == NULL || $learner_id == ""){
			//return errror;
		}
		$this->SppQuestion->create();
		$this->data['SppQuestion']['learner_id'] = $learner_id;
		$this->data['SppQuestion']['content_id'] = $question['content_id'];
		$this->data['SppQuestion']['category_no'] = $question['category_no'];
		$this->data['SppQuestion']['category_name'] = trim($question['category_name']);
		$this->data['SppQuestion']['subcategory_no'] = $question['subcategory_no'];
		$this->data['SppQuestion']['subcategory_name'] = trim($question['subcategory_name']);
		$this->data['SppQuestion']['quiz_no'] = $question['quiz_no'];
		$this->data['SppQuestion']['question_content'] = trim($question['question_content']);
		$this->data['SppQuestion']['original_is_public'] = $question['is_public'];
		$this->data['SppQuestion']['is_public'] = $question['is_public'];
		$this->data['SppQuestion']['created_datetime'] = date('Y-m-d H:i:s');
		$this->data['SppQuestion']['mark'] = 0;
		/*$mark_master = $this->SppMarkMaster->find('first');
		 if(!empty($mark_master)){
			$this->data['SppQuestion']['mark'] = $mark_master['SppMarkMaster']['mark_for_question'];
			}*/
		$this->SppQuestion->set($this->data);
		$dataresponse = array();
		$dataresponse['learner_id']=  $learner_id;
		$result['response'] = base64_encode(json_encode($dataresponse));
		if($this->SppQuestion->save()){
			$response = Configure::read('responseSuccess') + $result;
		} else {
			$response = Configure::read('errorSaveQuestion') + $result;
		}
		$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
		return;
	}

	function getQuestionList(){
		$xml = Configure::read('useResponseXML');
		$form = $this->params['form'];
		$content = base64_decode($form['content']);
		$content = json_decode($content,true);
		$res = $this->Pass4v->checkParamsKey($content, array('learner_id'));
		if ($res !== true) {
			$learner_id = "";
		}else{
			$learner_id = $content['learner_id'];
		}
		$is_get_all = $content['is_get_all'];
		$conditions = array();
		if($is_get_all == 0){
			$conditions['learner_id'] = $learner_id;
		} else {
			$conditions['learner_id NOT LIKE '] = $learner_id;
			$conditions['is_public'] = 1;
			$conditions['answered_datetime <> '] = NULL;
		}
		$arr_questions = $this->SppQuestion->find('all', array('conditions' => $conditions,
		'order' => array('created_datetime' => 'desc'),'limit' => '0,20'));
		$dataresponse = array();
		if(!empty($arr_questions)){
			foreach ($arr_questions as $question){
				$question['SppQuestion']['created_datetime'] = empty($question['SppQuestion']['created_datetime'])? NULL:date('Y/m/d',strtotime($question['SppQuestion']['created_datetime']));
				$question['SppQuestion']['answered_datetime'] = empty($question['SppQuestion']['answered_datetime'])? '':date('Y/m/d',strtotime($question['SppQuestion']['answered_datetime']));
				array_push($dataresponse, $question['SppQuestion']);
			}
		}
		$result['response'] = base64_encode(json_encode($dataresponse));
		$response = Configure::read('responseSuccess') + $result;
		$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
		return;
	}

	function saveCorrection(){
		try{
			$xml = Configure::read('useResponseXML');
			$form = $this->params['form'];
			$correction = base64_decode($form['content']);
			$correction = json_decode($correction,true);
			$learner_id = $correction['learner_id'];
			if($learner_id == NULL || $learner_id == ""){
				return 'error';
			}
			if($this->checkCorrectionIsEditted($learner_id,
			$correction['content_id'],
			$correction['category_no'],
			$correction['subcategory_no'],
			$correction['quiz_no'])){
				$result['message'] = "既に添削済みです。";
				$response = Configure::read('errorSaveCorrection') + $result;
			}

			$dataresponse = array();
			$fileData = null;
			if (!empty($form['thumbnail']) &&
			is_uploaded_file($form['thumbnail']['tmp_name'])) {
				$uploads_dir = Configure::read('IMG_CORRECTION');
				if ( ! is_dir($uploads_dir)) {
					mkdir($uploads_dir);
				}
				$tmp_name = $form['thumbnail']['tmp_name'];
				$fileData = file_get_contents($tmp_name);
				$extention = explode(".",$form['thumbnail']['name']);
				$file_ext = strtolower(array_pop($extention));
				$current_time = date('Ymdhis', time());
				$file_name =  $current_time. '.'.$file_ext;
				$full_path = $uploads_dir.$file_name;
				move_uploaded_file($tmp_name, $full_path);
				$is_convert = false;
				if ($file_ext == 'jpeg') {
					$is_convert = true;
					$image = imagecreatefromjpeg($full_path);
				} else
				if ($file_ext == 'png') {
					$is_convert = true;
					$image = imagecreatefrompng($full_path);
				}
				if($is_convert){
					$bg = imagecreatetruecolor(imagesx($image), imagesy($image));
					imagefill($bg, 0, 0, imagecolorallocate($bg, 255, 255, 255));
					imagealphablending($bg, TRUE);
					imagecopy($bg, $image, 0, 0, 0, 0, imagesx($image), imagesy($image));
					unlink($full_path);
					$file_name =  $current_time. '.jpg';
					$full_path = $uploads_dir.$file_name;
					imagejpeg($bg, $full_path, 100);
					imagedestroy($bg);
				}
				// resize image width to 760px
				list($orig_width, $orig_height) = getimagesize($full_path);
				$default_img_width = Configure::read('CORRECTION.IMAGE_WIDTH');
				$this->SppCorrection->resizeImage($full_path, $default_img_width,$orig_height*$default_img_width/$orig_width);

			} else {
				$response = Configure::read('errorImageRequired');
				$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
				return;
			}

			$spp_correction = $this->SppCorrection->getCorrection($learner_id,$correction['content_id'],
			$correction['category_no'],$correction['subcategory_no'],$correction['quiz_no']);

			if(empty($spp_correction)){
				$this->SppCorrection->create();
				$this->data['SppCorrection']['learner_id'] = $learner_id;
				$this->data['SppCorrection']['content_id'] = $correction['content_id'];
				$this->data['SppCorrection']['category_no'] = $correction['category_no'];
				$this->data['SppCorrection']['category_name'] = trim($correction['category_name']);
				$this->data['SppCorrection']['subcategory_no'] = $correction['subcategory_no'];
				$this->data['SppCorrection']['subcategory_name'] = trim($correction['subcategory_name']);
				$this->data['SppCorrection']['quiz_no'] = $correction['quiz_no'];
				$this->data['SppCorrection']['image_submit'] = $full_path;
				$this->data['SppCorrection']['created_datetime'] = date('Y-m-d H:i:s');
				$this->data['SppCorrection']['updated_datetime'] = date('Y-m-d H:i:s');
				$this->data['SppCorrection']['mark'] = 0;
				/*$mark_master = $this->SppMarkMaster->find('first');
				 if(!empty($mark_master)){
					$this->data['SppCorrection']['mark'] = $mark_master['SppMarkMaster']['mark_for_correction'];
					}*/
				$this->SppCorrection->set($this->data);
				$save_result = $this->SppCorrection->save();
			} else {
				$spp_correction['SppCorrection']['image_submit'] = $full_path;
				$spp_correction['SppCorrection']['updated_datetime'] = date('Y-m-d H:i:s');
				$save_result = $this->SppCorrection->save($spp_correction,array('conditions'=>array('SppCorrection.id' => $spp_correction['SppCorrection']['id'])));
			}
			$dataresponse['learner_id']=  $learner_id;
			$result['response'] = base64_encode(json_encode($dataresponse));
			if($save_result){
				$response = Configure::read('responseSuccess') + $result;
			} else {
				$response = Configure::read('errorSaveCorrection') + $result;
			}
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;
		} catch (Exception $e){
			$dataresponse = array();
			$result['response'] = json_encode($e->getMessage());
			$response = Configure::read('errorSaveCorrection') + $result;
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;
		}
	}

	function getCorrectionList(){
		$xml = Configure::read('useResponseXML');
		$form = $this->params['form'];
		$content = base64_decode($form['content']);
		$content = json_decode($content,true);
		$res = $this->Pass4v->checkParamsKey($content, array('learner_id'));
		if ($res !== true) {
			$learner_id = "";
		}else{
			$learner_id = $content['learner_id'];
		}
		$conditions = array();
		$conditions['learner_id'] = $learner_id;
		$arr_correction = $this->SppCorrection->find('all', array(
			'conditions'=> $conditions,
			'order' => array('created_datetime' => 'desc'),
			'limit' => '0,10'));
		$dataresponse = array();
		if(!empty($arr_correction)){
			foreach ($arr_correction as $correction){
				$correction['SppCorrection']['created_datetime'] = empty($correction['SppCorrection']['created_datetime'])? NULL:date('Y/m/d',strtotime($correction['SppCorrection']['created_datetime']));
				$correction['SppCorrection']['correction_datetime'] = empty($correction['SppCorrection']['correction_datetime'])? NULL:date('Y/m/d',strtotime($correction['SppCorrection']['correction_datetime']));
				array_push($dataresponse, $correction['SppCorrection']);
			}
		}
		$result['response'] = base64_encode(json_encode($dataresponse));
		$response = Configure::read('responseSuccess') + $result;
		$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
		return;
	}

	function getCorrection(){
		$xml = Configure::read('useResponseXML');
		$form = $this->params['form'];
		$conditions = base64_decode($form['content']);
		$conditions = json_decode($conditions,true);
		$correction = $this->SppCorrection->getCorrection($conditions['learner_id'],$conditions['content_id'],
		$conditions['category_no'],$conditions['subcategory_no'],$conditions['quiz_no']);
		$dataresponse = null;
		if(!empty($correction)){
			$correction['SppCorrection']['created_datetime'] = empty($correction['SppCorrection']['created_datetime'])? NULL:date('Y/m/d',strtotime($correction['SppCorrection']['created_datetime']));
			$correction['SppCorrection']['correction_datetime'] = empty($correction['SppCorrection']['correction_datetime'])? NULL:date('Y/m/d',strtotime($correction['SppCorrection']['correction_datetime']));
			$dataresponse = $correction['SppCorrection'];
		}
		$result['response'] = json_encode($dataresponse);
		$response = Configure::read('responseSuccess') + $result;
		$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
		return;
	}

	function getMessageList(){
		try{
			$appCtr = new AppController();
        	$appCtr->corsSSL();
			$xml = Configure::read('useResponseXML');
			$form = $this->params['form'];
			$content = base64_decode($form['content']);
			$content = json_decode($content,true);
			$res = $this->Pass4v->checkParamsKey($content, array('learner_id'));
			$organization_code = NULL;
			$rank_id = NULL;
			if ($res !== true) {
				$learner_id = "";
			}else{
				$learner_id = $content['learner_id'];
			}
			if(!empty($learner_id)){
				// get learner info
				$learner = $this->SppLearner->getLearnerWithStudyRecord($learner_id);
				if(!empty($learner)){
					$organization_code = $learner['SppLearner']['organization_code'];
					if(!empty($learner['SppStudyRecord']['rank_id'])){
						$rank_id = $learner['SppStudyRecord']['rank_id'];
					}
				}
			}

			$delidate = date('Y-m-d');
			$arr_pull_msg = $this->SppPullMessage->find('all', array('conditions' => array('OR' => array('delivery_date <=' => $delidate, 'delivery_date' => null)),
																	 'order' => array('delivery_date DESC', 'created_datetime DESC' )));
			$dataresponse = array();
			$count = 0;
			if(!empty($arr_pull_msg)){
				foreach ($arr_pull_msg as $pull_msg){
					if($this->checkMessageForLearner($pull_msg, $learner_id, $organization_code, $rank_id)){
						$pull_msg['SppPullMessage']['created_datetime'] = empty($pull_msg['SppPullMessage']['created_datetime'])? NULL:date('Y/m/d',strtotime($pull_msg['SppPullMessage']['created_datetime']));
						$pull_msg['SppPullMessage']['delivery_date'] = empty($pull_msg['SppPullMessage']['delivery_date'])? NULL:date('Y/m/d',strtotime($pull_msg['SppPullMessage']['delivery_date']));
						$count++;
						array_push($dataresponse, $pull_msg['SppPullMessage']);
						if($count == 10){
							break;
						}
					}
				}
			}
			$result['response'] = base64_encode(json_encode($dataresponse));
			$response = Configure::read('responseSuccess') + $result;
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;
		}catch (Exception $e){
			$dataresponse = array();
			$result['response'] = json_encode($e->getMessage());
			$response = Configure::read('responseNG') + $result;
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;
		}
	}

	/**
	 *
	 * learnerLogin
	 *
	 */
	function learnerLogin(){
		try{
			$xml = Configure::read('useResponseXML');
			$form = $this->params['form'];
			$login_info = base64_decode($form['content']);
            $login_info = json_decode($login_info,true);

			$learner = $this->SppLearner->find('first', array('conditions' => array('email'=>$login_info['email_address'],'password' =>$login_info['password'])));
			if(!empty($learner)){
				$loginLimit = Configure::read('LOGIN.LOGIN_LIMIT');
				if($loginLimit == 1){
					if($learner['SppLearner']['login_time'] != null){
						$this->Pass4v->errorResponse(Configure::read('userHasLogin'), "(".__FUNCTION__.")", $xml);
						return;
					}
				}
				if($learner['SppLearner']['learner_classification_id'] == Configure::read('LEARNER_CLASSIFICATION.BLOCK')){
					$this->Pass4v->errorResponse(Configure::read('learnerIsBlocked'), "(".__FUNCTION__.")", $xml);
					return;
				}
				// get license code
				$licenses = $this->SppLicense->getLicenseByLearnerId($learner['SppLearner']['id']);
				$dataresponse= array();
				if(!empty($licenses)){
					$licenseExpired = true;
					$licenseList = array();
					foreach ($licenses as $license){
						if(date('Y-m-d') <= date($license['SppLicense']['expired_end_date'])){
							$licenseExpired = false;
							if(empty($license['SppLicense']['client_used_date'])){
								$this->SppLicense->updateAll(array('SppLicense.client_used_date' => "'".date('Y-m-d')."'"),
								array('SppLicense.id ' => $license['SppLicense']['id']));
							}
							array_push($licenseList,$license['SppLicense']['license_code']);
								
						}
					}
					if(!empty($licenseList)){
						$dataresponse['license_codes']= $licenseList;
					}
					if($licenseExpired){
						//$this->Pass4v->errorResponse(Configure::read('errorLicenseExpired'), "(".__FUNCTION__.")", $xml);

            $appCtr = new AppController();
            $appCtr->corsSSL();
			$this->Pass4v->response(Configure::read('errorLicenseExpired'), "(".__FUNCTION__.")",$xml);
						return;
					}
				}
				if($loginLimit == 1){
					$learner['SppLearner']['login_time'] = date('Y-m-d H:i:s');
					$this->SppLearner->save($learner,array('conditions'=>array('SppLearner.id' => $learner['SppLearner']['id'])));
				}
				$dataresponse['learner_info']= $learner['SppLearner'];
				$result['response'] = base64_encode(json_encode($dataresponse));
				//$result['response'] = json_encode($dataresponse);
				$response = Configure::read('responseSuccess') + $result;
			} else {
		$this->Pass4v->accessLog($this->name, "Warn", "(".__FUNCTION__."Failure),".$login_info['email_address'].":".$login_info['password'], $referer, $_SERVER['HTTP_USER_AGENT']);
				$response = Configure::read('loginFailure');
			}

            //Add PWA Test use SSL
            $appCtr = new AppController();
            $appCtr->corsSSL();

			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;

		} catch(Exception $e){
			$result['response'] = json_encode($e->getMessage());
			$response = Configure::read('responseError') + $result;
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;
		}
	}
	/**
	 *
	 * learnerLogin
	 *
	 */
	function learnerLogout(){
        //Add PWa Test no use SSL
        $appCtr = new AppController();
        $appCtr->corsSSL();
		try{
			$xml = Configure::read('useResponseXML');
			$form = $this->params['form'];
			$learnerInfo = base64_decode($form['content']);
			$learnerInfo = json_decode($learnerInfo,true);
			$learnerId = $learnerInfo['learner_id'];

			$learner = $this->SppLearner->find('first', array('conditions' => array('id'=>$learnerId)));
			if(!empty($learner)){
			    if (isset($learnerInfo['device_token'])) { // Check Logout device
			        if ($learnerInfo['device_token'] == 'Logout'){
                        $learner['SppLearner']['device_token'] = 1;
                        $learner['SppLearner']['login_time'] = null;
                    }
                }

				$this->SppLearner->save($learner);
				$response = Configure::read('responseLogoutSuccess');
			} else {
				$response = Configure::read('responseLogoutFail');
			}
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;
		} catch(Exception $e){
			$result['response'] = json_encode($e->getMessage());
			$response = Configure::read('responseError') + $result;
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;
		}
	}

	/**
	 * forgetPassword
	 *
	 */
	function forgetPassword(){
        //Add PWa Test no use SSL
        $appCtr = new AppController();
        $appCtr->corsSSL();

		try{
			$xml = Configure::read('useResponseXML');
			$form = $this->params['form'];
			$email_info = base64_decode($form['content']);
			$email_info = json_decode($email_info,true);
			$learner = $this->SppLearner->find('first',array('conditions'=>array('email'=>$email_info['email_address'])));
			if(!empty($learner)){
				$seed = str_split('abcdefghijklmnopqrstuvwxyz'
				.'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
				.'0123456789');
				shuffle($seed);
				$password = '';
				foreach (array_rand($seed, 10) as $k) $password .= $seed[$k];
				$error = true;
				if($this->send_email($password, $email_info['email_address'])){
					$learner['SppLearner']['password'] = $password;
					$learner['SppLearner']['updated_datetime'] = date('y-m-d h:i:s');
					$save_result = $this->SppLearner->save($learner,array('conditions'=>array('SppLearner.id' => $learner['SppLearner']['id'])));
					if($save_result){
						$error = false;
						$response = Configure::read('responseSuccess');
					}
				}
				if($error){
					$response = Configure::read('responseError');
				}

			} else {
				$response = Configure::read('emailNotExist') ;
			}
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;

		} catch(Exception $e){
			$result['response'] = json_encode($e->getMessage());
			$response = Configure::read('responseError') + $result;
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;
		}
	}

	function updateLearnerInfo(){
        //Add PWa Test no use SSL
        $appCtr = new AppController();
        $appCtr->corsSSL();

		try{
			$xml = Configure::read('useResponseXML');
			$form = $this->params['form'];
			$update_info = base64_decode($form['content']);
			$update_info = json_decode($update_info,true);
			$learner = $this->SppLearner->find('first',array('conditions'=>array('id'=>$update_info['learner_id'])));
			$licenseLength = Configure::read('LICENSE.LENGTH');
			if(!empty($learner)){
				$error = false;
				if($this->Pass4v->checkParamsKey($update_info, array('email')) === true){
					$temp = $this->SppLearner->find('first',array('conditions'=>array('id <> '=>$update_info['learner_id'], 'email' => $update_info['email'])));
					if(!empty($temp)){
						$response = Configure::read('learnerExist');
						$error = true;
					}
				}
				if(!$error){
					$updatedLicense = false;
					$updatedLicenseFailResult = 1;
					if($this->Pass4v->checkParamsKey($update_info, array('email')) === true){
						$learner['SppLearner']['email'] = $update_info['email'];
					}
					if($this->Pass4v->checkParamsKey($update_info, array('nickname')) === true){
						$learner['SppLearner']['nickname'] = $update_info['nickname'];
					}

					if($this->Pass4v->checkParamsKey($update_info, array('password')) === true){
						$updatePassword = $update_info['password'];
						$expr = '/^[0-9]*$/';
						$isNotDigital = !preg_match($expr, $updatePassword);
						if(strlen($updatePassword) != $licenseLength || $isNotDigital){
							$learner['SppLearner']['password'] = $update_info['password'];
						}else{
							$updatedLicense = true;
							$updateLicense = $updatePassword;
							$license = $this->SppLicense->find('first',array('conditions'=>array('license_code'=>$updateLicense)));
							if(!empty($license)){
								$today = date('Y-m-d');
								if($today <= date($license['SppLicense']['expired_end_date']) &&
								$today >= date($license['SppLicense']['expired_start_date']))
								{
									if((!$license['SppLicense']['check_flag']) && $license['SppLicense']['client_used_date'] == null ||
									$license['SppLicense']['check_flag']){
										$license['SppLicense']['client_used_date'] = $today;
										$license['SppLicense']['learner_id'] = $learner['SppLearner']['id'];
										$updatedLicense = true;
										$save_license_result = $this->SppLicense->save($license,array('conditions'=>array('SppLicense.license_code' => $updateLicense)));
										if($save_license_result){
											$updatedLicenseFailResult = 0;
										}else{
											$updatedLicenseFailResult = 1;
										}
									}else if((!$license['SppLicense']['check_flag']) && $license['SppLicense']['client_used_date'] != null){
										$updatedLicenseFailResult = 2;
									}else {
										$updatedLicenseFailResult = 1;
									}

								}
							}
						}

					}
					$save_result = $this->SppLearner->save($learner,array('conditions'=>array('SppLearner.id' => $learner['SppLearner']['id'])));

					if($save_result){
						if($updatedLicense){
							$lists = array();
							$lists['updated_password'] = '0';
							$responseMessage = "";
							if($updatedLicenseFailResult == 0){
								$responseMessage = Configure::read('licenseRegistedSuccess');
								$lists['updated_password'] = '1';
							}else if($updatedLicenseFailResult == 1){
								$responseMessage = Configure::read('licenseRegistedFail');
							}else if($updatedLicenseFailResult == 2){
								$responseMessage = Configure::read('licenseIsUsed');
							}
							$result['response']= json_encode($lists);
							$response = $responseMessage + $result;
						}else{
							$response = Configure::read('responseSuccess');
						}
					} else {
						$response = Configure::read('responseError');
					}
				}

			} else {
				$response = Configure::read('learnerNotExist');
			}

			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;

		} catch(Exception $e){
			$result['response'] = json_encode($e->getMessage());
			$response = Configure::read('responseError') + $result;
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;
		}
	}

	/**
	 *
	 * send email after registry new learning people
	 * @param unknown_type $password
	 * @param unknown_type $dest
	 */
	public function send_email($password, $dest=null)
	{
		$this->Email->smtpOptions = array(
	     'port'=>'465',
	     'timeout'=>'30',
	     'host' => 'ssl://smtp.gmail.com',
	     'username'=>Configure::read('EMAIL.EMAIL_FROM'),
	     'password'=>Configure::read('EMAIL.EMAIL_PASSWORD')
		);
		$this->Email->delivery = 'smtp';
		$this->Email->from    = Configure::read('EMAIL.EMAIL_FROM');
		$this->Email->to      = $dest;
		$this->Email->subject = Configure::read('EMAIL.TITLE');
		$this->Email->template = 'default';
		$this->set('password',$password);
		//$this->Pass4v->accessLog($this->name, "Info", "(".__FUNCTION__."),Email : ".print_r($this->Email,1), $referer, $_SERVER['HTTP_USER_AGENT']);
		$this->Email->send();
		$this->set('smtp_errors', $this->Email->smtpError);
		if(empty($this->Email->smtpError)){
			return true;
		}
		$this->Pass4v->accessLog($this->name, "Warn", "(".__FUNCTION__."),smtp error : ".$this->Email->smtpError, $referer, $_SERVER['HTTP_USER_AGENT']);
		return false;
	}

	/**
	 *
	 * Check learner is blocked
	 * @param $learner_id
	 * @return YES(1): Block; NO(0): Active
	 */
	public function getLearnerState(){
		try{
			$xml = Configure::read('useResponseXML');
			$form = $this->params['form'];
			$content = base64_decode($form['content']);
			$content = json_decode($content,true);
			$learner_id = $content['learner_id'];

			// Get result
			$returnStr = '0';
			if($this->checkUserIsBlocked($learner_id)){
				$returnStr = '1';
			}

			$dataresponse= array();
			$dataresponse['state']= $returnStr;

			$result['response'] = base64_encode(json_encode($dataresponse));
			$response = Configure::read('responseSuccess') + $result;
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;

		} catch(Exception $e){
			$result['response'] = json_encode($e->getMessage());
			$response = Configure::read('responseError') + $result;
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;
		}
	}

	/**
	 * checkUserIsBlocked
	 * @param: $learner_id
	 * @return: true: is blocked
	 **/
	private function checkUserIsBlocked($learner_id = null){
		$query = "SELECT class.id as classification_id
						FROM spp_learners AS learner, spp_learner_classifications AS class
						WHERE learner.id =  '".$learner_id."' " .
						"AND learner.learner_classification_id = class.id" ;
		$result_sql = mysql_query($query) or die(mysql_error());
			
		// Get result
		if($row = mysql_fetch_array($result_sql)){
			if($row['classification_id'] == Configure::read('LEARNER_CLASSIFICATION.BLOCK')){
				return true;
			}else{
				return false;
			}
		}
		return true;
	}

	/**
	 * getFirstRank
	 *
	 */
	function getFirstRank(){
		try{
			$xml = Configure::read('useResponseXML');

			// Get result
			$rank = $this->SppRankMaster->find('first', array(
														'conditions' => array('mark <>' => NULL),
														'order' => array('rank_no' => 'asc'),
														'limit' => 1 ));
			$return_rank = null;
			if(!empty($rank)){
				$return_rank['rank_no'] = $rank['SppRankMaster']['rank_no'];
				$return_rank['name'] = $rank['SppRankMaster']['name'];
				$return_rank['image'] = $rank['SppRankMaster']['image'];
			}
			//$dataresponse['Rank']= $return_rank;
			$result['response'] = base64_encode(json_encode($return_rank));
			$response = Configure::read('responseSuccess') + $result;
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;

		} catch(Exception $e){
			$result['response'] = json_encode($e->getMessage());
			$response = Configure::read('responseError') + $result;
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;
		}

	}
	/**
	 *
	 * get Rank List on Server
	 * @param empty
	 * @return "Ranks":[{"rank_no":"", "name":""}, {"rank_no":"", "name":""}]
	 */
	function getRanks(){
        $appCtr = new AppController();
        $appCtr->corsSSL();
		try{
			$xml = Configure::read('useResponseXML');

			// Get result
			$ranks = $this->SppRankMaster->find('all', array(
														'conditions' => array('mark <>' => NULL),
														'order' => array('rank_no' => 'asc')));
			$return_ranks = array();
			if(!empty($ranks)){
				foreach ($ranks as $rank){
					$return_rank['rank_no'] = $rank['SppRankMaster']['rank_no'];
					$return_rank['name'] = $rank['SppRankMaster']['name'];
					array_push($return_ranks, $return_rank);
				}
			}
			$dataresponse['Ranks']= $return_ranks;
			$result['response'] = base64_encode(json_encode($dataresponse));
			$response = Configure::read('responseSuccess') + $result;
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;

		} catch(Exception $e){
			$result['response'] = json_encode($e->getMessage());
			$response = Configure::read('responseError') + $result;
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;
		}
	}

	/**
	 *
	 * getTop100ThisWeekLearner
	 * @param empty
	 * @return "learners":[{"name":"", "point":"", "total_learning_time":""}, {"name":"", "point":"", "total_learning_time":""}]
	 */
	function getTop100ThisWeekLearner(){
		$appCtr = new AppController();
        $appCtr->corsSSL();
		try{
			$xml = Configure::read('useResponseXML');
			$limit = 100;
			// Get result
			$query = "SELECT DISTINCT learner.nickname AS nickname,
						(record.mark - last_week.mark) AS mark,
						(record.learning_time_seconds - last_week.learning_time_seconds) AS learning_time, 
						record.point_update AS point_update
						FROM spp_study_records AS record,
							spp_learners AS learner,
							spp_last_week_learning_records AS last_week
						WHERE record.learner_id = learner.id 
						AND record.invalid_flg = 0 
						AND record.learner_id = last_week.learner_id
						AND (record.mark + record.point_update - last_week.mark)  != 0
						ORDER BY (record.mark + record.point_update - last_week.mark) DESC, 
								(record.learning_time_seconds - last_week.learning_time_seconds) DESC, 
								record.learner_id ASC
						LIMIT ". $limit;
			$result_sql = mysql_query($query) or die(mysql_error());

			// Get result
			$return_learners = array();
			while($row = mysql_fetch_array($result_sql)){
				$return_learner['nickname'] = !empty($row['nickname']) ? $row['nickname'] : '---';
				$return_learner['mark'] = $row['mark'] + $row['point_update'];
				$return_learner['total_learning_time'] = $this->formatHHMM($row['learning_time']);
				array_push($return_learners, $return_learner);
			}

			$dataresponse['learners']= $return_learners;
			$result['response'] = base64_encode(json_encode($dataresponse));
			$response = Configure::read('responseSuccess') + $result;
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;

		} catch(Exception $e){
			$result['response'] = json_encode($e->getMessage());
			$response = Configure::read('responseError') + $result;
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;
		}
	}

	/**
	 *
	 * getLearnerListByRank
	 * @param $learner_id
	 * @return "learners":[{"name":"", "point":"", "total_learning_time":""}, {"name":"", "point":"", "total_learning_time":""}]
	 */
	function getLearnerListByRank(){
        $appCtr = new AppController();
        $appCtr->corsSSL();
		try{
			$xml = Configure::read('useResponseXML');
			$form = $this->params['form'];
			$content = base64_decode($form['content']);
			$content = json_decode($content,true);
			$rank_no = $content['rank_no'];
			$res = $this->Pass4v->checkParamsKey($content, array('learner_id'));
			if ($res !== true) {
				$learner_id = "";
			}else{
				$learner_id = $content['learner_id'];
			}

			// Get result
			$query = "SELECT DISTINCT learner.nickname AS nickname, record.mark AS mark,
						record.learning_time_seconds AS learning_time, record.point_update AS point_update
						FROM spp_study_records AS record, spp_rank_masters AS rank, spp_learners AS learner
						WHERE rank.rank_no = '".$rank_no."' AND rank.id = record.rank_id AND record.learner_id = learner.id 
						AND (record.invalid_flg = 0 OR record.learner_id = '".$learner_id."') 
						ORDER BY (record.mark + record.point_update) DESC, record.learning_time_seconds DESC, record.learner_id ASC";
			$result_sql = mysql_query($query) or die(mysql_error());

			// Get result
			$return_learners = array();
			while($row = mysql_fetch_array($result_sql)){
				$return_learner['nickname'] = !empty($row['nickname']) ? $row['nickname'] : '---';
				$return_learner['mark'] = $row['mark'] + $row['point_update'];
				$return_learner['total_learning_time'] = $this->formatHHMM($row['learning_time']);
				array_push($return_learners, $return_learner);
			}

			$dataresponse['learners']= $return_learners;
			$result['response'] = base64_encode(json_encode($dataresponse));
			$response = Configure::read('responseSuccess') + $result;
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;

		} catch(Exception $e){
			$result['response'] = json_encode($e->getMessage());
			$response = Configure::read('responseError') + $result;
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;
		}
	}

	private function formatHHMM($learning_time){
		$total_minutes = ceil($learning_time/60);
		$hours = floor($total_minutes / 60);
		$minutes = $total_minutes % 60;
		return $hours ."h ". $minutes . "m";
	}

	/**
	 * getCorrectionEdittedStatus
	 * @param learner_id
	 * @param content_id
	 * @param category_no
	 * @param subcategory_no
	 * @param quiz_no
	 */
	function getCorrectionEdittedStatus(){
		try{
			$xml = Configure::read('useResponseXML');
			$form = $this->params['form'];
			$content = base64_decode($form['content']);
			$content = json_decode($content,true);
			$learner_id = $content['learner_id'];
			$content_id = $content['content_id'];
			$category_no = $content['category_no'];
			$subcategory_no = $content['subcategory_no'];
			$quiz_no = $content['quiz_no'];

			// Get result
			$returnStr = '0';
			if($this->checkCorrectionIsEditted($learner_id, $content_id, $category_no, $subcategory_no, $quiz_no)){
				$returnStr = '1';
			}

			$dataresponse= array();
			$dataresponse['is_editted']= $returnStr;

			$result['response'] = base64_encode(json_encode($dataresponse));
			$response = Configure::read('responseSuccess') + $result;
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;

		} catch(Exception $e){
			$result['response'] = json_encode($e->getMessage());
			$response = Configure::read('responseError') + $result;
			$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
			return;
		}
	}

	private function checkCorrectionIsEditted($learner_id, $content_id, $category_no, $subcategory_no, $quiz_no){

		$correction = $this->SppCorrection->find('first',array('conditions'=>array('learner_id'=>$learner_id,
											'content_id'=>$content_id, 'category_no'=>$category_no, 
											'subcategory_no'=>$subcategory_no, 'quiz_no'=>$quiz_no)));
		if(!empty($correction)
		&& !empty($correction['SppCorrection']['correction_datetime'])){
			return true;
		}

		return false;
	}

	function checkGeneralInfo(){
		$xml = Configure::read('useResponseXML');
		$form = $this->params['form'];
		$content = base64_decode($form['content']);
		$content = json_decode($content,true);
		$res = $this->Pass4v->checkParamsKey($content, array('learner_id'));
		if ($res !== true) {
			$learner_id = "";
		}else{
			$learner_id = $content['learner_id'];
		}
		$dataresponse= array();
		$dataresponse['show_license_input']= Configure::read('SETTING.SHOW_LICENSE_INPUT') == 1;
		$dataresponse['message_available']= $this->checkExistMessage($learner_id);
		$dataresponse['question_available']= $this->checkExistingQuestion($learner_id);
		$dataresponse['correction_available']= false;
		if(!empty($learner_id)){
			$dataresponse['correction_available']= $this->checkExistingCorrection($learner_id);
		}
		$result['response'] = base64_encode(json_encode($dataresponse));
		$response = Configure::read('responseSuccess') + $result;
		$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
		return;
	}

	/**
	 *
	 * check existing message for learner
	 * @param unknown_type $learner_id
	 */
	private function checkExistMessage($learner_id){
		try{
			$organization_code = null;
			$rank_id = null;
			$learner = $this->SppLearner->getLearnerWithStudyRecord($learner_id);
			if(!empty($learner)){
				$organization_code = $learner['SppLearner']['organization_code'];
				if(!empty($learner['SppStudyRecord']['rank_id'])){
					$rank_id = $learner['SppStudyRecord']['rank_id'];
				}
			}
			$delidate = date('Y-m-d');
			$arr_pull_msg = $this->SppPullMessage->find('all', array('conditions' => array('OR' => array('delivery_date <=' => $delidate, 'delivery_date' => null)),
																	 'order' => array('delivery_date DESC', 'created_datetime DESC' )));
			if(!empty($arr_pull_msg)){
				foreach ($arr_pull_msg as $pull_msg){
					if($this->checkMessageForLearner($pull_msg, $learner_id, $organization_code, $rank_id)){
						return true;
					}
				}
			}
		}catch (Exception $e){}
		return false;
	}

	/**
	 *
	 * check existing correction with learner_id
	 */
	private function checkExistingCorrection($learner_id){
		try{
			$correction = $this->SppCorrection->getCorrection($learner_id);
			if(!empty($correction)){
				return true;
			}
		}catch (Exception $e){}
		return false;
	}

	/**
	 *
	 * check existing question with learner_id
	 */
	private function checkExistingQuestion($learner_id){
		try{
			$conditions = array();
			$questions = $this->SppQuestion->find('first', array('conditions' => array(
			'OR' => array('learner_id' => $learner_id, 
			array('learner_id NOT LIKE ' =>$learner_id, 'is_public' => 1,'answered_datetime <>'=> NULL)))));
			if(!empty($questions)){
				return true;
			}
		}catch (Exception $e){}
		return false;
	}

	/**
	 *
	 * check message should send to learner or not
	 * @param unknown_type $message
	 * @param unknown_type $learner_id
	 * @param unknown_type $organization_code
	 * @param unknown_type $rank_id
	 */
	private function checkMessageForLearner($message, $learner_id, $organization_code, $rank_id){
		if($message['SppPullMessage']['all'] == 0){
			if(!empty($message['SppPullMessage']['organization_code'])){
				//#55911, upcase before compare
				if(strtoupper($message['SppPullMessage']['organization_code']) != strtoupper($organization_code)){
					return  false;
				}
			}

			if(!empty($message['SppPullMessage']['rank_id'])){
				if($message['SppPullMessage']['rank_id'] != $rank_id){
					return false;
				}
			}

			if(!empty($message['SppPullMessage']['learner_id'])){
				if($message['SppPullMessage']['learner_id'] != $learner_id){
					return false;
				}
			}
		}
		return true;
	}

	public function getAllCalendarContents() {
		$xml = Configure::read('useResponseXML');
		$form = $this->params['form'];
		if (!$this->Pass4v->firstCheck($form, array('calendar_contentid'), __FUNCTION__, $xml)) {
			return ;
		}
		$conditions = array('is_public' => true, 'OR' => array('reservation_flag' => false, 'created_date <= ' => date('y-m-d')));
		if($form['calendar_contentid'] == 0) {
			$conditions[] = "is_free = 1";
		}
		$calendarContents = $this->SppCalendarContent->find('all', array(
							'fields' => array('DISTINCT created_date'),
							'conditions' => $conditions,
							'order' => array('created_date' =>'desc')));
		$dataresponse = array();
		if(!empty($calendarContents)){
			foreach ($calendarContents as $item){
				//date('Y/m/d',strtotime($item['SppCalendarContent']['created_date']))
				array_push($dataresponse, $item['SppCalendarContent']['created_date']);
			}
		}
		$result['response'] = json_encode($dataresponse);
		$response = Configure::read('responseSuccess') + $result;
		$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
		return;
	}

	public function getCalendarContentsByDate() {
		$xml = Configure::read('useResponseXML');
		$form = $this->params['form'];
		if (!$this->Pass4v->firstCheck($form, array('calendar_contentid','selected_date'), __FUNCTION__, $xml)) {
			return ;
		}
		$conditions = array('created_date' => $form['selected_date'],
							'is_public' => true,
							 'OR' => array('reservation_flag' => false, 'created_date <= ' => date('y-m-d')));
		if($form['calendar_contentid'] == 0) {
			$conditions[] = "is_free = 1";
		}
		$calendarContents = $this->SppCalendarContent->find('all', array(
							'fields' => array('id', 'title_icon', 'title', 'sort_order'),
							'conditions' => $conditions,
							'order' => array('sort_order' => 'asc')));
		$dataresponse = array();
		if(!empty($calendarContents)){
			$actual_link = "http://".$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI'];
			$actual_link = substr($actual_link, 0, strpos($actual_link, "/sppserver/") + 1);
			foreach ($calendarContents as $item){
				//date('Y/m/d',strtotime($item['SppCalendarContent']['created_date']))
				$item['SppCalendarContent']['title_icon'] = str_replace("../", $actual_link , $item['SppCalendarContent']['title_icon']);
				array_push($dataresponse, $item['SppCalendarContent']);
			}
		}
		$result['response'] = json_encode($dataresponse);
		$response = Configure::read('responseSuccess') + $result;
		$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
		return;
	}

	public function getCalendarContentById() {
		$xml = Configure::read('useResponseXML');
		$form = $this->params['form'];
		if (!$this->Pass4v->firstCheck($form, array('calendar_contentid','id'), __FUNCTION__, $xml)) {
			return ;
		}
		$conditions = array('id' => $form['id'],
							'is_public' => true,
							 'OR' => array('reservation_flag' => false, 'created_date <= ' => date('y-m-d')));
		if($form['calendar_contentid'] == 0) {
			$conditions[] = "is_free = 1";
		}
		$calendarContent = $this->SppCalendarContent->find('first', array(
							'conditions' => $conditions));
		if($calendarContent) {
			$actual_link = "http://".$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI'];
			$actual_link = substr($actual_link, 0, strpos($actual_link, "/sppserver/") + 1);
			$calendarContent['SppCalendarContent']['title_icon'] = str_replace("../", $actual_link , $calendarContent['SppCalendarContent']['title_icon']);
			$calendarContent['SppCalendarContent']['body_content'] = str_replace('src="../', 'src="'.$actual_link , $calendarContent['SppCalendarContent']['body_content']);
		}
		$result['response'] = json_encode($calendarContent['SppCalendarContent']);
		$response = Configure::read('responseSuccess') + $result;
		$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
		return;
	}
	
	//Get timeline top image
	public function getTopImage() {
		$xml 	= Configure::read('useResponseXML');
		$form 	= $this->params['form'];		
		$topImage 		= $this->SppTopImage->find('first');
		$dataresponse 	= array();
		if(!empty($topImage)){
			$actual_link = "http://".$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI'];
			$actual_link = substr($actual_link, 0, strpos($actual_link, "/sppserver/") + 1);
			$topImage['SppTopImage']['image_path'] = str_replace("../", $actual_link , $topImage['SppTopImage']['image_path']);		
		}
		$result['response'] = json_encode($topImage['SppTopImage']);
		$response = Configure::read('responseSuccess') + $result;
		$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
		return;
	}

	public function getTimelineContentList(){
		$xml = Configure::read('useResponseXML');
		$form = $this->params['form'];

		$conditions = array();

		if(isset($form['id']) ){
			$conditions['SppTimelineContent.id'] = intval($form['id']);
		}

		if(isset($form['is_free']) && $form['is_free'] != 0){
			$conditions['SppTimelineContent.is_free'] = intval($form['is_free']);
		}
		
		$conditions['SppTimelineContent.is_public'] = 1;
		
		if(isset($form['top_flag'] )){
			$conditions['SppTimelineContent.top_flag'] = intval($form['top_flag']);
		}

		//Check ok
		if(isset($form['tag_id'] )){
			$conditions['SppTimelineContent.tag_id'] = intval($form['tag_id']);
		}

		//予約フラグ＝”0”（予約なし）は全て取得。“1” （予約あり）は、当日までのものを取得する。
		$conditions['OR'] = array(
            array(
            	'SppTimelineContent.reservation_flag' => 1,
                //'SppTimelineContent.created_date' =>date('Y-m-d')	
                'SppTimelineContent.created_date <=' =>date('y-m-d')
            ),
            'SppTimelineContent.reservation_flag' => 0
        );

		//有効期限 > 当日
		/*$conditions['OR'] = array(
			'SppTimelineContent.expiration_date >=' => date('y-m-d'),
			'SppTimelineContent.expiration_date ' 	=> NULL,
			'SppTimelineContent.expiration_date ' 	=> "0000-00-00"
		);*/
		$conditions['AND'] = array(
			'OR'=>array(
				'SppTimelineContent.expiration_date >=' => date('y-m-d'),
				'SppTimelineContent.expiration_date =' 	=> NULL,
				'SppTimelineContent.expiration_date ' 	=> "0000-00-00"
			)
		);

        //$conditions['SppTimelineContent.expiration_date >='] = date('y-m-d');	
			

		$timelineContents = $this->SppTimelineContent->find('all', array(
							'joins' => array(
						        array(
						            'table' => 'spp_tags',
						            'alias' => 'Tag',
						            'type' 	=> 'LEFT',
						            'conditions' => array(
						                'SppTimelineContent.tag_id = Tag.id'
						            )
						        )
						    ),							
							'conditions' => $conditions,
							'fields' 	 => array('Tag.tag_name','Tag.tag_image_path', 'SppTimelineContent.*'),
							'order' 	 => array('created_date' =>'desc','sort_order' =>'asc'),
							));

		$dataresponse = array();

		if(!empty($timelineContents)){
			$actual_link = "http://".$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI'];
			$actual_link = substr($actual_link, 0, strpos($actual_link, "/sppserver/") + 1);
			foreach ($timelineContents as $item){
				$item['SppTimelineContent']['title_banner'] = str_replace("../", $actual_link , $item['SppTimelineContent']['title_banner']);
				$item['SppTimelineContent']['audio_file']   = str_replace("../", $actual_link , $item['SppTimelineContent']['audio_file']);
				$item['SppTimelineContent']['body_content'] = str_replace('src="../', 'src="'.$actual_link , $item['SppTimelineContent']['body_content']);
				$item['SppTimelineContent']['created_date'] = str_replace('-', '/' , $item['SppTimelineContent']['created_date']);
				$item['SppTimelineContent']['expiration_date'] = str_replace('-', '/' , $item['SppTimelineContent']['expiration_date']);				

				unset($item['SppTimelineContent']['title_icon']);
				unset($item['SppTimelineContent']['body_images']);

				$item['Tag']['tag_image_path'] 		= str_replace("../", $actual_link , $item['Tag']['tag_image_path']);
				$item['SppTimelineContent']['tag_info'] 	= $item['Tag'];

				if($item['SppTimelineContent']['title_banner'] == ""){
					unset($item['SppTimelineContent']['title_banner']);
				}
				if($item['SppTimelineContent']['audio_file'] == ""){
					unset($item['SppTimelineContent']['audio_file']);
				}
				array_push($dataresponse, $item['SppTimelineContent']);
			}
		}

		$result['response'] = json_encode($dataresponse);
		$response = Configure::read('responseSuccess') + $result;
		$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
		return;
	}

	//Detail content timeline
	public function getTimelineContentByID(){
		$xml = Configure::read('useResponseXML');
		$form = $this->params['form'];
		if (!$this->Pass4v->firstCheck($form, array('id'), __FUNCTION__, $xml)) {
			return ;
		}
		$conditions = array('SppTimelineContent.id' => intval($form['id']));

		$timelineContents = $this->SppTimelineContent->find(
			'first', 
			array(				
				'joins' => array(
			        array(
			            'table' => 'spp_tags',
			            'alias' => 'Tag',
			            'type' 	=> 'LEFT',
			            'conditions' => array(
			                'SppTimelineContent.tag_id = Tag.id'
			            )
			        )
			    ),
				'conditions' => $conditions,
				'fields' => array('Tag.tag_name','Tag.tag_image_path', 'SppTimelineContent.*'),
			)
		);

		if(!empty($timelineContents)){
			$actual_link = "http://".$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI'];
			$actual_link = substr($actual_link, 0, strpos($actual_link, "/sppserver/") + 1);
		
			$timelineContents['SppTimelineContent']['title_banner'] = str_replace("../", $actual_link , $timelineContents['SppTimelineContent']['title_banner']);
			$timelineContents['SppTimelineContent']['audio_file']   = str_replace("../", $actual_link , $timelineContents['SppTimelineContent']['audio_file']);
			$timelineContents['SppTimelineContent']['body_content'] = str_replace('src="../', 'src="'.$actual_link , $timelineContents['SppTimelineContent']['body_content']);
			$timelineContents['SppTimelineContent']['created_date'] = str_replace('-', '/' , $timelineContents['SppTimelineContent']['created_date']);
			$timelineContents['SppTimelineContent']['expiration_date'] = str_replace('-', '/' , $timelineContents['SppTimelineContent']['expiration_date']);
			$timelineContents['Tag']['tag_image_path'] 		= str_replace("../", $actual_link , $timelineContents['Tag']['tag_image_path']);
			unset($timelineContents['SppTimelineContent']['title_icon']);
			unset($timelineContents['SppTimelineContent']['body_images']);		
			$timelineContents['SppTimelineContent']['tag_info'] 	= $timelineContents['Tag'];

			if($timelineContents['SppTimelineContent']['title_banner'] == ""){
				unset($timelineContents['SppTimelineContent']['title_banner']);
			}
			if($timelineContents['SppTimelineContent']['audio_file'] == ""){
				unset($timelineContents['SppTimelineContent']['audio_file']);
			}
			
			// Update view content
			$timelineContents['SppTimelineContent']['viewed']= $timelineContents['SppTimelineContent']['viewed'] + 1; 
	        $this->SppTimelineContent->save($timelineContents);
			
		
			
		}
		
		$result['response'] = json_encode($timelineContents['SppTimelineContent']);
		$response = Configure::read('responseSuccess') + $result;
		$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
		return;
	}


	public function getTagList(){
		$xml = Configure::read('useResponseXML');
		$form = $this->params['form'];
		$tagList = $this->SppTag->find('all',
			array(
				'fields' => array('id as tag_id','tag_name','tag_image_path'),
			)
		);
		$dataresponse = array();
		if(!empty($tagList)){
			$actual_link = "http://".$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI'];
			$actual_link = substr($actual_link, 0, strpos($actual_link, "/sppserver/") + 1);	
			foreach ($tagList as $item){	
				$item['SppTag']['tag_image_path'] = str_replace("../", $actual_link , $item['SppTag']['tag_image_path']);
				array_push($dataresponse, $item['SppTag']);
			}
		}
		
		$result['response'] = json_encode($dataresponse);
		$response = Configure::read('responseSuccess') + $result;
		$this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
		return;
	}

	public function getInfoDeviceLogin(){
        try{
            $xml = Configure::read('useResponseXML');
            $form = $this->params['form'];
            $login_info = base64_decode($form['content']);
            $login_info = json_decode($login_info,true);
            $learnerId = $login_info['learner_id'];

            $learner = $this->SppLearner->find('first', array('conditions' => array('id'=> $learnerId)));
            if(!empty($learner)){
                $dataresponse['learner_info']= $learner['SppLearner'];
                $result['response'] = base64_encode(json_encode($dataresponse));
                if ($login_info['device_token'] == $learner['SppLearner']['device_token'] || $learner['SppLearner']['device_token'] == null || $learner['SppLearner']['device_token'] == 1) {
                    $response = Configure::read('responseSuccess');
                    $response['status'] = $learner['SppLearner']['device_token'];
                } else {
                    $response = Configure::read('responseNG');
                }
            } else {
                $response = Configure::read('loginFailure');
            }

            //Add PWA Test use SSL
            $appCtr = new AppController();
            $appCtr->corsSSL();

            $this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
            return;

        } catch(Exception $e){
            $result['response'] = json_encode($e->getMessage());
            $response = Configure::read('responseError') + $result;
            $this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
            return;
        }
    }

    /**
     *
     * updateDeviceToken
     *
     */
    function updateDeviceToken(){
        try{
            $xml = Configure::read('useResponseXML');
            $form = $this->params['form'];
            $login_info = base64_decode($form['content']);
            $login_info = json_decode($login_info,true);

             $learnerId = $login_info['learner_id'];

            $learner = $this->SppLearner->find('first', array('conditions' => array('id'=> $learnerId)));
            if(!empty($learner)){
                $dataresponse= array();
                if(isset($login_info['device_token'])){
                    $learner['SppLearner']['login_time'] = date('Y-m-d H:i:s');
                    if (!empty($login_info['device_token'])){
                        $learner['SppLearner']['device_token'] = $login_info['device_token'];
                    }
                    $this->SppLearner->save($learner,array('conditions'=>array('SppLearner.id' => $learner['SppLearner']['id'])));
                }
                $dataresponse['learner_info']= $learner['SppLearner'];
                $result['response'] = base64_encode(json_encode($dataresponse));
                $response = Configure::read('responseSuccess') + $result;
            } else {
                $response = Configure::read('loginFailure');
            }

            //Add PWA Test use SSL
            $appCtr = new AppController();
            $appCtr->corsSSL();

            $this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
            return;

        } catch(Exception $e){
            $result['response'] = json_encode($e->getMessage());
            $response = Configure::read('responseError') + $result;
            $this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
            return;
        }
    }
    /**
     *
     * updateDeviceToken
     *
     */

    /**
     *
     * updateStatusMessage
     *
     */
    function updateStatusMessage(){
        try{
            $xml = Configure::read('useResponseXML');
            $form = $this->params['form'];
            $param_info = base64_decode($form['content']);
            $login_info = json_decode($param_info,true);

            $learnerId = $login_info['learner_id'];

            $learner = $this->SppLearner->find('first', array('conditions' => array('id'=> $learnerId)));
            if(!empty($learner)){
                $dataresponse= array();
                if (isset($login_info['message_list'])){
                    if (!empty($learner['SppLearner']['message_list'])) {
                        $learner['SppLearner']['message_list'] = $learner['SppLearner']['message_list'] . ',' . $login_info['message_list'];
                    } else {
                        $learner['SppLearner']['message_list'] = $login_info['message_list'];
                    }

                    $this->SppLearner->save($learner,array('conditions'=>array('SppLearner.id' => $learner['SppLearner']['id'])));
                }

                $dataresponse['learner_info']= $learner['SppLearner'];
                $result['response'] = base64_encode(json_encode($dataresponse));
                $response = Configure::read('responseSuccess') + $result;
            } else {
                $response = Configure::read('loginFailure');
            }

            //Add PWA Test use SSL
            $appCtr = new AppController();
            $appCtr->corsSSL();

            $this->Pass4v->response($response, "(".__FUNCTION__.")",$xml) ;
            return;

        } catch(Exception $e){
            $result['response'] = json_encode($e->getMessage());
            $response = Configure::read('responseError') + $result;
            $this->Pass4v->response($response, "(".__FUNCTION__.")",$xml);
            return;
        }
    }
    /**
     *
     * updateStatusMessage
     *
     */

}
