import db from './db.js';
import Login from "./login";
import config from "./config"; 

import Dexie from "dexie";
import Message from "./message";
const $    = require('jquery');
const jsCookie      = require('js-cookie');

export default class SyncData {

    clearData () {

        db.category.clear();
        db.sub_category.clear();
        db.quizzes.clear();
        db.choices.clear();

        db.record.clear();
        db.contents.clear();
        db.subcontents.clear();
        db.selectboxes.clear();

        db.progress_images.clear();
        db.rankboxes.clear();
        db.ranking.clear();
        db.related_images.clear();
        db.top_incorrect_quizzes.clear();
        db.learning_logs.clear();
        db.message.clear();
        db.random_quiz.clear();
        db.continue_quiz.clear();

        db.packaged_sync.clear();
        db.user.clear();

        return true;
    }

    checkDataExists () {
        return Dexie.exists("tac").then(function(exists) {
            if (exists) {
                return true;
            }
            return false;
        });
    }

    /**
     * check data from server & update data client 
     *
     * @param isLogin leaner id
     * @param allDataForClient
     * @updated 07.01.2019
     * @author  ChienNguyen
     */

    handleSyncDataFromServer(isLogin, allDataForClient) {

        // if isset isLogin, it is a leaner id
        let learner_id = null;
        let is_login = 0;
        if(isLogin)
        {
            learner_id = isLogin;
            is_login = 1;
        }

        let tmpParamSync = {
                    'is_login'          : is_login,
                    'learner_id'        : learner_id,
                    'allDataForClient'  : allDataForClient
                };
        var content = window.btoa(JSON.stringify(tmpParamSync));
        jsCookie.set('data_sync_seccess', false, { expires: 1 });

        $.ajax({
            method: "POST",
            url: config.url_api_update_ver_data,
            data: {'content' : content},
            dataType: "json",
            async: false,
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            success: function (response) {
                if (response.data != null) {
                    try {
                        // 
                        var strDataResponse = window.atob(response.data);
                        // 
                        var result = JSON.parse(strDataResponse);

                        if(result.data.packaged_sync.length > 0) {

                            db.open();

                            /**
                             * handle data updates 
                             * is first check & update category 
                             *
                             * The purpose is to know which categories add or update
                             * @updated 09.01.2019
                             */

                            // get list category on client
                            let list_category_current = db.category.orderBy('category_no').toArray();
                            let arrayCateCurrent = [];

                            list_category_current.then(function(categorys_current) {
                                //  set array
                                categorys_current.forEach(cate_current =>  {
                                    arrayCateCurrent.push(cate_current.category_no);
                                });
                               

                                // update category
                                let list_cate_on_server = result.data['categories'];
                                if(list_cate_on_server && Array.isArray(list_cate_on_server)){
                                   
                                    // conver data before put
                                    list_cate_on_server.forEach(cate_server =>  {
                                        //  set primary key for choice
                                        cate_server.id = cate_server.category_no;
                                    });

                                    db.category.bulkPut(list_cate_on_server).then(function(lastKey) {
                                        console.log("Last category id was: " + lastKey); 
                                    }).catch(Dexie.BulkError, function (e) {
                                        console.error ("Some category did not succeed. However, " +
                                           100000-e.failures.length + " raindrops was added successfully");
                                    });
                                }

                                // update subcategories
                                let list_subcategories_on_server = result.data['subcategories'];
                                if(list_subcategories_on_server && Array.isArray(list_subcategories_on_server)){
                                    // conver data
                                    list_subcategories_on_server.forEach(list_subcate =>  {
                                        let array_key = [list_subcate.category_no, list_subcate.subcategory_no];
                                        let primary_key = array_key.toString();

                                        list_subcate.totalQuizOfSubCategory = 0;
                                        list_subcate.id = primary_key;
                                    });

                                    db.sub_category.bulkPut(list_subcategories_on_server).then(function(lastKey) {
                                        console.log("Last sub_category id was: " + lastKey); 
                                    }).catch(Dexie.BulkError, function (e) {
                                        console.error ("Some sub_category did not succeed. However, " +
                                           100000-e.failures.length + " raindrops was added successfully");
                                    });
                                }

                                // update quizzes
                                let list_quizzes_on_server = result.data['quizzes'];
                                if(list_quizzes_on_server && Array.isArray(list_quizzes_on_server)){
                                    // conver data
                                    list_quizzes_on_server.forEach(quizze_server =>  {
                                        let array_key = [quizze_server.category_no, quizze_server.subcategory_no, quizze_server.quiz_no];
                                        let primary_key = array_key.toString();
                                        //  set primary key for quizzes
                                        quizze_server.id = primary_key;
                                    });

                                    db.quizzes.bulkPut(list_quizzes_on_server).then(function(lastKey) {
                                        console.log("Last quizzes id was: " + lastKey); 
                                        // updated totalQuizOfSubCategory for sub category
                                        
                                        var updated = db.sub_category
                                            .toArray((sub_categorys) => {
                                                sub_categorys.forEach(sub_cate => {
                                                   let totalQuizOfSubCategory = db.quizzes
                                                            .where('category_no').equals(sub_cate.category_no)
                                                            .and((quizzes) =>
                                                                (
                                                                    quizzes.subcategory_no == sub_cate.subcategory_no
                                                                )
                                                            )
                                                            .count();
                                                    totalQuizOfSubCategory.then(function (total) {
                                                        sub_cate.totalQuizOfSubCategory = total;
                                                        db.sub_category.put(sub_cate).catch('Data Limit', err => {
                                                            console.log("--- Error Put sub_category ---");
                                                        });
                                                    });
                                                });
                                            });
                                        console.log("updated totalQuizOfSubCategory success !"); 
                                    }).catch(Dexie.BulkError, function (e) {
                                        console.error ("Some quizzes did not succeed. However, " +
                                           100000-e.failures.length + " raindrops was added successfully");
                                    });
                                }

                                 // update records
                                if(isLogin && Array.isArray(result.data['records']))
                                {
                                    let list_record_on_server = result.data['records'];
                                    if(list_record_on_server && Array.isArray(list_record_on_server)){
                                        list_record_on_server.forEach(record =>  {
                                            let array_key = [record.category_no, record.subcategory_no, record.quiz_no];
                                            let primary_key = array_key.toString();
                                            record.id = primary_key;
                                            // 
                                            if(record.selectbox == 1)
                                            {
                                                record.selectbox = true;
                                            }
                                            else
                                            {
                                                record.selectbox = false;
                                            }

                                            record.is_modify = 0;

                                        });

                                        db.record.bulkPut(list_record_on_server).then(function(lastKey) {
                                            console.log("Last record id was: " + lastKey); 
                                        }).catch(Dexie.BulkError, function (e) {
                                            console.error ("Some record did not succeed. However, " +
                                                   100000-e.failures.length + " raindrops was added successfully");
                                        });
                                    }
                                }


                                // update choices
                                let list_choices_on_server = result.data['choices'];
                                // conver data
                                if(list_choices_on_server && Array.isArray(list_choices_on_server)){
                                    list_choices_on_server.forEach(choice_server =>  {
                                        let array_key = [choice_server.content_id, choice_server.category_no, choice_server.subcategory_no, choice_server.quiz_no, choice_server.choice_no];
                                        let primary_key = array_key.toString();

                                        //  set primary key for choice
                                        choice_server.id = primary_key;
                                    });

                                    db.choices.bulkPut(list_choices_on_server).then(function(lastKey) {
                                        console.log("Last choices id was: " + lastKey); 
                                    }).catch(Dexie.BulkError, function (e) {
                                        console.error ("Some choices did not succeed. However, " +
                                           100000-e.failures.length + " raindrops was added successfully");
                                    });
                                }

                                // update contents
                                let list_content_on_server = result.data['contents'];
                                if(list_content_on_server && Array.isArray(list_content_on_server)){
                                    db.contents.bulkPut(list_content_on_server).then(function(lastKey) {
                                        console.log("Last contents id was: " + lastKey); 
                                    }).catch(Dexie.BulkError, function (e) {
                                        console.error ("Some contents did not succeed. However, " +
                                           100000-e.failures.length + " raindrops was added successfully");
                                    });
                                }

                                // update subcontents
                                let list_subcontent_on_server = result.data['subcontents'];
                                if(list_subcontent_on_server && Array.isArray(list_subcontent_on_server)){
                                    db.subcontents.bulkPut(list_subcontent_on_server).then(function(lastKey) {
                                        console.log("Last subcontents id was: " + lastKey); 
                                    }).catch(Dexie.BulkError, function (e) {
                                        console.error ("Some subcontents did not succeed. However, " +
                                           100000-e.failures.length + " raindrops was added successfully");
                                    });
                                }

                                // update selectboxes
                                let list_selectboxe_on_server = result.data['selectboxes'];
                                if(list_selectboxe_on_server && Array.isArray(list_selectboxe_on_server)){
                                    db.selectboxes.bulkPut(list_selectboxe_on_server).then(function(lastKey) {
                                        console.log("Last selectboxes id was: " + lastKey); 
                                    }).catch(Dexie.BulkError, function (e) {
                                        console.error ("Some selectboxes did not succeed. However, " +
                                           100000-e.failures.length + " raindrops was added successfully");
                                    });
                                }

                                // update related_images
                                let list_related_images_on_server = result.data['related_images'];
                                if(list_related_images_on_server && Array.isArray(list_related_images_on_server)){
                                    db.related_images.bulkPut(list_related_images_on_server).then(function(lastKey) {
                                        console.log("Last related_images id was: " + lastKey); 
                                    }).catch(Dexie.BulkError, function (e) {
                                        console.error ("Some related_images did not succeed. However, " +
                                           100000-e.failures.length + " raindrops was added successfully");
                                    });
                                }

                                // update progress_images
                                if(result.data['progress_images'])
                                {
                                    let list_progress_images_on_server = result.data['progress_images'];
                                    if(list_progress_images_on_server && Array.isArray(list_progress_images_on_server)){
                                        db.progress_images.bulkPut(list_progress_images_on_server).then(function(lastKey) {
                                            console.log("Last progress_images id was: " + lastKey); 
                                        }).catch(Dexie.BulkError, function (e) {
                                            console.error ("Some progress_images did not succeed. However, " +
                                               100000-e.failures.length + " raindrops was added successfully");
                                        });
                                    }
                                }

                                // update packaged_sync
                                let list_packaged_sync_on_server = result.data['packaged_sync'];
                                if(list_packaged_sync_on_server && Array.isArray(list_packaged_sync_on_server)){
                                    db.packaged_sync.bulkPut(list_packaged_sync_on_server).then(function(lastKey) {
                                        console.log("Last packaged_sync id was: " + lastKey); 
                                    }).catch(Dexie.BulkError, function (e) {
                                        console.error ("Some packaged_sync did not succeed. However, " +
                                               100000-e.failures.length + " raindrops was added successfully");
                                    });
                                }

                               
                                // update continue
                                let list_continue_quiz_on_server = result.data['continue_logs'];
                                if(list_continue_quiz_on_server && Array.isArray(list_continue_quiz_on_server)){
                                    list_continue_quiz_on_server.forEach(continue_quiz =>  {
                                        continue_quiz.id = continue_quiz.category_no;
                                    });
                                    db.continue_quiz.bulkPut(list_continue_quiz_on_server).then(function(lastKey) {
                                        console.log("Last related_images id was: " + lastKey); 
                                    }).catch(Dexie.BulkError, function (e) {
                                        console.error ("Some continue_quiz did not succeed. However, " +
                                           100000-e.failures.length + " continue_quiz was added successfully");
                                    }); 
                                }
                                

                                // update setting for leaner
                                let settings_log = result.data['settings_log'];
                                if(settings_log){
                                    if(settings_log.sound == 'on')
                                    {
                                        localStorage.setItem("soundon", true); 
                                    }else
                                    {
                                        localStorage.setItem("soundon", false); 
                                    }
                                }

                                // check sync
                                console.log("Sync done !");
            //document.getElementById('movieoff').style.display = 'none';
            //document.getElementById('movieon').style.display = 'block';
            document.getElementById('movieoff').style.display = 'block';
            document.getElementById('movieon').style.display = 'none';
                                jsCookie.set('is_process_sync', false, { expires: 1 });
                                jsCookie.set('data_sync_seccess', true, { expires: 1 });
                            }); 
                        }
                        else
                        {  
                            // check sync
                            console.log("No data found to update !");
                            jsCookie.set('is_process_sync', false, { expires: 1 });  
                        }
                        
                    } catch (e) {
                        console.log(e);
                        alert(config.DATA_LIMIT_DESKTOP.MEG_OVERFLOW_DATA_LIMIT);
                        jsCookie.set('is_process_sync', false, { expires: 1 });
                        jsCookie.set('code_error_process_sync', 1, { expires: 1 });
                    }
                }
                else {
                    jsCookie.set('is_process_sync', false, { expires: 1 });
                    jsCookie.set('code_error_process_sync', 2, { expires: 1 });
                }
            },
            error: function (xhr, status) {
                console.log('Sync Data error');
                jsCookie.set('is_process_sync', false, { expires: 1 });
                jsCookie.set('code_error_process_sync', 3, { expires: 1 });
            },
        });
        return true;
    }

    getMessageList(learner_id, page = "") {
        if (navigator.onLine) {
            var messageObj = new Message();
            var dataContent = window.btoa('{"learner_id":"'+learner_id+'"}');
            var dataRequest = {'content':dataContent};
            $.ajax({
                method: "POST",
                url: config.url_api_message_data,
                data: dataRequest,
                dataType: "json",
                async: false,
                headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                success: function (results) {
                    if (results.response != null) {
                        var strDataResponse = window.atob(results.response);
                        var result = JSON.parse(strDataResponse);
                        result.reverse();
                        db.open();
                        if (page == 'listMessage') {
                            db.message.bulkPut(result).catch('Dsata Limit', err => {
                                err.failures.forEach(failure => {
                                    alert(config.DATA_LIMIT_DESKTOP.MEG_OVERFLOW_DATA_LIMIT)
                                });
                            });

                            return
                        }

                        if(result.length > 0) {
                            var localMess = messageObj.getMessagesList().then(value => {
                                var mgs = [];
                                if (value != null) {
                                    for (var i = 0; i <value.length ; i++){
                                        for(var j = 0; j < result.length; j++) {
                                            if (parseInt(value[i].id) == parseInt(result[j].id)){
                                                result.splice(j, 1)
                                            }
                                        }
                                    }
                                }

                                if (page == "top" && result.length > 0 ) {

                                    for (var k = 0; k <result.length; k++) {

                                        mgs.push(result[k]);
                                        db.message.bulkPut(mgs).catch('Dsata Limit', err => {
                                            err.failures.forEach(failure => {
                                                alert(config.DATA_LIMIT_DESKTOP.MEG_OVERFLOW_DATA_LIMIT)
                                            });
                                        });

                                        var today = new Date();
                                        var  delivery_date = new Date(result[k].delivery_date);

                                        var timeDiff = Math.abs(today.getTime() - delivery_date.getTime());
                                        var dayDiff = Math.ceil(timeDiff / (1000 * 3600 * 24));

                                        if (dayDiff <= 30) {
                                            $('[data-popup="popup-message"]').fadeIn(350);
                                            var span = "<p>" + result[k].message + "</p></br>";
                                            $('.created_datetime_message').append(result[k].delivery_date);
                                            $('.popup-message').append(span);
                                            break;

                                        }
                                    }
                                }
                            });

                        } else {
                        }
                    }
                    else {
                        return false
                    }
                },
                error: function (xhr, status) {
                    console.log('Get message error');
                },
            });
        }

        return true;
    }

    deleteDatabase (databaseName) {
        indexedDB.deleteDatabase(databaseName)
    }
}
