import db from './db';
import config   from './config.js';
const $        = require('jquery');
var Base64     = require('js-base64').Base64;
import Quiz from './quiz';
import Record from './record';
import Continue from './continue';
import Category from './category';
import LearningLog from './learning_logs';
const jsCookie  = require('js-cookie');

export default class Mypage {

    async getStudyInfo() {
	console.log("getStudyInfo1");

        const recordObj = new Record();
        const quizzObj  = new Quiz();
        const learningLog  = new LearningLog();
        const continueQuiz  = new Continue();

	console.log("recordObj ="+recordObj);
	console.log("quizzObj ="+quizzObj);
	console.log("learningLog ="+learningLog);
	console.log("continueQuiz ="+continueQuiz);

        // let totalMissCount = await recordObj.getTotalMissCount();
        // let totalTryCount = await recordObj.getTotalTryCount();
        // let totalAchievementCount = await recordObj.getTotalAchievementCount();

        let totalQuizz = await quizzObj.getTotalQuizz();
	console.log("totalQuizz ="+totalQuizz);

        let quiz_logs = await recordObj.getQuizLogs();
	console.log("quiz_logs ="+quiz_logs);
	console.log('%o',quiz_logs);

        let learning_times = await learningLog.getAllLearningLogsNotYetUpdated();
	console.log("learning_times ="+learning_times);

        learning_times = JSON.stringify(learning_times);
	console.log("learning_times ="+learning_times);

        // get list continue quiz logs 
        let quiz_continue_logs = await continueQuiz.getAllContinueQuiz();

        quiz_continue_logs = JSON.stringify(quiz_continue_logs);
	console.log("quiz_continue_logs ="+quiz_continue_logs);

	console.log("getStudyInfo2");

        let learner_settings = {
            'sound' : (localStorage.getItem("soundon") === 'true') ? 'on' : 'off'
        };

	console.log("getStudyInfo3");

        learner_settings = JSON.stringify(learner_settings);
        quiz_logs = JSON.stringify(quiz_logs);
        let id_logged = jsCookie.get('id_logged');
        if(id_logged){
            let learnerInfo = `{
                "is_my_page": 1,
                "learner_id": "${id_logged}",
                "learning_times": ${learning_times},
                "quiz_logs": ${quiz_logs},
                "learner_settings": ${learner_settings},
                "quiz_continue_logs": ${quiz_continue_logs},
                "quiz_statistic": {
                    "all_achievement_count": 0,
                    "all_miss_count": 0,
                    "all_quiz_count": ${totalQuizz},
                    "all_try_count": 0,
                    "learning_progress": 0
                },
                "start_app_count": 1
            }`;
            return Base64.encode(learnerInfo);
        }else{

	console.log("getStudyInfo4");

            return false;
        }
    }

    async getScoreInfo() {
        const quizObj         = new Quiz();
        const recordObj       = new Record();
        const categoryObj     = new Category();

        let totalQuizz      = await quizObj.getTotalQuizz(config.client_flg);
        let totalTryCount   = await recordObj.getTotalTryCount(null, config.client_flg);
        let totalMissCount  = await recordObj.getTotalMissCount(null, config.client_flg);

        let bigCategories      = await categoryObj.getCategoriesStatistic(config.client_flg);


        var totalProgress   = 0;
        var totalMiss       = 0;
        var achievement     = 0;
        if(totalTryCount > 0){
            totalProgress   = Math.round(totalTryCount * 100 / totalQuizz);
            totalMiss       = Math.round(totalMissCount * 100 / totalTryCount);
            achievement     = 100 - totalMiss;
        }
        let result = {
            'totalProgress' : totalProgress,
            'totalMiss'     : totalMiss,
            'achievement'   : achievement,
            'bigCategories' : bigCategories
        };
        return result;
    }


    /**
     * save study info for leaner
     *
     * @param is_access_answer
     * @return object
     * @author ChienNguyen
     * @updated 07.01.2019
     */
    
    saveStudyInfo(is_access_answer) {
	console.log("saveStudyInfo1");
	console.log("navigator.onLine ="+navigator.onLine);
        if(navigator.onLine){
            // when auto save then disable funct loading
            if(!is_access_answer){
                document.getElementById("loadingOverlay").style.display = 'block';
            }
	console.log("is_access_answer ="+is_access_answer);
            // check flag save studyinfo
            let is_saving_studyinfo = jsCookie.get('is_saving_studyinfo');
	console.log("is_saving_studyinfo ="+is_saving_studyinfo);
            if(typeof is_saving_studyinfo == 'undefined' || is_saving_studyinfo == (false).toString()){
                jsCookie.set('is_saving_studyinfo', true, { expires: 1 });
                try {
	console.log("is_saving_studyinfo ="+is_saving_studyinfo);
                    var studyInfo = this.getStudyInfo();
	console.log("studyInfo ="+studyInfo);
	console.log('%o', studyInfo);
                    studyInfo.then(function(content) {
	console.log("content ="+content);
                        $.ajax({
                            type: "POST",
                            url : config.url_api_mypage_report,
                            data: {'content' : content},
                            success: function(data){
                                if(!is_access_answer){
                                    alert(config.MESSAGE_SAVE_STUDY.OK);
                                }
                                jsCookie.set('is_saving_studyinfo', false, { expires: 1 });

                                // update learning logs
                                const learningLog  = new LearningLog();
                                const recordObj = new Record();
                                learningLog.updateLearningLogIsUpdated();
                                recordObj.updateQuizLogIsSubmitted();
                                document.getElementById("loadingOverlay").style.display = 'none';
                                return true;
                            },
                            error: function (xhr, status) {
	console.log("data ="+data);
	console.log("is_access_answer ="+is_access_answer);
                                if(!is_access_answer){
                                    alert(config.MESSAGE_SAVE_STUDY.NG);
                                }
                                jsCookie.set('is_saving_studyinfo', false, { expires: 1 });
                                document.getElementById("loadingOverlay").style.display = 'none';
                                return false;
                            }
                        });
                    });
                } catch (e) {
                    console.log("e =" +e);
                    jsCookie.set('is_saving_studyinfo', false, { expires: 1 });
                    document.getElementById("loadingOverlay").style.display = 'none';
                    return false;
                }
            }
            else {
                document.getElementById("loadingOverlay").style.display = 'none';
                return false;
            }
	console.log("saveStudyInfo2");
        } else {
	console.log("saveStudyInfo3");
            alert(config.NETWORK.OFFLINE_PAGE);
        }
    }
}
