<?php
class SppLearner extends AppModel {
	var $name = "SppLearner";

	function checkEmailExisted($email){
		$learner = $this->find('first',array('conditions' => array('email' => $email)));
		if(empty($learner)){
			return false;
		}
		return true;
	}

	function getListLearner($created_date_from, $created_date_to, $learner_id, $first_name, $last_name,
	$learner_email, $learner_organization_code, $learner_payment_status_id, $learner_classification_id){
		$conditions = array();
		$joins = array();
		$fields = "";
		$joins[] = array(
            'table' => 'spp_organizations',
            'alias' => 'SppOrganization',
            'type' => 'left',
            'conditions' => array('SppLearner.organization_code = CONCAT(SppOrganization.code_large,SppOrganization.code_middle,SppOrganization.code_small)')
		);
		$joins[] = array(
            'table' => 'spp_payment_statuses',
            'alias' => 'SppPaymentStatus',
            'type' => 'left',
            'conditions' => array('SppLearner.payment_status_id = SppPaymentStatus.id')
		);
		$joins[] = array(
            'table' => 'spp_learner_classifications',
            'alias' => 'SppLearnerClassification',
            'type' => 'left',
            'conditions' => array('SppLearner.learner_classification_id = SppLearnerClassification.id')
		);

		if(!empty($created_date_from)){
			//$from_datetime = DateTime::createFromFormat('Y/m/d H:i:s', $created_date_from." 00:00:00");
			$conditions[]= "SppLearner.created_datetime >= '".$created_date_from->format('Y-m-d H:i:s')."'";
		}
		if(!empty($created_date_to)){
			//$to_datetime = DateTime::createFromFormat('Y/m/d H:i:s', $created_date_to." 23:59:59");
			$conditions[]= "SppLearner.created_datetime <= '".$created_date_to->format('Y-m-d H:i:s')."'";
		}
		if(!empty($learner_id)){
			$conditions[]= "SppLearner.id LIKE '%".$learner_id."%'";
		}
		if(!empty($first_name)){
			$conditions['OR']= array("SppLearner.first_name LIKE '%".$first_name."%'", "SppLearner.first_name_kana LIKE '%".$first_name."%'" );
		}
		if(!empty($last_name)){
			$conditions['OR']= array("SppLearner.last_name LIKE '%".$last_name."%'", "SppLearner.last_name_kana LIKE '%".$last_name."%'" );
		}
		if(!empty($learner_email)){
			$conditions['SppLearner.email']= $learner_email;
		}
		if(!empty($learner_organization_code)){
			$conditions['SppLearner.organization_code']= $learner_organization_code;
		}
		if(!empty($learner_payment_status_id)){
			$conditions['SppLearner.payment_status_id']= $learner_payment_status_id;
		}
		if(!empty($learner_classification_id)){
			$conditions['SppLearner.learner_classification_id']= $learner_classification_id;
		}
		$fields = "SppLearner.id, SppLearner.created_datetime, SppLearner.first_name, SppLearner.last_name, SppLearner.first_name_kana,
				   SppLearner.last_name_kana, SppLearner.email, SppLearner.organization_code, SppOrganization.organization_name,
				   SppPaymentStatus.payment_status_name, SppLearnerClassification.classification_name";
		return array(
					'fields' => $fields,
				    'limit' => Configure::read('LEARNER.NUMBER_OF_PAGE'),
					'conditions' => $conditions,
					'joins' => $joins,
					'order' => array('SppLearner.created_datetime' =>'desc'));
	}

	function getAllForCSV(){
		$joins = array();
		$joins[] = array(
            'table' => 'spp_organizations',
            'alias' => 'SppOrganization',
            'type' => 'left',
            'conditions' => array('SppLearner.organization_code = CONCAT(SppOrganization.code_large,SppOrganization.code_middle,SppOrganization.code_small)')
		);
		$joins[] = array(
            'table' => 'spp_payment_statuses',
            'alias' => 'SppPaymentStatus',
            'type' => 'left',
            'conditions' => array('SppLearner.payment_status_id = SppPaymentStatus.id')
		);
		$joins[] = array(
            'table' => 'spp_learner_classifications',
            'alias' => 'SppLearnerClassification',
            'type' => 'left',
            'conditions' => array('SppLearner.learner_classification_id = SppLearnerClassification.id')
		);

		$fields = "SppLearner.*, SppOrganization.organization_name, SppPaymentStatus.payment_status_name, SppLearnerClassification.classification_name";
		return $this->find('all',array(
					'fields' => $fields,
					'joins' => $joins,
					'order' => array('SppLearner.created_datetime' =>'desc')));
	}

	function getListLearnerById($learner_id){
		$joins = array();
		$joins[] = array(
            'table' => 'spp_organizations',
            'alias' => 'SppOrganization',
            'type' => 'left',
            'conditions' => array('SppLearner.organization_code = CONCAT(SppOrganization.code_large,SppOrganization.code_middle,SppOrganization.code_small)')
		);
		$joins[] = array(
            'table' => 'spp_payment_statuses',
            'alias' => 'SppPaymentStatus',
            'type' => 'left',
            'conditions' => array('SppLearner.payment_status_id = SppPaymentStatus.id')
		);
		$joins[] = array(
            'table' => 'spp_learner_classifications',
            'alias' => 'SppLearnerClassification',
            'type' => 'left',
            'conditions' => array('SppLearner.learner_classification_id = SppLearnerClassification.id')
		);

		$fields = "SppLearner.*, SppOrganization.organization_name, SppPaymentStatus.payment_status_name, SppLearnerClassification.classification_name";
		return $this->find('first',array(
					'fields' => $fields,
					'conditions' => array('SppLearner.id' => $learner_id),
					'joins' => $joins));

	}

	function getLearnerWithStudyRecord($learner_id){
		$joins = array();
		$joins[] = array(
            'table' => 'spp_study_records',
            'alias' => 'SppStudyRecord',
            'type' => 'left',
            'conditions' => array('SppStudyRecord.learner_id = SppLearner.id')
		);
		$fields = "SppLearner.id, SppLearner.organization_code, SppStudyRecord.rank_id";
		return $this->find('first',array(
					'fields' => $fields,
					'conditions' => array('SppLearner.id' => $learner_id),
					'joins' => $joins));
	}
	
	function checkLicenseExpired($learner_id){
		if(!empty($learner_id)){
			// get first character in learner_id
			$payment_method = substr($learner_id,0,1);
			if($payment_method == Configure::read('PAYMENT_METHOD.STORE')){
				return false;
			}
		}
		$joins = array();
		$joins[] = array(
            'table' => 'spp_licenses',
            'alias' => 'SppLicense',
            'type' => 'left',
            'conditions' => array('SppLicense.learner_id = SppLearner.id')
		);
		$learner = $this->find('first',array('fields' => "SppLearner.organization_code, SppLicense.expired_end_date",
											 'conditions' =>array('SppLearner.id' => $learner_id),
											 'joins' => $joins));
		if(empty($learner)){
			return true;
		}
		$organization_code = $learner['SppLearner']['organization_code'];
		// no expired date if learner is not belong any orgination
		if(empty($organization_code) || $organization_code == Configure::read('PERSONAL_CODE')){
			return false;
		}
		if(!empty($learner['SppLicense']) && date('Y-m-d') <= date($learner['SppLicense']['expired_end_date'])){
			return false;
		}
		return true;
		
	}
	
	function checkLearnerIdExisted($learner_id){
		$learner = $this->findById($learner_id);
		if(!empty($learner)){
			return true;
		}
		return false;
	}
}