<?php
class  SppRankMasterController extends AppController {
	var $name = 'SppRankMaster';
	var $helpers = array('Html', 'Form', 'Session', 'Javascript');
	var $components = array('Auth', 'Session', 'Csv','RequestHandler');
	var $role_user = array();
	var $paginate = array();
	var $uses = array('SppRankMaster','SppUser');

	/**
	 * Override method
	 */
	function beforeFilter()
	{
		parent::beforeFilter();
		$this->Auth->allow('index', 'edit');
		// check session and role
		if(!$this->isSystemManagement()){
			$this->render('/elements/error');
			return;
		}
		// Load config file
		Configure::load('settings');

	}

	/**
	 * Get rank list and set to layout
	 * input : Nothing
	 * output :	ranks
	 */
	function index()
	{
		$rank_masters = $this->SppRankMaster->find('all',array('order' => 'rank_no ASC'));
		$this->set('rank_masters',$rank_masters);
	}

	function edit(){
		if(isset($this->params['url']['id'])){
			$rank_master_id = $this->params['url']['id'];
			$rank_master = $this->SppRankMaster->findById($rank_master_id);
		}
		try{
			if ($this->RequestHandler->isPost()){
				if(!empty($rank_master)){
					$is_error = false;

					/*if(!$is_error && empty($this->data['SppRankMaster']['mark'])){
						$this->Session->setFlash(Configure::read('Message.ERR_MISSING_MARK'));
						$is_error = true;
					}
					if(!$is_error && empty($this->data['SppRankMaster']['name'])){
						$this->Session->setFlash(Configure::read('Message.ERR_MISSING_RANK_NAME'));
						$is_error = true;
					}
					if(!$is_error && empty($this->data['SppRankMaster']['extend_days'])){
						// process case extend_days = 0
						if(strcmp($this->data['SppRankMaster']['extend_days'],'0') != 0){
							$this->Session->setFlash(Configure::read('Message.ERR_MISSING_EXTEND_DAYS'));
							$is_error = true;
						}
					}
					if(!$is_error && empty($this->data['SppRankMaster']['image'])){
						$rank_master['SppRankMaster']['image'] = "";
						$this->Session->setFlash(Configure::read('Message.ERR_MISSING_RANK_IMAGE'));
						$is_error = true;
					}*/
					if(empty($this->data['SppRankMaster']['image'])){
						$rank_master['SppRankMaster']['image'] = "";
					}
				//	if(!$is_error){
						if (!empty($this->data['image_upload']) &&
						is_uploaded_file($this->data['image_upload']['tmp_name'])) {
							$uploads_dir = Configure::read('IMG_RANK');
							if ( ! is_dir($uploads_dir)) {
								mkdir($uploads_dir);
							}
							$tmp_name = $this->data['image_upload']['tmp_name'];
							$fileData = file_get_contents($tmp_name);
							$extention = explode(".",$this->data['image_upload']['name']);
							$file_ext = strtolower(array_pop($extention));
							//$file_name = date('Ymdhis', time()) . '.'.$file_ext;
							// only accept jpg or png image
							if($file_ext != "jpg" && $file_ext != "png"){
								$this->Session->setFlash(Configure::read('Message.ERR_IMAGE_INVALID'));
								$is_error = true;
							} else {
								$full_path = $uploads_dir.$this->data['image_upload']['name'];
								move_uploaded_file($tmp_name, $full_path);
								$rank_master['SppRankMaster']['image'] = $full_path;
							}
								
						}
					//}
					$rank_master['SppRankMaster']['mark'] = $this->data['SppRankMaster']['mark'];
					$rank_master['SppRankMaster']['name'] = $this->data['SppRankMaster']['name'];
					$rank_master['SppRankMaster']['extend_days'] = $this->data['SppRankMaster']['extend_days'];

					if(!$is_error){
						$result = $this->SppRankMaster->save($rank_master);
						if($result){
							$this->Session->setFlash(Configure::read('Message.EDIT_SUCCESS'));
							return $this->redirect(array('action' => 'index'));
						} else {
							$this->Session->setFlash(Configure::read('Message.EDIT_ERROR'));
						}
					}

				}
			}
		} catch (Exception $e){
			$this->Session->setFlash(Configure::read('Message.ERR_EXCEPTION'));
		}
		if(!empty($rank_master)){
			$this->set('rank_master',$rank_master);
		} else {
			$this->render('/elements/error');
		}
	}

}
?>