<?php
define("LEARNER_ID", "学習者ＩＤ");
define("LEARNER_NAME", "氏名");
define("CATEGORY_NAME", "CATEGORY NAME");
define("SUBCATEGORY_NAME", "SUBCATEGORY NAME");
define("QUIZ_NO", "NO");
define("CREATED_DATE", "質問日");
define("QUESTION_CONTENT", "質問");
define("ANSWERED_PERSON", "回答者");
define("ANSWERED_DATE", "回答日");
define("MARK", "ポイント");
define("IS_PUBLIC", "公開／非公開");
class SppQuestionsController extends AppController {
	var $name = "SppQuestion";
	//	var $uses = array("SppQuiz");
	var $uses = array("SppQuestion","SppOrganization");
	var $components = array('RequestHandler','Session', 'Csv', 'Pass4v');
	var $helpers = array('Html', 'Form');
	var $paginate = array();
	function beforeFilter()
	{
		parent::beforeFilter();
		$this->Auth->allow('index','edit','exportCSV');
		// Load config file
		Configure::load('settings');

		// check session and role
		if(!$this->isSupporter()){
			$this->render('/elements/error');
			return;
		}
	}
	function beforeRender() {
		parent::beforeRender();
	}

	function index(){
		$created_date_from = "";
		$created_date_to = "";
		$learner_id = "";
		$first_name = "";
		$last_name = "";
		$include_answered = false;
		$organizationCode = "";
		$currentUser = $this->Auth->user();
		if ($this->RequestHandler->isPost()){
			$this->Session->delete('Search.searchkey');
			$search_key = array();
			if(!empty($this->data['SppQuestion']['created_date_from'])){
				$created_date_from = DateTime::createFromFormat('Y/m/d H:i:s', $this->data['SppQuestion']['created_date_from']." 00:00:00");
				$search_key['SppQuestion']['created_date_from'] = $created_date_from;
			}
			if(!empty($this->data['SppQuestion']['created_date_to'])){
				$created_date_to = DateTime::createFromFormat('Y/m/d H:i:s', $this->data['SppQuestion']['created_date_to']." 23:59:59");
				$search_key['SppQuestion']['created_date_to'] = $created_date_to;
			}
			if(!empty($this->data['SppQuestion']['learner_id'])){
				$learner_id = $this->data['SppQuestion']['learner_id'];
				$search_key['SppQuestion']['learner_id'] = $learner_id;
			}
			if(!empty($this->data['SppQuestion']['first_name'])){
				$first_name = $this->data['SppQuestion']['first_name'];
				$search_key['SppQuestion']['first_name'] = $first_name;
			}
			if(!empty($this->data['SppQuestion']['last_name'])){
				$last_name = $this->data['SppQuestion']['last_name'];
				$search_key['SppQuestion']['last_name'] = $last_name;
			}
			
			if(!empty($this->data['organization_code']) && $this->data['organization_code'] != "-1"){
				$organizationCode = $this->data['organization_code'];
				$search_key['SppQuestion']['organization_code'] = $organizationCode;
			}

			if(isset($this->data['submit_search'])){
				$include_answered = true;
			} else {
				if(isset($this->data['submit_csv_output'])){
					$this->exportCSV($_POST['encode']);
				}
			}
			$search_key['SppQuestion']['include_answered'] = $include_answered;
			$this->Session->write('Search.searchkey', $search_key);

		} else {
			$search_key = $this->Session->read('Search.searchkey');
			if(!empty($search_key)){
				if(!empty($search_key['SppQuestion']['created_date_from'])){
					$created_date_from = $search_key['SppQuestion']['created_date_from'];
				}
				
				if(!empty($search_key['SppQuestion']['created_date_to'])){
					$created_date_to = $search_key['SppQuestion']['created_date_to'];
				}
				
				if(!empty($search_key['SppQuestion']['learner_id'])){
					$learner_id = $search_key['SppQuestion']['learner_id'];
				}
				
				if(!empty($search_key['SppQuestion']['first_name'])){
					$first_name = $search_key['SppQuestion']['first_name'];
				}
				
				if(!empty($search_key['SppQuestion']['last_name'])){
					$last_name = $search_key['SppQuestion']['last_name'];
				}
				
				if(!empty($search_key['SppQuestion']['include_corrected'])){
					$include_answered = $search_key['SppQuestion']['include_answered'];
				}
				
				if(!empty($search_key['SppQuestion']['organization_code'])){
					$organizationCode = $search_key['SppQuestion']['organization_code'];
				}
			}
		}

		$this->paginate = $this->SppQuestion->getListQuestions($include_answered,$created_date_from, $created_date_to, $learner_id, $first_name, $last_name, $organizationCode);
		$questions = $this->paginate('SppQuestion', 2);
		$this->set('questions', $questions);
		$this->set('created_date_from', empty($created_date_from)? '':$created_date_from->format('Y/m/d'));
		$this->set('created_date_to', empty($created_date_to)?'':$created_date_to->format('Y/m/d'));
		$this->set('learner_id', $learner_id);
		$this->set('first_name', $first_name);
		$this->set('last_name', $last_name);
		if($this->isSystemManagement()){
			$this->set('is_sys_admin', true);
		}else{
			$organizations = $this->SppOrganization->getOrgCodeForAchivementUser($currentUser['SppUser']['id']);
			$this->set('organizations', $organizations);
			$this->set('organization_code', $organizationCode);
			$this->set('is_sys_admin', false);
		}

	}

	function edit(){
		if ($this->RequestHandler->isPost()){
			$question_id = $this->data['SppQuestion']['id'];
			$question = $this->SppQuestion->getQuestionById($question_id);
			if(!empty($question)){
				$is_error = false;
				if(strcmp($question['SppQuestion']['answered_content'],$this->data['SppQuestion']['answered_content']) != 0){
					$question['SppQuestion']['answered_datetime'] = date('Y-m-d H:i:s');
				}
				if(!$is_error && empty($this->data['SppQuestion']['answered_person'])){
					$this->Session->setFlash(Configure::read('Message.ERR_MISSING_ANSWERED_PERSON'));
					$is_error = true;
				}
				if(!$is_error && empty($this->data['SppQuestion']['answered_content'])){
					$this->Session->setFlash(Configure::read('Message.ERR_MISSING_ANSWERED_CONTENT'));
					$is_error = true;
				}
				if(!$is_error && empty($this->data['SppQuestion']['mark'])){
					// process case mark = 0
					if(strcmp($this->data['SppQuestion']['mark'],'0') != 0){
						$this->Session->setFlash(Configure::read('Message.ERR_MISSING_MARK'));
						$is_error = true;
					}
				}
				$question['SppQuestion']['answered_person'] = $this->data['SppQuestion']['answered_person'];
				$question['SppQuestion']['answered_content'] = $this->data['SppQuestion']['answered_content'];
				$question['SppQuestion']['mark'] = $this->data['SppQuestion']['mark'];
				if(isset($this->data['SppQuestion']['is_public'])){
					$question['SppQuestion']['is_public'] = $this->data['SppQuestion']['is_public'];
				}

				if(!$is_error){
					$result = $this->SppQuestion->save($question,array('conditions'=>array('SppQuestion.id' => $question_id)));
					if($result){
						$this->Session->setFlash(Configure::read('Message.EDIT_SUCCESS'));
						return $this->redirect(array('action' => 'index'));
					} else {
						$this->Session->setFlash(Configure::read('Message.EDIT_ERROR'));
					}
				}
				$this->set('question',$question);
			}
		} else {
			if(isset($this->params['url']['id'])){
				$question_id = $this->params['url']['id'];
				$question = $this->SppQuestion->getQuestionById($question_id);
				if(empty($question)){
					$this->render('/elements/error');
				}
				$this->set('question',$question);
			} else {
				$this->render('/elements/error');
			}
		}
	}

	function exportCSV($encode){
		$this->layout = false;
		$include_answered = $this->Session->read('include_answered');
		$questions = $this->SppQuestion->getAllForCSV();
		$array = array();
		//edit array
		if(!empty($questions)){
			foreach ($questions as $question) {
				$temp = array(
				$question['SppQuestion']['learner_id'],
				$question['SppLearner']['first_name'].' '.$question['SppLearner']['last_name'],
				$question['SppQuestion']['category_name'],
				$question['SppQuestion']['subcategory_name'],
				$question['SppQuestion']['quiz_no'],
				(!empty($question['SppQuestion']['created_datetime'])) ? date('Y/m/d', strtotime($question['SppQuestion']['created_datetime'])) : '',
				$question['SppQuestion']['question_content'],
				$question['SppQuestion']['answered_person'],
				(!empty($question['SppQuestion']['answered_datetime'])) ? date('Y/m/d', strtotime($question['SppQuestion']['answered_datetime'])) : '',
				$question['SppQuestion']['mark'],
				$question['SppQuestion']['is_public'] ? '公開' : '非公開'
				);
				array_push($array, $temp);
			}
		}
		$header = array(LEARNER_ID, LEARNER_NAME, CATEGORY_NAME, SUBCATEGORY_NAME, QUIZ_NO,
		CREATED_DATE, QUESTION_CONTENT, ANSWERED_PERSON, ANSWERED_DATE, MARK, IS_PUBLIC);
		$fileName = '質問'.date('Ymdhms');
		$this->Csv->export($encode, $array, $header, $fileName . '.csv');
	}
}