<?php
/**
 * @copyright     2012.
 * @package       
 * @since         2012-10-27
 * We use CakePHP(tm) ver 1.3.7
 */

class  SppDownloadController extends AppController {
	
	var $name = "SppDownload";
	var $uses = array('DlTotal');
	var $components = array('Auth','Csv');
	
	function beforeFilter() {
		parent::beforeFilter();
		$this->Auth->allow('index','csvExport');
		// check session and role
		if(!$this->isSystemManagement()){
			$this->render('/elements/error');
			return;
		}
		// Load config file
		Configure::load('settings');
	}
	
	function index() {

		$thismonday = date("Y-m-d 0:0:0",strtotime('This Week', time())); 
		$thissunday = date("Y-m-d 0:0:0",strtotime('This Sunday', time()));	
		$lastMonday = date("Y-m-d 0:0:0",strtotime('Monday this week', time())- 7*24*60*60);		
		$lastSunday = date("Y-m-d 23:59:59",strtotime('This Sunday', time())- 7*24*60*60);
		$last7days = date("Y-m-d 0:0:0",strtotime('-7 days', time()));
		
		$firstDate = date("Y-m-d 0:0:0",mktime(0, 0, 0, date("m"), 1, date("Y")));
		$currentDate = date("Y-m-d H:i:s");
		$currentDateNight = date("Y-m-d 0:0:0");
		
		$yesterday = date("Y-m-d 0:0:0",strtotime('yesterday', time()));
		$yesterday2 = date("Y-m-d 23:59:59",strtotime('yesterday', time()));
		
		
		$lastDateOfLastMoth = date("Y-m-d 0:0:0",strtotime('last day of last month', time()));
		$firstDateOfLastMoth = date("Y-m-d 0:0:0",strtotime('first day of last month', time()));
		$last30days = date("Y-m-d 0:0:0",strtotime('-30 days', time()));
		
		$statisticsArr = array();
		
		//Search
		if(!empty($this->data)){
			$form = $this->data;
			$startDate = new DateTime($form['DlTotal']['search_start_date'] .' 0:0:0');
			$startDate = date_format($startDate, 'Y-m-d H:i:s');
			
			$endDate = new DateTime($form['DlTotal']['search_end_date'].' 23:59:59');
			$endDate = date_format($endDate, 'Y-m-d H:i:s');
			
			$totals = $this->DlTotal->find('all', array('conditions'=> $this->_conditionGeneration($startDate, 
																							  $endDate, null),
															'fields'=>array('DlTotal.contents'),
															'group'=>'DlTotal.contents'));
			$result = array();
			foreach ($totals as $key => $value){
				
				//For iPhone
				$conditions = array('DlTotal.contents'=>$value['DlTotal']['contents'],
									'DlTotal.date >=' => strtotime($startDate),
									'DlTotal.date <=' => strtotime($endDate),
									'DlTotal.device'=> 1);
				$iphoneNo = $this->DlTotal->find('count', array('conditions'=> $conditions,
																'order'=>'DlTotal.date DESC'));
				$totals[$key]['DlTotal']['iphone'] = $iphoneNo;
				
				//For Android
				$conditions = array('DlTotal.contents'=>$value['DlTotal']['contents'],
									'DlTotal.date >=' => strtotime($startDate),
									'DlTotal.date <=' => strtotime($endDate),
									'DlTotal.device'=> 2);
				$androidNo = $this->DlTotal->find('count', array('conditions'=> $conditions,
																 'order'=>'DlTotal.date DESC'));
				$totals[$key]['DlTotal']['android'] = $androidNo;
			}
			$this->set('totals',$totals);
			$this->set('startDate',$form['DlTotal']['search_start_date']);
			$this->set('endDate',$form['DlTotal']['search_end_date']);												  
		}
		//
		//Monthly statistics
		//
		////////This month//////
		
		//-iPhone
		$number = $this->DlTotal->find('count',array('conditions'=>$this->_conditionGeneration($firstDate, 
																							  $currentDate, 1)));
		$statisticsArr['thismonth']['iphone'] =  $number;
		//-Android
		$number = $this->DlTotal->find('count',array('conditions'=>$this->_conditionGeneration($firstDate, 
																							   $currentDate, 2)));
		$statisticsArr['thismonth']['android'] =  $number;
		
		////////last month//////
		//-iPhone
		$number = $this->DlTotal->find('count',array('conditions'=>$this->_conditionGeneration($firstDateOfLastMoth, 
																							   $lastDateOfLastMoth, 
																							   1)));
		$statisticsArr['lastmonth']['iphone'] =  $number;
		
		//-Android
		$number = $this->DlTotal->find('count',array('conditions'=>$this->_conditionGeneration($firstDateOfLastMoth, 
																							   $lastDateOfLastMoth, 
																							   2)));
		$statisticsArr['lastmonth']['android'] =  $number;
		
		////////last 30 days//////
		//-iPhone
		$number = $this->DlTotal->find('count',array('conditions'=>$this->_conditionGeneration($last30days, 
																							   $yesterday2, 
																							   1)));
		$statisticsArr['last30days']['iphone'] =  $number;
		
		//-Android
		$number = $this->DlTotal->find('count',array('conditions'=>$this->_conditionGeneration($last30days, 
																							   $yesterday2, 
																							   2)));
		$statisticsArr['last30days']['android'] =  $number;
		
		//
		//Weekly statistics
		//
		
		//This week
		//-iPhone		
		$number = $this->DlTotal->find('count',array('conditions'=>$this->_conditionGeneration($thismonday, 
																							   $thissunday, 
																							   1)));
		$statisticsArr['thisweek']['iphone'] =  $number;
		
		//-Android
		$number = $this->DlTotal->find('count',array('conditions'=>$this->_conditionGeneration($thismonday, 
																							   $thissunday, 
																							   2)));
		$statisticsArr['thisweek']['android'] =  $number;

		//Last week
		//-iPhone
		$number = $this->DlTotal->find('count',array('conditions'=>$this->_conditionGeneration($lastMonday, 
																							   $lastSunday, 
																							   1)));
		$statisticsArr['lastweek']['iphone'] =  $number;
		
		//-Android
		$number = $this->DlTotal->find('count',array('conditions'=>$this->_conditionGeneration($lastMonday, 
																							   $lastSunday, 
																							   2)));
		$statisticsArr['lastweek']['android'] =  $number;
		
		//Last 7 days
		//-iPhone
		$number = $this->DlTotal->find('count',array('conditions'=>$this->_conditionGeneration($last7days, 
																							   $yesterday2, 
																							   1)));
		$statisticsArr['last7days']['iphone'] =  $number;
		
		//-Android
		$number = $this->DlTotal->find('count',array('conditions'=>$this->_conditionGeneration($last7days, 
																							   $yesterday2, 
																							   2)));
		$statisticsArr['last7days']['android'] =  $number;
		
		
		//Yesterday
		//-iPhone
		$number = $this->DlTotal->find('count',array('conditions'=>$this->_conditionGeneration($yesterday, 
																							   $currentDateNight, 
																							   1)));
		$statisticsArr['yesterday']['iphone'] =  $number;
		
		//-Android
		$number = $this->DlTotal->find('count',array('conditions'=>$this->_conditionGeneration($yesterday, 
																							   $currentDateNight, 
																							   2)));
		$statisticsArr['yesterday']['android'] =  $number;
		
		$this->set('statisticsArr',$statisticsArr);
		
	}
	
	function _conditionGeneration($fromDate, $toDate, $device){
		if($device != null){
			$conditions = array('DlTotal.date >=' => strtotime($fromDate),'DlTotal.date <='=>strtotime($toDate),
							     'DlTotal.device'=> $device);	
		} else {
			$conditions = array('DlTotal.date >= ? and DlTotal.date <= ?' => array(strtotime($fromDate),strtotime($toDate)));	
		}
		return $conditions;
	}
	
	function csvExport(){
		$this->layout = false;
		$encode = 'UTF-8';
		$data = $this->_getCSVData();
		$array = array();
		
		//edit array
		foreach ($data as $detail) {
			$newDetail = array(
				$detail['DlTotal']['contents'], 
				$detail['DlTotal']['iphone'], 
				$detail['DlTotal']['android'],
			);
			array_push($array, $newDetail);
		}
		
		$header = array('Content Name','iPhone','Android');
		$fileName = 'Download_Statistics_'.strtotime(date('Ymdhms'));
		$this->Csv->export($encode, $array, $header, $fileName.'.csv');
	}
/*
			$totals = $this->DlTotal->find('all', array('conditions'=> $this->_conditionGeneration($startDate, 
																							  $endDate, null),
															'fields'=>array('DlTotal.contents'),
															'group'=>'DlTotal.contents'));
			$result = array();
			foreach ($totals as $key => $value){
				
				//For iPhone
				$conditions = array('DlTotal.contents'=>$value['DlTotal']['contents'],
									'DlTotal.date >=' => strtotime($startDate),
									'DlTotal.date <=' => strtotime($endDate),
									'DlTotal.device'=> 1);
				$iphoneNo = $this->DlTotal->find('count', array('conditions'=> $conditions,
																'order'=>'DlTotal.date DESC'));
				$totals[$key]['DlTotal']['iphone'] = $iphoneNo;
				
				//For Android
				$conditions = array('DlTotal.contents'=>$value['DlTotal']['contents'],
									'DlTotal.date >=' => strtotime($startDate),
									'DlTotal.date <=' => strtotime($endDate),
									'DlTotal.device'=> 2);
				$androidNo = $this->DlTotal->find('count', array('conditions'=> $conditions,
																 'order'=>'DlTotal.date DESC'));
				$totals[$key]['DlTotal']['android'] = $androidNo;
			}
*/	
	function _getCSVData(){
		$form = $this->data;
		$startDate = $form['DlTotal']['startDate']." 0:0:0";
		$endDate = $form['DlTotal']['endDate']." 23:59:59";
			$startDate = new DateTime($startDate);
			$startDate = date_format($startDate, 'Y-m-d H:i:s');
			
			$endDate = new DateTime($endDate);
			$endDate = date_format($endDate, 'Y-m-d H:i:s');
			
		$totals = $this->DlTotal->find('all', array('conditions'=> $this->_conditionGeneration($startDate, 
																							  $endDate, null),
															'fields'=>array('DlTotal.contents'),
															'group'=>'DlTotal.contents'));
		$result = array();
		foreach ($totals as $key => $value){
			//For iPhone
			$conditions = array('DlTotal.contents'=>$value['DlTotal']['contents'],
									'DlTotal.date >=' => strtotime($startDate),
									'DlTotal.date <=' => strtotime($endDate),
								'DlTotal.device'=> 1);
			$iphoneNo = $this->DlTotal->find('count', array('conditions'=> $conditions,
																 'order'=>'DlTotal.date DESC'));
			$totals[$key]['DlTotal']['iphone'] = $iphoneNo;
			
			//For Android
			$conditions = array('DlTotal.contents'=>$value['DlTotal']['contents'],
									'DlTotal.date >=' => strtotime($startDate),
									'DlTotal.date <=' => strtotime($endDate),
								'DlTotal.device'=> 2);
			$androidNo = $this->DlTotal->find('count', array('conditions'=> $conditions,
																 'order'=>'DlTotal.date DESC'));
			$totals[$key]['DlTotal']['android'] = $androidNo;
		}

		return $totals;
	}
}