<?php
define("LEARNER_ID", "学習者ID");
define("LEARNER_NAME", "氏名");
define("CREATED_DATE", "提出日");
define("TITLE", "タイトル");
define("CORRECTION_PERSON", "添削者");
define("CORRECTION_DATE", "添削日");
define("CORRECTION_COMMENT", "添削コメント");
define("CORRECTION_MARK", "ポイント");
define("UPDATE_DATE", "更新日");

class SppCorrectionsController extends AppController {
	var $name = "SppCorrection";
	var $components = array('RequestHandler','Session', 'Csv', 'Pass4v');
	var $uses = array("SppCorrection","SppOrganization");
	var $helpers = array('Html', 'Form');
	var $paginate = array();
	function beforeFilter()
	{
		parent::beforeFilter();
		$this->Auth->allow('index','edit','exportCSV','downloadImage');
		// Load config file
		Configure::load('settings');

		// check session and role
		if(!$this->isSupporter()){
			$this->render('/elements/error');
			return;
		}
	}
	function beforeRender() {
		parent::beforeRender();
	}

	function index(){
		$created_date_from = "";
		$created_date_to = "";
		$learner_id = "";
		$first_name = "";
		$last_name = "";
		$include_corrected = false;
		$organizationCode = "";
		$currentUser = $this->Auth->user();
		if ($this->RequestHandler->isPost()){
			$this->Session->delete('Search.searchkey');
			$search_key = array();
			if(!empty($this->data['SppCorrection']['created_date_from'])){
				$created_date_from = DateTime::createFromFormat('Y/m/d H:i:s', $this->data['SppCorrection']['created_date_from']." 00:00:00");
				$search_key['SppCorrection']['created_date_from'] = $created_date_from;
			}
			if(!empty($this->data['SppCorrection']['created_date_to'])){
				$created_date_to = DateTime::createFromFormat('Y/m/d H:i:s', $this->data['SppCorrection']['created_date_to']." 23:59:59");
				$search_key['SppCorrection']['created_date_to'] = $created_date_to;
			}
			if(!empty($this->data['SppCorrection']['learner_id'])){
				$learner_id = $this->data['SppCorrection']['learner_id'];
				$search_key['SppCorrection']['learner_id'] = $learner_id;
			}
			if(!empty($this->data['SppCorrection']['first_name'])){
				$first_name = $this->data['SppCorrection']['first_name'];
				$search_key['SppCorrection']['first_name'] = $first_name;
			}
			if(!empty($this->data['SppCorrection']['last_name'])){
				$last_name = $this->data['SppCorrection']['last_name'];
				$search_key['SppCorrection']['last_name'] = $last_name;
			}
			if(!empty($this->data['organization_code']) && $this->data['organization_code'] != "-1"){
				$organizationCode = $this->data['organization_code'];
				$search_key['SppCorrection']['organization_code'] = $organizationCode;
			}
			if(isset($this->data['submit_search'])){
				$include_corrected = true;
			} else {
				if(isset($this->data['submit_csv_output'])){
					$this->exportCSV($_POST['encode']);
				}
			}
			$search_key['SppCorrection']['include_corrected'] = $include_corrected;
			$this->Session->write('Search.searchkey', $search_key);

		} else {
			$search_key = $this->Session->read('Search.searchkey');
			if(!empty($search_key)){
				if(!empty($search_key['SppCorrection']['created_date_from'])){
					$created_date_from = $search_key['SppCorrection']['created_date_from'];
				}

				if(!empty($search_key['SppCorrection']['created_date_to'])){
					$created_date_to = $search_key['SppCorrection']['created_date_to'];
				}

				if(!empty($search_key['SppCorrection']['learner_id'])){
					$learner_id = $search_key['SppCorrection']['learner_id'];
				}

				if(!empty($search_key['SppCorrection']['first_name'])){
					$first_name = $search_key['SppCorrection']['first_name'];
				}

				if(!empty($search_key['SppCorrection']['last_name'])){
					$last_name = $search_key['SppCorrection']['last_name'];
				}

				if(!empty($search_key['SppCorrection']['include_corrected'])){
					$include_corrected = $search_key['SppCorrection']['include_corrected'];
				}
				
				if(!empty($search_key['SppCorrection']['organization_code'])){
					$organizationCode = $search_key['SppCorrection']['organization_code'];
				}
				
			}
		}

		$this->paginate = $this->SppCorrection->getListCorrection($include_corrected, $created_date_from,
		$created_date_to, $learner_id, $first_name, $last_name, $organizationCode);
		$corrections = $this->paginate('SppCorrection', 2);
		$this->set('corrections', $corrections);
		$this->set('created_date_from', empty($created_date_from)? '':$created_date_from->format('Y/m/d'));
		$this->set('created_date_to', empty($created_date_to)?'':$created_date_to->format('Y/m/d'));
		$this->set('learner_id', $learner_id);
		$this->set('first_name', $first_name);
		$this->set('last_name', $last_name);
		if($this->isSystemManagement()){
			$this->set('is_sys_admin', true);
		}else{
			$organizations = $this->SppOrganization->getOrgCodeForAchivementUser($currentUser['SppUser']['id']);
			$this->set('organizations', $organizations);
			$this->set('organization_code', $organizationCode);
			$this->set('is_sys_admin', false);
		}

	}

	function edit(){
		if ($this->RequestHandler->isPost()){
			try{
				$correction_id = $this->data['SppCorrection']['id'];
				$correction = $this->SppCorrection->getCorrectionById($correction_id);
				// download 提出画像  (image_link_1)
				if(isset($this->data['submit_download_image'])){
					$filename = $this->data['SppCorrection']['image_submit'];
					$this->set('correction',$correction);
					return $this->downloadImage($filename);
				}
				if(!empty($correction)){
					$is_error = false;

					if(!$is_error && empty($this->data['SppCorrection']['correction_person'])){
						$this->Session->setFlash(Configure::read('Message.ERR_MISSING_CORRECTION_PERSON'));
						$is_error = true;
					}
					if(!$is_error && empty($this->data['SppCorrection']['correction_comment'])){
						$this->Session->setFlash(Configure::read('Message.ERR_MISSING_CORRECTION_COMMENT'));
						$is_error = true;
					}
					if(!$is_error && empty($this->data['SppCorrection']['mark'])){
						// process case mark = 0
						if(strcmp($this->data['SppCorrection']['mark'],'0') != 0){
							$this->Session->setFlash(Configure::read('Message.ERR_MISSING_MARK'));
							$is_error = true;
						}
					}

					if(!$is_error){
						if (!empty($this->data['image_upload']) &&
						is_uploaded_file($this->data['image_upload']['tmp_name'])) {
							$uploads_dir = Configure::read('IMG_CORRECTION');
							if ( ! is_dir($uploads_dir)) {
								mkdir($uploads_dir);
							}
							$tmp_name = $this->data['image_upload']['tmp_name'];
							$fileData = file_get_contents($tmp_name);
							$extention = explode(".",$this->data['image_upload']['name']);
							$file_ext = strtolower(array_pop($extention));
							$current_time = date('Ymdhis', time());
							$file_name =  $current_time. '.'.$file_ext;
							$full_path = $uploads_dir.$file_name;
							move_uploaded_file($tmp_name, $full_path);
							$is_convert = false;
							if ($file_ext == 'jpeg') {
								$is_convert = true;
								$image = imagecreatefromjpeg($full_path);
							} else
							if ($file_ext == 'png') {
								$is_convert = true;
								$image = imagecreatefrompng($full_path);
							}
							//convert png||jpeg -> jpg
							if($is_convert){
								$bg = imagecreatetruecolor(imagesx($image), imagesy($image));
								imagefill($bg, 0, 0, imagecolorallocate($bg, 255, 255, 255));
								imagealphablending($bg, TRUE);
								imagecopy($bg, $image, 0, 0, 0, 0, imagesx($image), imagesy($image));
								unlink($full_path);
								$file_name =  $current_time.'.jpg';
								$full_path = $uploads_dir.$file_name;
								imagejpeg($bg, $full_path, 100);
								imagedestroy($bg);
							}
							// resize image width to 760px
							list($orig_width, $orig_height) = getimagesize($full_path);
							$default_img_width = Configure::read('CORRECTION.IMAGE_WIDTH');
							$this->SppCorrection->resizeImage($full_path, $default_img_width,$orig_height*$default_img_width/$orig_width);
							$correction['SppCorrection']['image_answer'] = $full_path;
						} else {
							if(empty($correction['SppCorrection']['image_answer'])){
								$this->Session->setFlash(Configure::read('Message.ERR_MISSING_CORRECTION_IMAGE'));
								$is_error = true;
							}
						}
					}

					$correction['SppCorrection']['correction_person'] = $this->data['SppCorrection']['correction_person'];
					$correction['SppCorrection']['correction_comment'] = $this->data['SppCorrection']['correction_comment'];
					$correction['SppCorrection']['mark'] = $this->data['SppCorrection']['mark'];

					if(!$is_error){
						$correction['SppCorrection']['correction_datetime'] = date('Y-m-d H:i:s');
						$correction['SppCorrection']['updated_datetime'] = date('Y-m-d H:i:s');
						$result = $this->SppCorrection->save($correction);
						if($result){
							$this->Session->setFlash(Configure::read('Message.EDIT_SUCCESS'));
							return $this->redirect(array('action' => 'index'));
						} else {
							$this->Session->setFlash(Configure::read('Message.EDIT_ERROR'));
						}
					}
					$this->set('correction',$correction);
				}
			}catch (Exception $e){
				$this->Session->setFlash(Configure::read('Message.ERR_EXCEPTION'));
			}
		} else {
			if(isset($this->params['url']['id'])){
				$correction_id = $this->params['url']['id'];
				$correction = $this->SppCorrection->getCorrectionById($correction_id);
				//die(var_dump('<pre>',$correction));
				if(empty($correction)){
					$this->render('/elements/error');
				}
				$this->set('correction',$correction);
			} else {
				$this->render('/elements/error');
			}
		}
	}

	function exportCSV($encode){
		$this->layout = false;
		$corrections = $this->SppCorrection->getAllForCSV();
		$array = array();
		//edit array
		if(!empty($corrections)){
			foreach ($corrections as $correction) {
				$temp = array(
				$correction['SppCorrection']['learner_id'],
				$correction['SppLearner']['first_name'].' '.$correction['SppLearner']['last_name'],
				(!empty($correction['SppCorrection']['created_datetime'])) ? date('Y/m/d', strtotime($correction['SppCorrection']['created_datetime'])) : '',
				$correction['SppCorrection']['category_name'].' '.$correction['SppCorrection']['subcategory_name'].' '.$correction['SppCorrection']['quiz_no'],
				$correction['SppCorrection']['correction_person'],
				(!empty($correction['SppCorrection']['correction_datetime'])) ? date('Y/m/d', strtotime($correction['SppCorrection']['correction_datetime'])) : '',
				$correction['SppCorrection']['correction_comment'],
				$correction['SppCorrection']['mark'],
				(!empty($correction['SppCorrection']['updated_datetime'])) ? date('Y/m/d', strtotime($correction['SppCorrection']['updated_datetime'])) : '');
				array_push($array, $temp);
			}
		}
		$header = array(LEARNER_ID, LEARNER_NAME, CREATED_DATE, TITLE, CORRECTION_PERSON,
		CORRECTION_DATE, CORRECTION_COMMENT, CORRECTION_MARK, UPDATE_DATE);
		$fileName = '添削'.date('Ymdhms');
		$this->Csv->export($encode, $array, $header, $fileName . '.csv');
	}

	public function downloadImage($filename) {
		$filename = WWW_ROOT.DS.$filename;
		if (file_exists($filename)) {
			header("Pragma: public");
			header("Expires: 0");
			header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
			header("Cache-Control: private", false);
			header("Content-Type: image/png");
			header("Content-Type: image/gif");
			header("Content-Type: image/jpg");
			header("Content-Description: File Transfer");
			header("Content-Disposition: attachment; filename=" . basename($filename) . ";");
			header("Content-Transfer-Encoding: binary");
			header("Content-Length: " . filesize($filename));
			readfile($filename);
			exit(0);
		}
	}
}