<?php
/**
 * @copyright     2011 (c) SPP3.
 * @package       
 * @since         2011-12-12
 * We use CakePHP(tm) ver 1.3.7
 */

class  SppBatchController extends AppController {
	var $name = "SppBatch";
	var $uses = array(
		'SppStudyRecord', 
		'SppLastWeekLearningRecord',
		'SppLicense',
		'SppLearner'
	);
	
	var $helpers = array('Html', 'Form', 'Session');
	var $components = array('Auth', 'Session','Pass4v','Email');
	
	public $autoLayout = false;
	public $autoRender = false;
	
	function beforeFilter() {
		parent::beforeFilter();
		$this->Auth->allow(
			'index','sendRemainingNotiMail'
		);
		// Load config file
		Configure::load('settings');
	}
	/**
	 * 
	 * copy data into SppLastWeekLearningRecord table on last week
	 * @author haitlt
	 * @param
	 * @created 2015/05/15 
	 */
	function index() {
		
		try{
			//get data from SppStudyRecord
			$study_records = $this->SppStudyRecord->find('all',array('conditions' =>array('invalid_flg' => 0)));
			$this->SppLastWeekLearningRecord->begin();
			foreach ($study_records as $study_record){
				$this->saveLastweekStudyRecord($study_record);
			}
			$this->SppLastWeekLearningRecord->commit();
			echo('run batch success');
		}catch (Exception $e) {
			// Rollback transaction
			$this->SppLastWeekLearningRecord->rollback();
			$this->set('cleared', 1);
			$this->set('errors', array(Configure::read('Message.ERR_EXCEPTION')));
		}
	}
	
	private function saveLastweekStudyRecord($study_record){
			
			$conditions = array("SppLastWeekLearningRecord.learner_id"=> $study_record['SppStudyRecord']['learner_id']);
			$lasweek_study_record = $this->SppLastWeekLearningRecord->find('first',array(
																'conditions'=> $conditions));
			if(!empty($lasweek_study_record)){
				$lasweek_study_record['SppLastWeekLearningRecord']['learning_days'] = $study_record['SppStudyRecord']['learning_days'];
				$lasweek_study_record['SppLastWeekLearningRecord']['learning_time_seconds'] = $study_record['SppStudyRecord']['learning_time_seconds'];
				$lasweek_study_record['SppLastWeekLearningRecord']['learning_hours'] = $study_record['SppStudyRecord']['learning_hours'];
				$lasweek_study_record['SppLastWeekLearningRecord']['learning_average_minutes'] = $study_record['SppStudyRecord']['learning_average_minutes'];
				$lasweek_study_record['SppLastWeekLearningRecord']['learning_progress'] = $study_record['SppStudyRecord']['learning_progress'];
				$lasweek_study_record['SppLastWeekLearningRecord']['quiz_progress'] = $study_record['SppStudyRecord']['quiz_progress'];
				$lasweek_study_record['SppLastWeekLearningRecord']['correct_rate'] = $study_record['SppStudyRecord']['correct_rate'];
				$lasweek_study_record['SppLastWeekLearningRecord']['rank_id'] = $study_record['SppStudyRecord']['rank_id'];
				$lasweek_study_record['SppLastWeekLearningRecord']['mark'] = $study_record['SppStudyRecord']['mark'] + $study_record['SppStudyRecord']['point_update'];
				$lasweek_study_record['SppLastWeekLearningRecord']['start_app_count'] = $study_record['SppStudyRecord']['start_app_count'];
				$lasweek_study_record['SppLastWeekLearningRecord']['update_date'] = date('Y-m-d');
				
				$this->SppLastWeekLearningRecord->save($lasweek_study_record);
			}else{
				$this->SppLastWeekLearningRecord->create();
				$this->data['SppLastWeekLearningRecord']['learner_id'] = $study_record['SppStudyRecord']['learner_id'];
				$this->data['SppLastWeekLearningRecord']['learning_days'] = $study_record['SppStudyRecord']['learning_days'];
				$this->data['SppLastWeekLearningRecord']['learning_time_seconds'] = $study_record['SppStudyRecord']['learning_time_seconds'];
				$this->data['SppLastWeekLearningRecord']['learning_hours'] = $study_record['SppStudyRecord']['learning_hours'];
				$this->data['SppLastWeekLearningRecord']['learning_average_minutes'] = $study_record['SppStudyRecord']['learning_average_minutes'];
				$this->data['SppLastWeekLearningRecord']['learning_progress'] = $study_record['SppStudyRecord']['learning_progress'];
				$this->data['SppLastWeekLearningRecord']['quiz_progress'] = $study_record['SppStudyRecord']['quiz_progress'];
				$this->data['SppLastWeekLearningRecord']['correct_rate'] = $study_record['SppStudyRecord']['correct_rate'];
				$this->data['SppLastWeekLearningRecord']['rank_id'] = $study_record['SppStudyRecord']['rank_id'];
				$this->data['SppLastWeekLearningRecord']['mark'] = $study_record['SppStudyRecord']['mark'] + $study_record['SppStudyRecord']['point_update'];
				$this->data['SppLastWeekLearningRecord']['start_app_count'] = $study_record['SppStudyRecord']['start_app_count'];
				$this->data['SppLastWeekLearningRecord']['update_date'] = date('Y-m-d');
				
				$this->SppLastWeekLearningRecord->set($this->data);
				$this->SppLastWeekLearningRecord->save();
			}
	}
	
	function sendRemainingNotiMail(){
		$remainingDay1 = Configure::read('REMAINING_DAY_MAIL.REMAINING_DAYS1');
		$remainingDay2 = Configure::read('REMAINING_DAY_MAIL.REMAINING_DAYS2');
		$remainingDay3 = Configure::read('REMAINING_DAY_MAIL.REMAINING_DAYS3');
		$learners = $this->SppLearner->find("all");
		$mailTitle = Configure::read('REMAINING_DAY_MAIL.TITLE');
		$mailApliTitle = Configure::read('REMAINING_DAY_MAIL.APLI_TITLE');
		foreach ($learners as $learner){
			$remainingDay = $this->SppLicense->getRemainingDays($learner['SppLearner']['id']);
			$learnerName = $learner['SppLearner']['first_name']. ' ' .$learner['SppLearner']['last_name']; 
			$sendMail = false;
			if($remainingDay == $remainingDay1){
				$mailContent = str_replace("@APLI_TITLE_REPLACE",$mailApliTitle,$mailContent);
				$mailContent = str_replace("@LEARNER_NAME_REPLACE",$learnerName,$mailContent);
				$sendMail = true;
			}else if($remainingDay == $remainingDay2){
				$mailContent = str_replace("@APLI_TITLE_REPLACE",$mailApliTitle,$mailContent);
				$mailContent = str_replace("@LEARNER_NAME_REPLACE",$learnerName,$mailContent);
				$sendMail = true;
			}else if($remainingDay == $remainingDay3){
				$mailContent = str_replace("@APLI_TITLE_REPLACE",$mailApliTitle,$mailContent);
				$mailContent = str_replace("@LEARNER_NAME_REPLACE",$learnerName,$mailContent);
				$sendMail = true;
			}
			if($sendMail){
				$dest = $learner['SppLearner']['email']; 
				$this->send_email($learnerName,$mailApliTitle,$remainingDay,$dest);
			}
			
		}
		die;
	}
	
	private function send_email($learnerName, $apliTitle, $remainingDay, $dest)
	{
		$this->Email->reset();
		$this->Email->smtpOptions = array(
	     'port'=>'465',
	     'timeout'=>'30',
	     'host' => 'ssl://smtp.gmail.com',
	     'username'=>Configure::read('EMAIL.EMAIL_FROM'),
	     'password'=>Configure::read('EMAIL.EMAIL_PASSWORD')
		);
		$this->Email->delivery = 'smtp';
		$this->Email->from    = Configure::read('EMAIL.EMAIL_FROM');
		$this->Email->to      = $dest;
		$this->Email->subject = Configure::read('REMAINING_DAY_MAIL.TITLE');
		$this->Email->template = 'remaining_template';
		$this->Email->layout = 'remaining_template';
		$this->Email->sendAs = 'text';
		$this->set("learner_name",$learnerName);
		$this->set("apli_title", $apliTitle);
		$this->set("remaining_day", $remainingDay);
		
		$this->Email->send();
		$this->set('smtp_errors', $this->Email->smtpError);
		if(empty($this->Email->smtpError)){
			return true;
		}
		return false;
	}
	
}