<?php
// Application config
$config['Message']['APP_TITLE'] = 'LEC 行政書士○×一問一答式 2022';
$config['PHP']['max_execution_time'] = '10000';		// session timeout (second) セッション有効期間 (秒単位) 
$config['PHP']['max_input_time'] = '10000';
$config['SPP']['remove_old_log_time'] = '-120 days';			

// 成績管理用 カテゴリー定義
$config['study_record']['category_names'] = Array(
'100'=>'﻿憲法',
'200'=>'﻿民法',
'300'=>'﻿行政法',
'400'=>'﻿商法・会社法',
'500'=>'一般知識',
);

// File upload
$config['PHP']['post_max_size'] = '500M';
$config['PHP']['memory_limit'] = '2000M';
$config['PHP']['upload_max_filesize'] = '500M';

// User login management
$config['Message']['PWD_ND_TIME'] = 3;				// 
$config['Message']['TIME_LIMITED'] = 300;			// ログイン失敗有効期間 (秒単位)
$config['Message']['TIME_LOCKED'] = 600;	 		// ログイン失敗ロック期間 (秒単位) 

// Number of record at each page
$config['CALENDAR']['NUMBER_OF_PAGE'] = 15;
$config['USER']['NUMBER_OF_PAGE'] = 20;
$config['CONTENT']['NUMBER_OF_PAGE'] = 100;
$config['LICENSE']['NUMBER_OF_PAGE'] = 100;
$config['TIMELINE']['NUMBER_OF_PAGE'] = 15;	// content timeline
$config['QUESTION']['NUMBER_OF_PAGE'] = 15;
$config['CORRECTION']['NUMBER_OF_PAGE'] = 15;
$config['LEARNER']['NUMBER_OF_PAGE'] = 10;
$config['ORGANIZATION']['NUMBER_OF_PAGE'] = 15;
$config['STUDY_RECORD']['NUMBER_OF_PAGE'] = 10;

// Number quiz incorrect
$config['RANKING']['NUMBER_QUIZ_INCORRECT'] = 20;

// generate license code
$config['LICENSE']['LENGTH'] = 8; // number characters of license code after generated
$config['LICENSE']['INCLUDE_HYPHEN'] = 0; // include hyphen "-" or not (which appear in each 4 characters)
										  // (1: yes; 0: no)
$config['LICENSE']['CHARACTERS'] = '0123456789'; // character may appear in license code
											     // ex: 0123456789 (only number)
												 //     abcdefghijklmnopqrstuvwxyz (only alphabet and lowercase)
												 //     0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPRSTUVWXYZ

// the time to free trial content (by hours)
$config['FREE_USE_TERM'] = 24;

$config['Message']['ERR_CANNOT_DISPLAY_PAGE_PC'] = '指定のページは表示できません。';
$config['Message']['ERR_CANNOT_DISPLAY_PAGE_MOBILE'] = '指定したページは表示できません。';
$config['Message']['ERR_PWD_CONFIRM'] = '新しいパスワードと確認用パスワードの値が一致しません。';
$config['Message']['ERR_PWD_LENGTH'] = 'パスワードは6文字以上入力してください。';
$config['Message']['ERR_CHANGE_PWD'] = 'パスワードに誤りがあります。';
$config['Message']['ERR_UNCHECK_ROLE'] = 'ロールは１つ以上選択してください。';
$config['Message']['ERR_DESC_LENGTH'] = '説明は256バイト以内で入力してください。';
$config['Message']['ERR_PERMISSION'] = 'このページにアクセスする権限がありません。';
$config['Message']['ERR_USERNAME_EMPTY'] = "アカウントを入力してください。";
$config['Message']['ERR_PWD_EMPTY'] = "パスワードを入力してください。";
$config['Message']['ERR_USERNAME_LENGTH'] = "ユーザ名は32文字以内で入力してください。";
$config['Message']['ERR_USERNAME_UNIQUE'] = "このアカウントは既に存在しています。";
$config['Message']['ERR_USERNAME_RULE'] = "アカウントは英数字のみ入力可能です。";
$config['Message']['ERR_PWD_MAXLENGTH'] = "パスワードは50文字以内で入力してください。";
$config['Message']['ERR_PWD_RULE'] = "パスワードは英数字のみ入力可能です。";
$config['Message']['ERR_DESC_EMPTY'] = "説明を入力してください。";

$config['Message']['ERR_LOGGED_IN'] = 'あなたは既に登録しに記録されます。';
$config['Message']['ERR_LOCKED_USER'] = 'このアカウントは現在ロックされています。';

$config['Message']['ERR_CONTENT_CODE'] = 'コンテンツIDを入力してください。';
$config['Message']['ERR_CONTENT_CODE_RULE'] = 'コンテンツIDは英数字、ハイフン（-）、アンダーバー（_）のみ入力可能です。';
$config['Message']['ERR_CONTENT_CODE_EXITS'] = '既にコンテンツIDが登録されています。';
$config['Message']['ERR_CONTENT_CODE_LENGTH'] = 'コンテンツIDは32バイト以内で入力してください。';

$config['Message']['ERR_CONTENT_NAME'] = 'コンテンツ名を入力してください。';
$config['Message']['ERR_CONTENT_NAME_LENGTH'] = 'コンテンツ名は256バイト以内で入力してください。';
$config['Message']['ERR_CONTENT_CHECK'] = '販売方法は１つ以上選択してください。';

$config['Message']['ERR_DATE'] = '販売期間の開始日は、販売期間の終了日より過去日を入力してください。';
$config['Message']['ERR_BEFORE_DESC'] = '説明文(購入前)を入力してください。';
$config['Message']['ERR_AFTER_DESC'] = '説明文(購入後)を入力してください。';

$config['Message']['ERR_DOWNLOAD_DESC'] = '説明文(DL前)を入力してください。';
$config['Message']['ERR_UPLOAD_FILE'] = 'コンテンツファイルを選択してください。';
$config['Message']['ERR_MOVE_FILE'] = 'コンテンツファイル移動エラー。';
$config['Message']['ERR_CONTENT_UPDATED'] = '更新しました。';
$config['Message']['ERR_CONTENT_ADDED'] = '登録しました。';
$config['Message']['ERR_CONTENT_DELETED'] = '削除しました。';

$config['Message']['ERR_CONTENT_BEFOR_LENGTH'] = '説明文（購入前）は2000バイト以内で入力してください。';
$config['Message']['ERR_CONTENT_AFTER_LENGTH'] = '説明文（購入後）は2000バイト以内で入力してください。';
$config['Message']['ERR_CONTENT_COMMENT_LENGTH'] = 'コメントは2000バイト以内で入力してください。';
$config['Message']['ERR_CONTENT_DOWNLOAD_LENGTH'] = '説明文（DL前）は2000バイト以内で入力してください。';

//message for license
$config['Message']['ERR_LICENSE_NUMBER'] = '同時発行数を入力してください。';
$config['Message']['ERR_LICENSE_NUMBER_IS_NUMBERIC'] = '同時発行数は数字のみ入力可能です。';
$config['Message']['ERR_LICENSE_DESC'] = '説明を入力してください。';
$config['Message']['ERR_LICENSE_DESC_MAXLEN'] = '説明は100バイト以内で入力してください。';
$config['Message']['ERR_LICENSE_COMMENT_MAXLEN'] = 'コメントは2000バイト以内で入力してください。';
$config['Message']['ERR_LICENSE_DATE'] = '有効期限の開始日は、有効期限の終了日より過去日を入力してください。';
$config['Message']['ERR_LICENSE_CODE_EXITS'] = '既にライセンスIDが存在しています。';
$config['Message']['ERR_LICENSE_ADDED'] = '登録しました。';
$config['Message']['ERR_LICENSE_DELETED'] = '削除しました。';
$config['Message']['ERR_LICENSE_UPDATED'] = '更新しました。';

$config['Message']['ERR_CHANGEPWD_OLD'] = '現在のパスワードを入力してください。';
$config['Message']['ERR_CHANGEPWD_NEW'] = '新しいパスワードを入力してください。';
$config['Message']['ERR_CHANGEPWD_NEW_CONFIRM'] = '新しいパスワード(確認用)を入力してください。';

$config['Message']['ERR_LOGIN_ERROR'] = "アカウントまたはパスワードに誤りがあります。";

$config['Message']['ADD_SUCCESS'] = '登録しました。';
$config['Message']['EDIT_SUCCESS'] = '更新しました。';
$config['Message']['DELETE_SUCCESS'] = '削除しました。';
$config['Message']['ERR_EXCEPTION'] = 'データの更新に失敗しました。';
$config['Message']['ERR_ADD'] = 'データの登録に失敗しました。';
$config['Message']['ERR_EDIT'] = 'データの更新に失敗しました。';
//haitlt #20522 --start--//
$config['Message']['ERR_UPDATE_CONTENT_ON_WEB_APP'] = '同期に失敗しました。';
$config['Message']['UPDATE_CONTENT_SUCCESS_SYNC_SUCCESS'] = '更新／同期しました。';
//haitlt #20522 --end--//

//Tuanm
$config['Message']['ERR_USER_NUMBER'] = 'ユーザー数を入力してください。';
$config['Message']['ERR_CONSEQUENCE_NUMBER_OF_USER'] = '登録数が２以上の場合、連番を振って下さい。';
$config['Message']['ERR_USERNAME_IN_CHAIN_NOT_UNIQUE'] = '既に存在したユーザがあります。';
$config['Message']['ERR_USERNAME_EMPTY'] = 'ユーザ一IDを入力してください。';
$config['Message']['ERR_USERNAME_EXISTED'] = '既にユーザーが登録されています。';
$config['Message']['ERR_WRONG_FORMAT'] = '指定のフォーマットと異なります。';
$config['Message']['ERR_HAVE_NO_DATA'] = 'ファイルにデータがありません';
$config['Message']['ERR_IMPORT'] = 'システムエラーが発生しました。';
$config['Message']['MSG_ROW_UPDATE'] = ' 件の更新が完了しました';
$config['Message']['MSG_ROW_INSERT'] = ' 件の追加が完了しました。';


$config['Message']['ERR_MISSING_ANSWERED_PERSON'] = ' 回答者は必ず入力してください。';
$config['Message']['ERR_MISSING_ANSWERED_CONTENT'] = ' 回答は必ず入力してください。';
$config['Message']['ERR_MISSING_MARK'] = ' ポイントは必ず入力してください。';
$config['Message']['EDIT_ERROR'] = '更新処理に失敗しました。';
$config['Message']['ERR_MISSING_CORRECTION_PERSON'] = ' 添削者は必ず入力してください。';
$config['Message']['ERR_MISSING_CORRECTION_COMMENT'] = ' 添削コメントは必ず入力してください。';
$config['Message']['ERR_MISSING_CORRECTION_IMAGE'] = ' 添削画像は必ず入力してください。';
$config['Message']['ERR_MISSING_CALENDAR_TITLE_ICON_IMAGE'] = ' 添削画像は必ず入力してください。';

//SPP LEARNER
$config['Message']['ERR_ORGANIZATION_CODE_NOT_EXISTING'] = '入力した利用コードが存在しません。';
$config['Message']['ERR_REGISTRATION_EXCEED'] = '登録数を超えています。';
$config['Message']['ERR_LICENSE_CODE_WRONG'] = '入力されたライセンス番号は使用できません。';

//SPP_ORGANIZATION
$config['Message']['ERR_MISSING_CODE_LARGE'] = 'コードは必ず入力してください。';
$config['Message']['ERR_MISSING_ORGANIZATION_NAME'] = '団体名は必ず入力してください。';
$config['Message']['ERR_MISSING_ALLOWED_REGISTRATION_NO'] = '登録許可数は必ず入力してください。';
$config['Message']['ERR_ALLOWED_REGISTRATION_NO_INVALID'] = '登録許可数は無効です。';
$config['Message']['ERR_ALLOWED_REGISTRATION_NO_SMALL'] = '登録許可数は登録数以上を設定してください。';
$config['Message']['ERR_MISSING_DAYS_OF_USAGE'] = '利用日数または利用期限を入力して下さい。';
$config['Message']['ERR_DAYS_OF_USAGE_INVALID'] = '利用日数は無効です。';
$config['Message']['ERR_ORGANIZATION_CODE_EXISTING'] = '利用コードは存在しています。';
$config['Message']['ERR_CAN_NOT_DELETED_ORG'] = '学習者がありますから、削除できません。';
// SPP_RANK_MASTER
$config['Message']['ERR_MISSING_RANK_NAME'] = ' 名称は必ず入力してください。';
$config['Message']['ERR_MISSING_EXTEND_DAYS'] = ' 特典（期間延長）は必ず入力してください。';
$config['Message']['ERR_MISSING_RANK_IMAGE'] = ' 画像は必ず入力してください。';
$config['Message']['ERR_IMAGE_INVALID'] = ' jpgファイル、またはpngファイルをアップロードしてください。';


$config['Message']['INSERT_SUCCESS'] = '登録しました。';
$config['Message']['INSERT_FAILURE'] = '登録は失敗しました。もう一度やてください。';
$config['Message']['UPDATE_SUCCESS'] = '更新しました。';
$config['Message']['ERR_MISSING_ITEM'] = '必須項目は必ず入力してください。';
$config['Message']['EMAIL_EXISTED'] = '入力したメールアドレスは存在しています。';
$config['Message']['EMAIL_REQUIRED'] = 'メールアドレスは必ず入力してください。';
$config['Message']['NAME_REQUIRED'] = '氏名 は必要です';
$config['Message']['NAME_KANA_REQUIRED'] = '氏名かな は必要です。';

$config['Message']['POSTAL_CODE_REQUIRED'] = '郵便番号は必要です。';
$config['Message']['ZONE_REQUIRED'] = '都道府県は必要です。';
$config['Message']['ADDRESS_REQUIRED'] = '市区町村は必要です。';
$config['Message']['ADDRESS_DETAIL_REQUIRED'] = '番地・ビル名は必要です。';


$config['Message']['ERR_MISSING_EMAIL'] = 'メールアドレスが入力されていません。';
$config['Message']['ERR_MISSING_ORGANIZATION_CODE'] = '利用コードが入力されていません。';
$config['Message']['ERR_EMAIL_EXISTED'] = 'メールアドレスは登録済みです。';
$config['Message']['ERR_ORGANIZATION_CODE_EXISTED'] = '利用コードが存在しません。';
$config['Message']['ERR_REGISTRATION_LEARNER_EXCEED'] = '登録可能数を越えました。';

$config['Message']['ERR_NO_CONTENT'] = 'コンテンツは存在しません。';
$config['Message']['ERR_UPDATE_QUIZZ_FAILURE'] = '問題更新処理が失敗しました。';
$config['Message']['UPDATE_QUIZZ_SUCCESS'] = 'データ展開が終了しました。';

$config['Message']['LICENSE_REGISTED_NUMBER_SUCCESS_CODE'] = '1';
$config['Message']['LICENSE_REGISTED_NUMBER_FAIL_CODE'] = '2';

//content timeline
$config['Message']['ERR_AUDIO_EXT'] = '不正な形式のmp3ファイル';
$config['Message']['ERR_TITLE_FILE_EMTPY'] = 'タイトルを選択していないながら、TOPは、画像上に表示することができません';
$config['Message']['ERR_CONTENT_LENGHT'] = '内容は2500文字より長くないかもしれません';

$config['Message']['ERR_MISSING_CONTENT_ID'] = 'コンテンツIDは必要です。';
$config['Message']['ERR_MISSING_CATEGORY_NO'] = 'カテゴリIDは必要です。';
$config['Message']['ERR_MISSING_SUBCATEGORY_NO'] = 'サブカテゴリIDは必要です。';
$config['Message']['ERR_MISSING_QUIZ_NO'] = '問題番号は必要です。';

$config['Message']['ERR_WRONG_CONTENT_ID'] = 'コンテンツIDが存在しません。';
$config['Message']['ERR_WRONG_CATEGORY_NO'] = 'カテゴリIDが存在しません。';
$config['Message']['ERR_WRONG_SUBCATEGORY_NO'] = 'サブカテゴリが存在しません。';
$config['Message']['ERR_WRONG_QUIZ_NO'] = '問題番号が存在しません。';

//Push information
//display record number
$config['Push']['display_number'] = 5;
$config['Push']['message_required'] = 'メッセージを入力してください。';
$config['Push']['message_max_length'] = 'メッセージは218byte以下入力してください。';
$config['Push']['message_delete_confirm'] = 'メッセージを削除しますか？';

//IOS
$config['Push']['passphrase'] = '123456';
$config['Push']['certpath']= APP. "webroot/files/test.pem";
$config['Push']['Certification_Authority']= APP. "webroot/files/Certification_Authority.pem";

$config['Push']['apns']='ssl://gateway.push.apple.com:2195';
//$config['Push']['apns']='ssl://gateway.sandbox.push.apple.com:2195';
$config['Push']['iosRetry'] = 'YES';

//Android
$config['Push']['android'] = 'https://android.googleapis.com/gcm/send';
$config['Push']['androidapikey'] = 'AIzaSyDkas7C5tPbZhN5dkdiyvQYvKxLbGBYWKE';


//Chart
$config['Chart']['COLS'] = 10;

//WebAdmin Name
$config['User']['WEBADMIN'] = 'webadmin';

//SPP_WEB Server
$config['SPP_WEB']['URL'] = 'http://localhost/SPP_Web/';

//SysAdmin Name
$config['User']['SYSADMIN'] = 'sysadmin';
$config['UserID']['SYSADMIN'] = 1;
$config['CLIENT_ADMIN'] = 0;

// USER_ROLE
$config['ROLE']['SYSTEM_MANAGEMENT'] = 'SYSTEM_MANAGEMENT';
$config['ROLE']['SUPPORT'] = 'SUPPORT';
$config['ROLE']['ACHIEVEMENT_MANAGEMENT'] = 'ACHIEVEMENT_MANAGEMENT';
// path config
$config['IMG_CORRECTION'] = 'files/uploads/correction/';
$config['IMG_RANK'] = 'files/uploads/ranks/';
$config['IMG_CALENDAR_CONTENT'] = 'files/uploads/calendar_contents/';
// content timeline
$config['IMG_TIMELINE_CONTENT'] = 'files/uploads/timeline_contents/';
$config['AUDIO_TIMELINE_CONTENT'] = 'files/uploads/timeline_audio_contents/';

//DELIVERY TYPE
$config['DELIVERY_TYPE_ALL'] = 0;
$config['DELIVERY_TYPE_SPECIFIED'] = 1;

// LEARNER_CLASSIFICATION
$config['LEARNER_CLASSIFICATION']['GENERAL'] = 1;
$config['LEARNER_CLASSIFICATION']['BUSSINESS'] = 2;
$config['LEARNER_CLASSIFICATION']['BLOCK'] = 3;

// PAYMENT METHODS
$config['PAYMENT_METHOD']['PERSONAL'] = 'A';
$config['PAYMENT_METHOD']['COMPANY'] = 'B';
$config['PAYMENT_METHOD']['STORE'] = 'C';

// PAYMENT STATUS
$config['PAYMENT_STATUS']['PAID'] = 1;
$config['PAYMENT_STATUS']['UNPAID'] = 2;

// PERSONAL
$config['PERSONAL_CODE'] = '8998';


// DEFAULT LICENSE COMMENT
$config['LICENSE']['DEFAULT_COMMENT'] = '自動設定';

// SENT EMAIL
$config['EMAIL']['TITLE'] = '【学習アプリ】パスワードを忘れた場合';
$config['EMAIL']['EMAIL_FROM'] = 'fstp.app22@gmail.com';
$config['EMAIL']['EMAIL_PASSWORD'] = 'Fstpadmin1';
$config['REMAINING_DAY_MAIL']['REMAINING_DAYS1'] = 2;
$config['REMAINING_DAY_MAIL']['REMAINING_DAYS2'] = 20;
$config['REMAINING_DAY_MAIL']['REMAINING_DAYS3'] = 30;
$config['REMAINING_DAY_MAIL']['APLI_TITLE'] = "apli title";
$config['REMAINING_DAY_MAIL']['TITLE']="利用期日のお知らせ";
// DEFAULT IMAGE WIDTH FOR CORRECTION IMAGE
$config['CORRECTION']['IMAGE_WIDTH'] = 760; // 760px

// FLAG CHECK WHETHER SHOW ADDRESS (住所) OR NOT
$config['LEARNER']['SHOW_ADDRESS'] = 0; // 1 or 0

// SHOW お問い合わせ番号 ITEM ON SETTING SCREEN (ON MOBILE APP)
$config['SETTING']['SHOW_LICENSE_INPUT'] = 0; // 1 or 0
$config['LOGIN']['LOGIN_LIMIT'] = 0;

// Config list API server
$config['SPP_SERVER_API'] = [
    'https://lec.pw-app.com',        // We will clear after when release vesion  final
    'https://lec-gyosho2022.pw-app.com',  // We will clear after when release vesion  final
];
